function obs = create_obs(typ, dims)
% CREATE_OBS - creates an empty observation struct
%
% obs = create_obs(typ, dims);
%
% Input: typ - The observation type (either 'slice' or 'volume')
%        dims - an array of the form [x y z] which indicates the dimension
%               of the full set of observations
%
% Output: obs - the output observation struct

% first, make sure that the dimensions make sense
if length(dims) ~= 3
    error(['Argument dims should be an array of length 3 [x y z]']);
end
if min(dims) <= 0
    error(['Each element in dims should be >= 0']);
end

if strcmp(typ, 'slice')

    % create the slice-style observations
    obs = struct('type', 'slice', ...
                 'data', {{}}, ...
                 'raters', [], ...
                 'slices', [], ...
                 'dims', dims, ...
                 'num_obs', 0);

elseif strcmp(typ, 'volume')
    % create the volume-syle observations
    obs = struct('type', 'volume', ...
                 'data', {{}}, ...
                 'dims', dims, ...
                 'num_obs', 0);
else
    error(['Unknown observation type: ', typ]);
end
