function [fracconsensus] = fraction_consensus(obs)
% FRACTION_CONSENSUS - calculate the Fraction voxels (non-background) that are
%                      cosnensus
%
% [fraccorrect] = fraction_consensus(obs)
%
% Input: obs - the observations used to construct the estimate
%              returns fraction consensus over the actual "volume"
%
% Output: fracconsensus - The fraction of total voxels that are in consensus

% find the background voxels
vals = zeros(obs.dims);
if strcmp(obs.type, 'slice')
    for o = 1:obs.num_obs
        vals(:, :, obs.slices(o)) = vals(:, :, obs.slices(o)) + ...
                                    abs(double(obs.data{o}));
    end
elseif strcmp(obs.type, 'volume')
    for o = 1:obs.num_obs
        vals = vals + abs(double(obs.data{o}));
    end
else
    error('Unrecognized Observation type');
end

% find the consensus voxels
[MV_est MV_W] = majority_vote(obs);
max_MV_W = max(MV_W, [], 4);

% find the non-background consensus voxels
fracconsensus = length(find(vals > 0 & max_MV_W == 1)) / length(find(vals > 0));
