function obs_training = get_fraction_training(obs_full, obs_testing, frac)
% GET_FRACTION_TRAINING - returns a random set of training observations
%                         given the full observation set and smaller subset
%                         of testing observations.
%
% Note: Must use 'slice-type' observations
%
% Input: obs_full - the full observation set
%        obs_testing - the set of observations that will be used
%        frac - the fraction of slices that are treated as training
%
% Output: obs_training - the new training set of observations
%
% Note on "frac" and the number of training observations for a given rater
% Say given rater, r, observed 'x' slices. The number of training observations
% for that rater, y, would be:
%
% y = frac * x;
%

% create the new training observations
obs_training = create_obs('slice', obs_testing.dims);

% get the unique raters
unique_raters = unique(obs_testing.raters);

% iterate over each rater
for r = 1:length(unique_raters)

    % get some of the numbers
    num_testing = length(find(obs_testing.raters == unique_raters(r)));
    num_training = ceil(frac * num_testing);
    num_possible = length(find(obs_full.raters == unique_raters(r)));

    % set the indices we want
    inds = find(obs_full.raters == unique_raters(r));
    if (num_possible < num_training)
        sinds = inds;
    else
        rp = randperm(num_training);
        sinds = inds(rp(1:num_training));
    end

    % add each observation
    for s = 1:length(sinds)
        obs_training = add_obs(obs_training, obs_full.data{sinds(s)}, ...
                               obs_full.slices(sinds(s)), ...
                               obs_full.raters(sinds(s)));
    end
end



