function obs_slice = get_slice_from_obs(obs, sl)
% GET_SLICE_FROM_OBS - Returns a full coverage observation of a single slice
%                      from a set of 'sparse' observations
%
% obs_slice = get_slice_from_obs(obs, sl);
%
% Input: obs - a set of sparse 'slice' style observations
%        sl - the slice of interest
%
% Output: obs_slice - the "full coverage" observation set for a single slice

% verify the observation type
if ~strcmp(obs.type, 'slice')
    error('Observation type must be "slice"');
end

% create the generic observation struct
obs_slice = create_obs('slice', [obs.dims(1) obs.dims(2) 1]);

% get the indices corresponding to the slice of interest
sinds = find(obs.slices == sl);

% get the unique raters that observed this slice
uniqueraters = unique(obs.raters(sinds));

for i = 1:length(uniqueraters)
    rinds = find(obs.raters(sinds) == uniqueraters(i));
    rp = randperm(length(rinds));

    obs_slice = add_obs(obs_slice, obs.data{sinds(rinds(rp(1)))}, 1, uniqueraters(i));
end


