function val = kld(xi, dens1, dens2)
% kld - calculate the kullback-leibler divergence for two distributions
%
% val = kld(xi, dist1, dist2)
%
% Input: xi - the values for which the probability distributions are calculated
%        dist1 - the first distribution
%        dist2 - the second distribution
%
% Output: val - the kullback-leibler divergence

vals = log(dens1 ./ dens2) .* dens1;
vals(isnan(vals)) = 0;
vals(isinf(vals)) = 0;
val = trapz(xi, vals);

