function [varargout] = majority_vote(obs)
% MAJORITY_VOTE - performs the majority vote algorithm
%
% Two forms:
% 1) estimate = majority_vote(obs);
% 2) [estimate W] = majority_vote(obs);
%
% Input: obs - observation struct
%
% Output estimate - estimate of the true segmentation
%        W (optional) - the label probabilities for each voxel
%

% create the java observation object
obsjava = create_java_obs(obs);
% run the majority vote algorithm
if nargout == 1
    % run the constructor on the staple class (initialize)
    mv = edu.vanderbilt.masi.LabelFusion.MajorityVote(obsjava, 1);
    varargout{1} = uint8(mv.run());
elseif nargout == 2
    % run the constructor on the staple class (initialize)
    mv = edu.vanderbilt.masi.LabelFusion.MajorityVote(obsjava, 0);
    varargout{1} = uint8(mv.run());
    varargout{2} = mv.get_W();
else
    error('Too many output arguments');
end
