function [str,idcode,labelnum,parent,treedepth] = parseRTF(filename)

fp = fopen(filename,'rt');
line = '';
while(isempty(strfind(line,'stylesheet')))
    line = fgetl(fp);
end
line = fgetl(fp);
LL={};
while(~isnumeric(line))
    line = '';
    i=1;
    clear L
    while(and(isempty(strfind(line,'\par}')),~isnumeric(line)))
        line = fgetl(fp);
        if(isnumeric(line))
            break;
        end
        L{i}=line;
        i=i+1;
    end
    LL{end+1}=L;
end
clear str;
str={};
for i=1:length(LL)
    if(length(LL{i})>1)
        str{end+1} = LL{i}{3};
        li=regexp(LL{i}{1},'\li(?<li>[0-9]+)','names');
        if(length(li)>0)
            indentlevel(length(str))=str2num(li.li);
        else
            indentlevel(length(str))=0;
        end

        id=regexp(LL{i}{3},'((?<id>[0-9]+)','names');
        if(length(id)>0)
            if length(id) >= 3
                error('Something is wrong %s', str{end});
            elseif length(id) == 2
                idcode{length(str)} = ['9', id(2).id];
                labelnum(length(str)) = str2num(id(1).id);
            else
                idcode{length(str)} = ['9', id(1).id];
                labelnum(length(str)) = -1;
            end
        else
            disp(LL{i}{3});
            idcode{length(str)}='-1';
            labelnum(length(str)) = -1;
        end


    end
end

treedepth = indentlevel/200;

parent(1) = 0;
for i=2:length(str)
    parent(i)=max(find(treedepth(1:(i-1))==(treedepth(i)-1)));
end



fclose(fp);
