function maskout = hysteresis(maskin,im_mag,thresholds)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% thresholding function
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


% im - binary image of possible edges
% im_mag - gradient magnitude image
% thresholds - [high & low] thresholds for hysteresis

% create thresholds, if missing
if strcmp(thresholds, 'auto');                                            
    % normalize gradient image (& remove outliers)
    im_mag = img_normalize(im_mag,[.5 99.9]);
    
    % convert to probability
    im_mag = exp(-1*(max(im_mag(:))-im_mag)); 
    
    % set thresholds
    thresholds = [0.5 0.99];
end

maskout = maskin & (im_mag>=thresholds(1));

