

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% nonmaximag suppression (thinning) 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function im_thin = nonmax_sup(gx,gy,gz)

% find gradient magnitude 
gmag = sqrt(gx.^2+gy.^2+gz.^2);

% sort of non-maximal suppression? Seems right.enough
[w,h,d] = size(gx);
[x,y,z] = meshgrid(1:h,1:w,1:d);

xi = x - gx./gmag;
yi = y - gy./gmag;
zi = z - gz./gmag;
imtemp = interp3(x,y,z,gmag,xi,yi,zi);

xi = x + gx./gmag;
yi = y + gy./gmag;
zi = z + gz./gmag;
imtemp2 = interp3(x,y,z,gmag,xi,yi,zi);

im_thin = gmag & ((imtemp<gmag) & (imtemp2<gmag));