function data = read_nls_file(fname, numdims, typ, varargin)
% READ_NLS_FILE - reads a .mff file format that comes from Non-Local STAPLE
%
% data = read_nls_file(fname, numdims, typ)
%
% Input: fname - the filename to read
%        numdims - the number of dimensions in the data
%        typ - the type of the data to read (e.g., 'double', 'uint8')
%
% Output: data - the read data from the file

% open the filename
fid = fopen(fname, 'r');

% read the dimensions
tempdims = fread(fid, numdims, 'uint64');

% read the data
tempdata = fread(fid, prod(tempdims), typ);

% close the filehandle
fclose(fid);

% reshape and permute the data to get it into the right format
if length(varargin) == 1
    data = reshape(tempdata, tempdims');
else
    data = reshape(tempdata, [tempdims(numdims:-1:1)']);
    data = permute(data, [numdims:-1:1]);
end
