function render_3D_estimate(truth, estimate, fignum, res_dims, cvec)
% RENDER_3D_ESTIMATE - renders a 3D representation of a segmentation estimate
%                      with respect to voxelwise surface distance
%
% render_3D_estimate(truth, estimate, fignum, res_dims, cvec)
%
% Input: truth - the true segmentation
%        estimate - the estimated segmentation
%        fignum - the figure number to show the result
%        res_dims - the resolution of the X Y Z dimensions
%        cvec - the color limits
%
% Output: None


iso1 = isosurface(truth == 1, 0);
iso2 = isosurface(estimate == 1, 0);

num = size(iso1.vertices, 1);
num2 = size(iso2.vertices, 1);

dist = zeros([num, 1]);

for i = 1:num
    diffs = iso2.vertices - repmat(iso1.vertices(i, :), [num2 1]);
    diffs = diffs .* repmat(res_dims, [size(diffs, 1), 1]);
    diffs = sqrt(sum(diffs.^2, 2));
    dist(i) = min(diffs);
end

figure(fignum); clf;
patch('Vertices', iso1.vertices, ...
      'Faces', iso1.faces, ...
      'FaceVertexCData', dist, ...
      'FaceColor', 'interp', ...
      'EdgeColor', 'none');
daspect(1 ./ res_dims);
colormap(hot);
colorbar;
view(90, -90);
shading interp;
set(gca, 'Visible', 'off')
caxis(cvec);

