function render_3D_estimate_label(truth, estimate, fignum, res_dims, cvec)
% RENDER_3D_ESTIMATE - renders a 3D representation of a segmentation estimate
%                      with respect to voxelwise surface distance
%
% render_3D_estimate(truth, estimate, fignum, res_dims, cvec)
%
% Input: truth - the true segmentation
%        estimate - the estimated segmentation
%        fignum - the figure number to show the result
%        res_dims - the resolution of the X Y Z dimensions
%        cvec - the color limits
%
% Output: None


iso0 = isosurface(truth == 1, 0);
iso1 = isosurface(truth == 2, 0);
iso2 = isosurface(estimate == 2, 0);

num0 = size(iso0.vertices, 1);
num = size(iso1.vertices, 1);
num2 = size(iso2.vertices, 1);

dist = zeros([num, 1]);

for i = 1:num
    diffs = iso2.vertices - repmat(iso1.vertices(i, :), [num2 1]);
    %diffs = diffs .* repmat(res_dims, [size(diffs, 1), 1]);
    diffs = sqrt(sum(diffs.^2, 2));
    dist(i) = min(diffs);
end

figure(fignum); clf;
p0 = patch('Vertices', iso0.vertices, ...
           'Faces', iso0.faces, ...
           'FaceVertexCData', repmat([0.5 0.5 0.5], [num0 1]), ...
           'FaceColor', 'interp', ...
           'EdgeColor', 'none', ...
           'FaceAlpha', 0.3);
hold on;
p1 = patch('Vertices', iso1.vertices, ...
           'Faces', iso1.faces, ...
           'FaceVertexCData', dist, ...
           'FaceColor', 'interp', ...
           'EdgeColor', 'none');
hold off;
daspect(1 ./ res_dims);
colormap(hot);
view(90, 60);
set(gca, 'Visible', 'off')
caxis(cvec);

