function [ordered_array num_unique] = reorder_array(unordered_array)
% REORDER_ARRAY - reorders the array to be consecutive and start from zero
%
% [ordered_array num_unique] = reorder_array(unordered_array);
%
% Input: unorderered_array - the original array
% Output: ordered_array - the "fixed" array
%         num_unique - the number of "unique" elements in the array

% find the unique values
uniquedata = unique(unordered_array);

% use a temporary array to make the values unique from 1 to the number of
% unique values
tmpdata = unordered_array;
for i = 1:length(uniquedata)
    tmpdata(unordered_array == uniquedata(i)) = i-1;
end

% save the temporary array as the new, ordered array
ordered_array = tmpdata;

% save the number of unique values in case the user wants it
num_unique = length(uniquedata);
