function im = resample_vol(in_vol, in_res, out_res, interp_type);
% RESAMPLE_VOL - resamples an input volume (currently 3D only)
%
% im = resample_vol(in_vol, in_res, out_res, interp_type);
%
% Input: in_vol - the input volume X x Y x Z matrix
%        in_res - the input voxel resolution (e.g., [1 1 1]);
%        out_res - the output voxel resolution (e.g., [2 2 2]);
%        interp_type - the interpolation type to use (e.g., 'linear')
%                    - see "help interpn" for the available options
%
% Output: out_vol - the resample volume
%

dims = size(in_vol);
rates = out_res ./ in_res;

[x1 y1 z1] = ndgrid(1:dims(1), 1:dims(2), 1:dims(3));
[x2 y2 z2] = ndgrid(1:rates(1):dims(1), 1:rates(2):dims(2), 1:rates(3):dims(3));

im = interpn(x1, y1, z1, double(in_vol), x2, y2, z2, interp_type);

