function obs = rm_obs(obs, obs_num)
% RM_OBS - Removes an observation for the observation struct
%
% obs = rm_obs(obs, obs_num);
%
% Input: obs - The previous observation struct
%        obs_num - The observation number (or numbers) to remove.
%                  to remove more than one observation just put the numbers
%                  in the form of an array.
%
% Output: obs - The output observation struct with the removed observation

if ~isstruct(obs)
    error('The input argument "obs" should be an observation struct (see create_obs.m');
end

% determine which observations to keep
full_set = [1:obs.num_obs];
new_set = setdiff(full_set, obs_num);

keyboard;

% if the observation struct is of slice-type
if strcmp(obs.type, 'slice')

    % handle the slice-type
    obs.num_obs = length(new_set);
    obs.data = obs.data(new_set);
    obs.slices = obs.slices(new_set);
    obs.raters = obs.raters(new_set);

elseif strcmp(obs.type, 'volume')

    % handle the volume-type
    obs.num_obs = length(new_set);
    obs.data = obs.data(new_set);
else

    % something strange is going on
    error('The observations struct should be of type "slice" or "volume"');

end

