function [varargout] = weighted_vote(obs, weights)
% WEIGHTED_VOTE - performs the weighted vote algorithm
%
% There are 4 forms:
% 1) estimate = weighted_vote(obs, global_weights);
% 2) [estimate W] = weighted_vote(obs, global_weights);
% 3) estimate = weighted_vote(obs, voxel_weights);
% 4) [estimate W] = weighted_vote(obs, voxel_weights);
%
% Input: obs - observation struct
%        global_weights - an R-vector indicating weights for each rater
%        voxel_weights - a collection of doubles that is X x Y x Z x R
%                        where X, Y, and Z are the dims of the observations
%                        and R is the number of raters
% Output estimate - estimate of the true segmentation
%        W - the label probabilities at each voxel

% do just a little bit of error checking
if strcmp(obs.type, 'slice')
    num_raters = length(unique(obs.raters));
else
    num_raters = obs.num_obs;
end

% create the java observation object
obsjava = create_java_obs(obs);

if nargout == 1
    % run the constructor on the staple class (initialize)
    wv = edu.vanderbilt.masi.LabelFusion.WeightedVote(obsjava, weights, 1);
    varargout{1} = uint8(wv.run());
elseif nargout == 2
    % run the constructor on the staple class (initialize)
    wv = edu.vanderbilt.masi.LabelFusion.WeightedVote(obsjava, weights);
    varargout{1} = uint8(wv.run());
    varargout{2} = wv.get_W();
else
    error('Too many output arguments');
end

