function hump = add_hump(xval, yval, zval, sigx, sigy, sigz, a)
% ADD_HUMP - creates a continuous gaussian "hump"
%   - Useful for simulations where intensity images are important
%
% hump = add_hump(xval, yval, zval, sigx, sigy, sigz, a)
%
% Input: xval - vector of x-values
%        yval - vector of y-values
%        zval - vector of z-values
%        sigx - standard deviation of guassian distribution in x-direction
%        sigy - standard deviation of guassian distribution in y-direction
%        sigz - standard deviation of guassian distribution in z-direction
%        a - amplitude of distribution
%
% Output - hump - 3D volume of gaussian distribution
%

hump = zeros([length(xval) length(yval) length(zval)]);
for x = 1:length(xval)
    for y = 1:length(yval)
        for z = 1:length(zval)
            hump(x, y, z) = a * exp(-((xval(x))^2/(2*sigx^2) + ...
                                      (yval(y))^2/(2*sigy^2) + ...
                                      (zval(z))^2/(2*sigz^2)));
        end
    end
end

