function [data df] = apply_deformation_field_model(truth, cr, std_coef);
% APPLY_DEFORMATION_FIELD_MODEL - Applies a random deformation field to an
%                                 observation
%
% [data df] = apply_deformation_field_model(truth, cr, std_coef);
%
% Input: truth - the true "segmentation"
%        cr - the cropping region for the deformation field
%        std_coef - the standard deviation of the random coefficients
% Output: data - the observation of the true segmentation
%         df - the deformation field
%

dims = size(truth);
if length(dims) == 2
    dims = [dims, 1];
end

% determine the size of the window
lx = (cr(2) - cr(1) + 1);
ly = (cr(4) - cr(3) + 1);
lz = (cr(6) - cr(5) + 1);

% construct the deformation fields
dx = zeros(lx, ly, lz);
dy = zeros(lx, ly, lz);
dx_full = zeros(dims(1), dims(2), dims(3));
dy_full = zeros(dims(1), dims(2), dims(3));
dz_full = zeros(dims(1), dims(2), dims(3));

% define x and y
xv = linspace(-1, 0.9, lx);
yv = linspace(-1, 0.9, ly);
zv = linspace(-1, 0.9, lz);

% create the chebyshev polynomial coefficients
cx = std_coef * randn([75 , 1]);
cy = std_coef * randn([75 , 1]);
cz = std_coef * randn([75 , 1]);

% iterate over each voxel
for x = 1:lx
    for y = 1:ly
        for z = 1:lz
            i = xv(x);
            j = yv(y);
            k = zv(z);
            T0x = 1;
            T1x = i;
            T2x = 2*i^2 - 1;
            T3x = 4*i^3 - 3*i;
            T4x = 8*i^4 - 8*i^2 + 1;
            T5x = 16*i^5 - 20*i^3 + 5*i;
            T6x = 32*i^6 - 48*i^4 + 18*i^2 - 1;

            T0y = 1;
            T1y = j;
            T2y = 2*j^2 - 1;
            T3y = 4*j^3 - 3*j;
            T4y = 8*j^4 - 8*j^2 + 1;
            T5y = 16*j^5 - 20*j^3 + 5*j;
            T6y = 32*j^6 - 48*j^4 + 18*j^2 - 1;

            T0z = 1;
            T1z = k;
            T2z = 2*k^2 - 1;
            T3z = 4*k^3 - 3*k;
            T4z = 8*k^4 - 8*k^2 + 1;
            T5z = 16*k^5 - 20*k^3 + 5*k;
            T6z = 32*k^6 - 48*k^4 + 18*k^2 - 1;

            dx(x, y, z) = ...
                   cx(1) * T0x + cx(2) * T1x + cx(3) * T2x + cx(4) * T3x + ...
                   cx(5) * T4x + cx(6) * T5x + cx(7) * T6x + ...
                   cx(8) * T2x*T2y + cx(9) * T2x*T3y + cx(10) * T2x*T3y + ...
                   cx(11) * T2x*T4y + cx(12) * T2x*T5y + cx(13) * T2x*T6y + ...
                   cx(14) * T3x*T2y + cx(15) * T3x*T3y + cx(16) * T3x*T3y + ...
                   cx(17) * T3x*T4y + cx(18) * T3x*T5y + cx(19) * T3x*T6y + ...
                   cx(20) * T4x*T2y + cx(21) * T4x*T3y + cx(22) * T4x*T3y + ...
                   cx(23) * T4x*T4y + cx(24) * T4x*T5y + cx(25) * T4x*T6y + ...
                   cx(26) * T5x*T2y + cx(27) * T5x*T3y + cx(28) * T5x*T3y + ...
                   cx(29) * T5x*T4y + cx(30) * T5x*T5y + cx(31) * T5x*T6y + ...
                   cx(32) * T6x*T2y + cx(33) * T6x*T3y + cx(34) * T6x*T3y + ...
                   cx(35) * T6x*T4y + cx(36) * T6x*T5y + cx(37) * T6x*T6y + ...
                   cx(38) * T2x*T2z + cx(39) * T2x*T3z + cx(40) * T2x*T3z + ...
                   cx(41) * T2x*T4z + cx(42) * T2x*T5z + cx(43) * T2x*T6z + ...
                   cx(44) * T3x*T2z + cx(45) * T3x*T3z + cx(46) * T3x*T3z + ...
                   cx(47) * T3x*T4z + cx(48) * T3x*T5z + cx(49) * T3x*T6z + ...
                   cx(50) * T4x*T2z + cx(51) * T4x*T3z + cx(52) * T4x*T3z + ...
                   cx(53) * T4x*T4z + cx(54) * T4x*T5z + cx(55) * T4x*T6z + ...
                   cx(56) * T5x*T2z + cx(57) * T5x*T3z + cx(58) * T5x*T3z + ...
                   cx(59) * T5x*T4z + cx(60) * T5x*T5z + cx(61) * T5x*T6z + ...
                   cx(62) * T6x*T2z + cx(63) * T6x*T3z + cx(64) * T6x*T3z + ...
                   cx(65) * T6x*T4z + cx(66) * T6x*T5z + cx(67) * T6x*T6z;

            dy(x, y, z) = ...
                   cy(1) * T0y + cy(2) * T1y + cy(3) * T2y + cy(4) * T3y + ...
                   cy(5) * T4y + cy(6) * T5y + cy(7) * T6y + ...
                   cy(8) * T2y*T2x + cy(9) * T2y*T3x + cy(10) * T2y*T3x + ...
                   cy(11) * T2y*T4x + cy(12) * T2y*T5x + cy(13) * T2y*T6x + ...
                   cy(14) * T3y*T2x + cy(15) * T3y*T3x + cy(16) * T3y*T3x + ...
                   cy(17) * T3y*T4x + cy(18) * T3y*T5x + cy(19) * T3y*T6x + ...
                   cy(20) * T4y*T2x + cy(21) * T4y*T3x + cy(22) * T4y*T3x + ...
                   cy(23) * T4y*T4x + cy(24) * T4y*T5x + cy(25) * T4y*T6x + ...
                   cy(26) * T5y*T2x + cy(27) * T5y*T3x + cy(28) * T5y*T3x + ...
                   cy(29) * T5y*T4x + cy(30) * T5y*T5x + cy(31) * T5y*T6x + ...
                   cy(32) * T6y*T2x + cy(33) * T6y*T3x + cy(34) * T6y*T3x + ...
                   cy(35) * T6y*T4x + cy(36) * T6y*T5x + cy(37) * T6y*T6x + ...
                   cy(38) * T2y*T2z + cy(39) * T2y*T3z + cy(40) * T2y*T3z + ...
                   cy(41) * T2y*T4z + cy(42) * T2y*T5z + cy(43) * T2y*T6z + ...
                   cy(44) * T3y*T2z + cy(45) * T3y*T3z + cy(46) * T3y*T3z + ...
                   cy(47) * T3y*T4z + cy(48) * T3y*T5z + cy(49) * T3y*T6z + ...
                   cy(50) * T4y*T2z + cy(51) * T4y*T3z + cy(52) * T4y*T3z + ...
                   cy(53) * T4y*T4z + cy(54) * T4y*T5z + cy(55) * T4y*T6z + ...
                   cy(56) * T5y*T2z + cy(57) * T5y*T3z + cy(58) * T5y*T3z + ...
                   cy(59) * T5y*T4z + cy(60) * T5y*T5z + cy(61) * T5y*T6z + ...
                   cy(62) * T6y*T2z + cy(63) * T6y*T3z + cy(64) * T6y*T3z + ...
                   cy(65) * T6y*T4z + cy(66) * T6y*T5z + cy(67) * T6y*T6z;

            dz(x, y, z) = ...
                   cz(1) * T0z + cz(2) * T1z + cz(3) * T2z + cz(4) * T3z + ...
                   cz(5) * T4z + cz(6) * T5z + cz(7) * T6z + ...
                   cz(8) * T2z*T2x + cz(9) * T2z*T3x + cz(10) * T2z*T3x + ...
                   cz(11) * T2z*T4x + cz(12) * T2z*T5x + cz(13) * T2z*T6x + ...
                   cz(14) * T3z*T2x + cz(15) * T3z*T3x + cz(16) * T3z*T3x + ...
                   cz(17) * T3z*T4x + cz(18) * T3z*T5x + cz(19) * T3z*T6x + ...
                   cz(20) * T4z*T2x + cz(21) * T4z*T3x + cz(22) * T4z*T3x + ...
                   cz(23) * T4z*T4x + cz(24) * T4z*T5x + cz(25) * T4z*T6x + ...
                   cz(26) * T5z*T2x + cz(27) * T5z*T3x + cz(28) * T5z*T3x + ...
                   cz(29) * T5z*T4x + cz(30) * T5z*T5x + cz(31) * T5z*T6x + ...
                   cz(32) * T6z*T2x + cz(33) * T6z*T3x + cz(34) * T6z*T3x + ...
                   cz(35) * T6z*T4x + cz(36) * T6z*T5x + cz(37) * T6z*T6x + ...
                   cz(38) * T2z*T2y + cz(39) * T2z*T3y + cz(40) * T2z*T3y + ...
                   cz(41) * T2z*T4y + cz(42) * T2z*T5y + cz(43) * T2z*T6y + ...
                   cz(44) * T3z*T2y + cz(45) * T3z*T3y + cz(46) * T3z*T3y + ...
                   cz(47) * T3z*T4y + cz(48) * T3z*T5y + cz(49) * T3z*T6y + ...
                   cz(50) * T4z*T2y + cz(51) * T4z*T3y + cz(52) * T4z*T3y + ...
                   cz(53) * T4z*T4y + cz(54) * T4z*T5y + cz(55) * T4z*T6y + ...
                   cz(56) * T5z*T2y + cz(57) * T5z*T3y + cz(58) * T5z*T3y + ...
                   cz(59) * T5z*T4y + cz(60) * T5z*T5y + cz(61) * T5z*T6y + ...
                   cz(62) * T6z*T2y + cz(63) * T6z*T3y + cz(64) * T6z*T3y + ...
                   cz(65) * T6z*T4y + cz(66) * T6z*T5y + cz(67) * T6z*T6y;
        end
    end
end

% construct the full (zero-padded) deformation fields
dx_full(cr(1):cr(2), cr(3):cr(4), cr(5):cr(6)) = dx(:, :, :);
dy_full(cr(1):cr(2), cr(3):cr(4), cr(5):cr(6)) = dy(:, :, :);
dz_full(cr(1):cr(2), cr(3):cr(4), cr(5):cr(6)) = dz(:, :, :);

[x y z] = ndgrid(1:dims(1), 1:dims(2), 1:dims(3));
xp = x + dx_full;
yp = y + dy_full;
zp = z + dz_full;
data = interpn(x, y, z, truth, xp, yp, zp, 'nearest');
data(isnan(data)) = 0;
df = zeros([size(dx_full) 3]);
df(:, :, :, 1) = dx_full;
df(:, :, :, 2) = dy_full;
df(:, :, :, 3) = dz_full;

