function cm = generate_random_confusion_matrix(num_labels, diag_val, ...
                                               label_sizes);
% GENERATE_RANDOM_CONFUSION_MATRIX - constructs a random confusion matrix
%                                    with the specified number of labels and
%                                    diagonal value
%
% cm = generate_random_confusion_matrix(num_labels, diag_val, label_sizes);
%
% Input: num_labels - number of labels for the confusion matrix
%        diag_val - the diagonal value for the confusion matrix
%        label_sizes - a vector that is num_labels x 1 that indicates the
%                      relative size of each label
%
% Output: cm - the confusion matrix

if (diag_val >= 1)
    cm = eye(num_labels);
    return;
end

% set the diagonal values
cm = diag(diag_val * ones([1 num_labels]));

% fill in the off-diagonal values
for j = 1:num_labels

    % generate (num_labels - 1) values to fill in the off-diagonals
    nums = rand([1 (num_labels-1)]);

    % calculate how much probability is available
    ava = 1 - diag_val;

    % normalize these values so that we can just slap them into the cm
    nums = ava * (nums / sum(nums));

    % fill in the confusion matrix
    count = 0;
    for k = 1:num_labels
        if (j ~= k)
            count = count + 1;
            cm(k, j) = nums(count);
        end
    end
end

for k = 1:num_labels
    for j = 1:num_labels
        if k ~= j
            cm(k, j) = cm(k, j) * label_sizes(k);
        end
    end
end

for j = 1:num_labels
    ss = 0;
    for k = 1:num_labels
        if k ~= j
            ss = ss + cm(k, j);
        end
    end
    for k = 1:num_labels
        if k ~= j
            cm(k, j) = (1 - diag_val) * cm(k, j) / ss;
        end
    end
end



