% testing script for the COLLATE algorithm

% fusion settings
epsilon = 0.001;
init_flag = 0;
prior_flag = 0;
alphas1 = 0;
alphas2 = 1e15;
alphas3 = [0 1e15];
alphas4 = [0 1 1e15];
alphas5 = [0 0.5 2 1e15];
cvals3 = [0.99];
cvals4 = [0.75 0.99];
cvals5 = [0.45 0.75 0.99];

% run the COLLATE algorithm
[C_est_1 C_W_1 C_theta_1] = COLLATE(obs, epsilon, prior_flag, ...
                                    init_flag, alphas1);
[C_est_2 C_W_2 C_theta_2] = COLLATE(obs, epsilon, prior_flag, ...
                                    init_flag, alphas2);
[C_est_3 C_W_3 C_theta_3] = COLLATE(obs, epsilon, prior_flag, ...
                                    init_flag, alphas3, cvals3);
[C_est_4 C_W_4 C_theta_4] = COLLATE(obs, epsilon, prior_flag, ...
                                    init_flag, alphas4, cvals4);
[C_est_5 C_W_5 C_theta_5] = COLLATE(obs, epsilon, prior_flag, ...
                                    init_flag, alphas5, cvals5);

% print the results to the screen
disp(['COLLATE (1a): ' num2str(fraction_correct(truth, C_est_1))]);
disp(['COLLATE (1b): ' num2str(fraction_correct(truth, C_est_2))]);
disp(['COLLATE (2): ' num2str(fraction_correct(truth, C_est_3))]);
disp(['COLLATE (3): ' num2str(fraction_correct(truth, C_est_4))]);
disp(['COLLATE (4): ' num2str(fraction_correct(truth, C_est_5))]);
