% testing script for the SIMPLE algorithm

% load the example data
load example-data.mat obs truth

% fusion settings
num_iter_keep = 3;
SIMPLEalpha = 2;

% run the SIMPLE algorithm
[SI_est_1] = SIMPLE(obs, num_iter_keep, SIMPLEalpha);
[SI_est_2] = SIMPLE(obs, num_iter_keep, SIMPLEalpha, 0);
[SI_est_3] = SIMPLE(obs, num_iter_keep, SIMPLEalpha, 1);
[SI_est_4] = SIMPLE(obs, num_iter_keep, SIMPLEalpha, 2);

% print the results to the screen
disp(['SIMPLE (default): ' num2str(fraction_correct(truth, SI_est_1))]);
disp(['SIMPLE (sens/spec): ' num2str(fraction_correct(truth, SI_est_2))]);
disp(['SIMPLE (dice): ' num2str(fraction_correct(truth, SI_est_3))]);
disp(['SIMPLE (jaccard): ' num2str(fraction_correct(truth, SI_est_4))]);
