#=========================================================================
#
#   Program:  meshinator
#   Copyright 2006-2011 Rupert Brooks
#
#   Licensed under the Apache License, Version 2.0 (the "License");
#   you may not use this file except in compliance with the License.
#   You may obtain a copy of the License at
#
#       http://www.apache.org/licenses/LICENSE-2.0
#
#   Unless required by applicable law or agreed to in writing, software
#   distributed under the License is distributed on an "AS IS" BASIS,
#   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#   See the License for the specific language governing permissions and
#   limitations under the License.
#
#=========================================================================*/
package require vtk
package require vtkinteraction
# meshination
# generate a mesh from a volume
global initialdir
set initialdir .

proc file_save_get {title filetypes} {
  global initialdir
    set filename [tk_getSaveFile -initialdir $initialdir -filetypes $filetypes -title "$title" -parent .]
    if {$filename != ""} {
	set initialdir [file dirname $filename]
    }
    return $filename
}




proc readdata {filename} {
   global reader-$filename
   global transmat-$filename
   if {![file exists $filename] } {puts "ERROR: Cannot open $filename";exit}
   vtkMatrix4x4 transmat-$filename
   switch -glob "$filename" {
       *.vtk {
	   puts "Reading as vtk structured points"
	   vtkStructuredPointsReader reader-$filename
           reader-$filename SetFileName $filename
           reader-$filename Update 
	   transmat-$filename SetElement 0 0 1
	   transmat-$filename SetElement 0 1 0
	   transmat-$filename SetElement 0 2 0
	   transmat-$filename SetElement 0 3 0
	   transmat-$filename SetElement 1 0 0
	   transmat-$filename SetElement 1 1 1
	   transmat-$filename SetElement 1 2 0
	   transmat-$filename SetElement 1 3 0
      	   transmat-$filename SetElement 2 0 0
	   transmat-$filename SetElement 2 1 0
	   transmat-$filename SetElement 2 2 1
	   transmat-$filename SetElement 2 3 0
      	   transmat-$filename SetElement 3 0 0
	   transmat-$filename SetElement 3 1 0
	   transmat-$filename SetElement 3 2 0
	   transmat-$filename SetElement 3 3 1
       }
       *.mh* {
	   puts "Reading as UNC meta image"
	   vtkMetaImageReader filereader-$filename
           filereader-$filename SetFileName $filename
           vtkImageChangeInformation reader-$filename
           reader-$filename SetInput [filereader-$filename GetOutput]
           reader-$filename SetOutputOrigin 0 0 0
	   # cause the origin is set below
           #reader-$filename Update 
           # ok, this is irritating, the vtk mha reader does
           # not read in the transform matrix, so, read it in
           # myself
           #
           set file [open $filename r]
           # initialize matrix and offset, so if not
           # found behavior is reasonable
           set a 1
           set b 0 
           set c 0
           set d 0
           set e 1
           set f 0
           set g 0
           set h 0
           set i 1
           set offx 0
           set offy 0
           set offz 0
           while { [gets $file line] != -1 } {
              scan $line "%s" firstToken
              if { $firstToken == "TransformMatrix" } {
                 scan $line "%s %s %f %f %f %f %f %f %f %f %f" firstToken eqtoken a b c d e f g h i
                 puts "Matrix is:"
                 #puts "$a $b $c"
                 #puts "$d $e $f"
                 #puts "$g $h $i"
              }
              if { $firstToken == "Offset" } {
                 scan $line "%s %s %f %f %f" firstToken eqtoken offx offy offz
                 #puts "$offx $offy $offz"
              }
           }
	   transmat-$filename SetElement 0 0 $a
	   transmat-$filename SetElement 0 1 $b
	   transmat-$filename SetElement 0 2 $c
	   transmat-$filename SetElement 0 3 0 
#[expr $offx * (-1)]
	   transmat-$filename SetElement 1 0 $d
	   transmat-$filename SetElement 1 1 $e
	   transmat-$filename SetElement 1 2 $f
	   transmat-$filename SetElement 1 3 0 
#[expr $offy * (-1)]
      	   transmat-$filename SetElement 2 0 $g
	   transmat-$filename SetElement 2 1 $h
	   transmat-$filename SetElement 2 2 $i
	   transmat-$filename SetElement 2 3 0 
#[expr $offz * (-1)]
      	   transmat-$filename SetElement 3 0 0
	   transmat-$filename SetElement 3 1 0
	   transmat-$filename SetElement 3 2 0
	   transmat-$filename SetElement 3 3 1
    transmat-$filename Invert
    transmat-$filename SetElement 0 3 $offx
    transmat-$filename SetElement 1 3 $offy
    transmat-$filename SetElement 2 3 $offz
     	  # puts transmat-$filename

       }


   }

}


vtkFileOutputWindow fow
fow SetFileName "meshinatorErrors.txt"
fow SetFlush 0
fow SetInstance fow

proc calculate {} {
global decimator
global skinExtractor
global renWin
global startval
global endval
skinExtractor SetValue 0 [.top.f1.f2.level get]
decimator SetTargetReduction [expr [.top.f1.f2.decimate get] /100.0]
decimator Update
set startval [[skinExtractor GetOutput] GetNumberOfPolys]
set endval [[decimator GetOutput] GetNumberOfPolys]
#$renWin render
}
proc writebutton {} {
    global decimator
    #puts "In Writebutton"
    set fn [file_save_get "Save Mesh" {{ "VTK Data File" *.vtk}}]
    Write $fn
}
proc Write {fn} {
    vtkPolyDataWriter writer
    writer SetInput [transformer GetOutput]
    writer SetFileName $fn
    #writer SetFileTypeToBinary
    writer Write
    
}
toplevel .top
wm withdraw .top
wm protocol .top WM_DELETE_WINDOW "exit"
wm title .top "meshinator"
frame .top.f1
frame .top.f1.f2
vtkTkRenderWidget .top.f1.r1 -width 400 -height 400
button .top.btn -text Quit -command exit
button .top.btn2 -text Write -command writebutton
button .top.btngo -text Calculate -command calculate

scale .top.f1.f2.decimate -label decimate -from 0 -to 100 -orient horizontal -tickinterval 10 
scale .top.f1.f2.level -label level -from 0 -to 1024 -orient horizontal -tickinterval 100 
frame .top.f2
set starval 0
set endval 0
global startval
global endval

label .top.f2.start -text "Before Tri:"
label .top.f2.startval -textvariable startval
label .top.f2.end -text "After Tri:"
label .top.f2.endval -textvariable endval

pack .top.f1.f2 -side top -fill x -expand f
pack .top.f1.f2.decimate -side top -fill x -expand f
pack .top.f1.f2.level -side top -fill x -expand f

pack .top.f1.r1 -side left -padx 3 -pady 3 -fill both -expand t
pack .top.f1 -fill both -expand t

pack .top.f2 -fill x
pack .top.f2.start -side left
pack .top.f2.startval -side left
pack .top.f2.endval -side right
pack .top.f2.end -side right
pack .top.btngo -fill x
pack .top.btn -fill x
pack .top.btn2 -fill x


toplevel .dlg -class Dialog
  wm title .dlg "Output image"
  #wm transient .dlg .
  wm withdraw .dlg
  label .dlg.l -text "Enter the (png) file to write"
  entry .dlg.t
button .dlg.b -text "Write" -command "writer SetFileName \[.dlg.t get\]; wm withdraw .dlg;write"
  pack .dlg.l
  pack .dlg.t
  pack .dlg.b



# Get the render window associated with the widget
set renWin [.top.f1.r1 GetRenderWindow]
vtkRenderer aRenderer
$renWin AddRenderer aRenderer




# bind the mouse events
::vtk::bind_tk_render_widget .top.f1.r1

set colors [list {0 0 1} {1 1 0} {0 1 0} {1 0 0}  {0 0 0} ]
set action outline
set color {0 0 1}

vtkTransform transform
transform RotateY 45
transform RotateX -45

# PARSE ARGUMENTS
set obj 0

if {$argc == 0} {
   puts "Usage meshinator file \[threshold \[decimation \[outputfile\]\]\]"
   puts "   threshold is the isosurface to use, auto for the default"
   puts "   decimation is the proportion to remove in decimation (default 0.95)"
   puts "   if outputfile is present, write the mesh to this file and quit"
   exit
} 

set filename [lindex $argv 0]
set initialdecimation 0.95
set initiallevel "auto"
set outputfile "none"
if {$argc>1} {set initiallevel [lindex $argv 1]}
if {$argc>2} {set initialdecimation [lindex $argv 2]}
if {$argc>3} {set outputfile [lindex $argv 3]}
    
##############################################
   global reader-$filename
   global transmat-$filename
   readdata $filename

vtkOutlineFilter outlineData-$filename
  outlineData-$filename SetInput  [reader-$filename GetOutput]
vtkPolyDataMapper mapOutline-$filename
  mapOutline-$filename SetInput [outlineData-$filename GetOutput]
vtkActor outline-$filename
  outline-$filename SetMapper mapOutline-$filename
    [outline-$filename GetProperty] SetColor  [lindex $color 0] [lindex $color 1] [lindex $color 2]

outline-$filename SetUserMatrix transmat-$filename
aRenderer AddActor outline-$filename

reader-$filename Update
set range [[reader-$filename GetOutput] GetScalarRange]
puts "range is $range"

if {$initiallevel=="auto"} {

set val [expr ( [lindex $range 1] - [lindex $range 0]) / 3.0]
} else {
set val $initiallevel
}
puts "val is $val"
if {$val < 10} {
  .top.f1.f2.level configure -resolution -1
  }
  
global skinExtractor
vtkContourFilter skinExtractor
  skinExtractor SetInput  [reader-$filename GetOutput]
  skinExtractor SetValue 0 $val
  .top.f1.f2.level configure -from [lindex $range 0]
  .top.f1.f2.level configure -to [lindex $range 1]
  .top.f1.f2.level configure -tickinterval [expr $val / 5]
  .top.f1.f2.level set $val
  skinExtractor Update
  #set verts [[skinExtractor GetOutput] GetNumberOfVerts]
  #set lines [[skinExtractor GetOutput] GetNumberOfLines]
  set startval [[skinExtractor GetOutput] GetNumberOfPolys]
  #set strips [[skinExtractor GetOutput] GetNumberOfStrips]
  #puts "verts are $verts"
  #puts "lines are $lines"
  #puts "polys are $polys"
  #puts "strips are $strips"
  vtkTriangleFilter tri-$filename
  tri-$filename SetInput [skinExtractor GetOutput]
  tri-$filename Update
  #set verts [[tri-$filename GetOutput] GetNumberOfVerts]
  #set lines [[tri-$filename GetOutput] GetNumberOfLines]
  #set polys [[tri-$filename GetOutput] GetNumberOfPolys]
  #set strips [[tri-$filename GetOutput] GetNumberOfStrips]
  #puts "verts are $verts"
  #puts "lines are $lines"
  #puts "polys are $polys"
  #puts "strips are $strips"
global deci-$filename
vtkQuadricDecimation decimator
  decimator SetInput [tri-$filename GetOutput]
  decimator SetTargetReduction $initialdecimation
  .top.f1.f2.decimate set [expr $initialdecimation * 100.0]
  # decimator PreserveTopologyOn
  decimator Update
  
  
  
  #set verts [[decimator GetOutput] GetNumberOfVerts]
  #set lines [[decimator GetOutput] GetNumberOfLines]
  set endval [[decimator GetOutput] GetNumberOfPolys]
  #set strips [[decimator GetOutput] GetNumberOfStrips]
  #puts "verts are $verts"
  #puts "lines are $lines"
  #puts "polys are $polys"
  #puts "strips are $strips"
  vtkTransformPolyDataFilter transformer
  vtkTransform xfm
  transformer SetTransform xfm
  xfm SetMatrix transmat-$filename
  transformer SetInput [decimator GetOutput]
  transformer Update 

  if {$outputfile!="none"} {
    Write $outputfile
    exit
  }
  


vtkPolyDataNormals skinNormals-$filename
#  skinNormals SetInput [skinExtractor GetOutput]
  skinNormals-$filename SetInput [transformer GetOutput]
  skinNormals-$filename SetFeatureAngle 60.0
vtkPolyDataMapper skinMapper-$filename
  skinMapper-$filename SetInput [skinNormals-$filename GetOutput]
#  skinMapper SetInput [deci GetOutput]
  skinMapper-$filename ScalarVisibilityOff
vtkActor skin-$filename
  skin-$filename SetMapper skinMapper-$filename
    [skin-$filename GetProperty]  SetColor [lindex $color 0] [lindex $color 1] [lindex $color 2]
  [skin-$filename GetProperty]  SetEdgeColor 1 0 0
  [skin-$filename GetProperty]  EdgeVisibilityOn
  [skin-$filename GetProperty]  SetOpacity 0.3


#skin-$filename SetUserMatrix transmat-$filename
aRenderer AddActor skin-$filename


###################################
aRenderer ResetCamera 
[aRenderer GetActiveCamera] ApplyTransform transform
aRenderer SetBackground 1 1 1
$renWin SetStereoTypeToRedBlue
aRenderer ResetCameraClippingRange
wm deiconify .top 

wm withdraw .
