/*
 * Decompiled with CFR 0.152.
 */
package org.brainmap.image;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.PrintStream;
import org.brainmap.image.NiftiHeader;
import org.brainmap.util.ByteConverter;
import org.brainmap.util.OpenResource;

public abstract class ImageHeader {
    public static final short DT_BINARY = 1;
    public static final short DT_BYTE = 2;
    public static final short DT_SHORT = 4;
    public static final short DT_INT = 8;
    public static final short DT_FLOAT = 16;
    public static final short DT_DOUBLE = 64;

    public float[] getVoxelSizes() {
        return null;
    }

    public void setVoxelSizes(float[] pixdim) {
    }

    public short[] getDimensions() {
        return null;
    }

    public void setDimensions(short[] dim) {
    }

    public float getMax() {
        return 0.0f;
    }

    public float getMin() {
        return 0.0f;
    }

    public void setMax(float f) {
    }

    public void setMin(float f) {
    }

    public short getBits() {
        return 0;
    }

    public short getType() {
        return 0;
    }

    public void setType(short s) {
    }

    public void out(PrintStream out) {
    }

    public String getDescription() {
        return null;
    }

    public void setDescription(String s) {
    }

    public byte[] getBytes() {
        return null;
    }

    public static byte[] getBytes(NiftiHeader n) {
        return null;
    }

    public void setBytes(byte[] b) {
    }

    protected void fromString(byte[] b, String s) {
        int len = s.length();
        int length = b.length;
        for (int i = 0; i < length; ++i) {
            b[i] = i < len ? (byte)s.charAt(i) : (byte)0;
        }
    }

    protected String toString(byte[] arr) {
        String s = "";
        for (int i = 0; i < arr.length; ++i) {
            if (arr[i] == 0) continue;
            s = String.valueOf(String.valueOf(s)).concat(String.valueOf(String.valueOf((char)arr[i])));
        }
        return s;
    }

    protected String toString2(byte[] arr) {
        String s = "";
        for (int i = 0; i < arr.length; ++i) {
            s = String.valueOf(String.valueOf(s)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(arr[i])).concat(" "))));
        }
        return s;
    }

    protected String toString(short[] arr) {
        String s = "";
        for (int i = 0; i < arr.length; ++i) {
            s = String.valueOf(String.valueOf(s)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(arr[i])).concat(" "))));
        }
        return s;
    }

    protected String toString(float[] arr) {
        String s = "";
        for (int i = 0; i < arr.length; ++i) {
            s = String.valueOf(String.valueOf(s)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(arr[i])).concat(" "))));
        }
        return s;
    }

    protected int addChar(byte[] b, int offset, char c) {
        b[offset] = (byte)c;
        return offset + 1;
    }

    protected int addByteArr(byte[] b, int offset, byte[] c) {
        for (int i = 0; i < c.length; ++i) {
            b[offset + i] = c[i];
        }
        return offset + c.length;
    }

    protected int addCharArr(byte[] b, int offset, char[] c) {
        for (int i = 0; i < c.length; ++i) {
            b[offset + i] = (byte)c[i];
        }
        return offset + c.length;
    }

    protected int addShort(byte[] b, int offset, short s) {
        byte[] temp = ByteConverter.getBytes(s);
        for (int j = 0; j < 2; ++j) {
            b[offset + j] = temp[j];
        }
        return offset + 2;
    }

    protected int addShortArr(byte[] b, int offset, short[] i) {
        for (int k = 0; k < i.length; ++k) {
            byte[] temp = ByteConverter.getBytes(i[k]);
            for (int j = 0; j < 2; ++j) {
                b[offset + j] = temp[j];
            }
            offset += 2;
        }
        return offset;
    }

    protected int addInt(byte[] b, int offset, int i) {
        byte[] temp = ByteConverter.getBytes(i);
        for (int j = 0; j < 4; ++j) {
            b[offset + j] = temp[j];
        }
        return offset + 4;
    }

    protected int addIntArr(byte[] b, int offset, int[] i) {
        for (int k = 0; k < i.length; ++k) {
            byte[] temp = ByteConverter.getBytes(i[k]);
            for (int j = 0; j < 4; ++j) {
                b[offset + j] = temp[j];
            }
            offset += 4;
        }
        return offset;
    }

    protected int addFloat(byte[] b, int offset, float f) {
        byte[] temp = ByteConverter.getBytes(f);
        for (int j = 0; j < 4; ++j) {
            b[offset + j] = temp[j];
        }
        return offset + 4;
    }

    protected int addFloatArr(byte[] b, int offset, float[] f) {
        for (int k = 0; k < f.length; ++k) {
            byte[] temp = ByteConverter.getBytes(f[k]);
            for (int j = 0; j < 4; ++j) {
                b[offset + j] = temp[j];
            }
            offset += 4;
        }
        return offset;
    }

    protected char[] getCharArr(byte[] b, int offset, int size) {
        char[] c = new char[size];
        for (int i = 0; i < size; ++i) {
            c[i] = (char)b[i + offset];
        }
        return c;
    }

    public int writeHeader(String file) {
        BufferedOutputStream bout;
        try {
            FileOutputStream fout = new FileOutputStream(file);
            bout = new BufferedOutputStream(fout);
        }
        catch (Exception e) {
            System.out.println("WriteToFile: can't open ".concat(String.valueOf(String.valueOf(file))));
            int n = -1;
            return n;
        }
        return this.writeHeader(bout);
    }

    private int writeHeader(BufferedOutputStream bout) {
        try {
            byte[] b = this.getBytes();
            bout.write(b);
            bout.flush();
            bout.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            int n = -2;
            return n;
        }
        return 0;
    }

    public static byte[] readHeaderBytes(Class c, String name) {
        BufferedInputStream bin = OpenResource.openStream(c, name);
        return ImageHeader.readHeaderBytes(bin);
    }

    public static byte[] readHeaderBytes(String path) {
        File f = new File(path);
        if (!f.exists()) {
            return null;
        }
        try {
            FileInputStream fis = new FileInputStream(path);
            byte[] byArray = ImageHeader.readHeaderBytes(new BufferedInputStream(fis));
            return byArray;
        }
        catch (Throwable t) {
            System.out.println("readHeader: can't read file ".concat(String.valueOf(String.valueOf(f.getName()))));
            byte[] byArray = null;
            return byArray;
        }
    }

    public static byte[] readHeaderBytes(BufferedInputStream bin) {
        if (bin == null) {
            return null;
        }
        try {
            byte[] b = new byte[348];
            bin.read(b, 0, 348);
            bin.close();
            byte[] byArray = b;
            return byArray;
        }
        catch (Exception e) {
            e.printStackTrace();
            byte[] byArray = null;
            return byArray;
        }
    }

    public static int writeImage(String path, double[] image) {
        BufferedOutputStream bout;
        try {
            FileOutputStream fout = new FileOutputStream(new File(path));
            bout = new BufferedOutputStream(fout);
        }
        catch (Exception e) {
            System.out.println("WriteToFile: can't open ".concat(String.valueOf(String.valueOf(path))));
            int n = -1;
            return n;
        }
        try {
            for (int i = 0; i < image.length; ++i) {
                byte[] b = ByteConverter.getBytes(image[i]);
                bout.write(b);
            }
            bout.flush();
            bout.close();
        }
        catch (Exception e) {
            System.out.println("WriteToFile: can't write ".concat(String.valueOf(String.valueOf(path))));
            int n = -2;
            return n;
        }
        return 0;
    }

    public static int writeImage(String path, float[] image) {
        BufferedOutputStream bout;
        try {
            FileOutputStream fout = new FileOutputStream(new File(path));
            bout = new BufferedOutputStream(fout);
        }
        catch (Exception e) {
            System.out.println("WriteToFile: can't open ".concat(String.valueOf(String.valueOf(path))));
            int n = -1;
            return n;
        }
        try {
            for (int i = 0; i < image.length; ++i) {
                byte[] b = ByteConverter.getBytes(image[i]);
                bout.write(b);
            }
            bout.flush();
            bout.close();
        }
        catch (Exception e) {
            System.out.println("WriteToFile: can't write ".concat(String.valueOf(String.valueOf(path))));
            int n = -2;
            return n;
        }
        return 0;
    }

    public static int writeImage(String path, int[] image) {
        BufferedOutputStream bout;
        try {
            FileOutputStream fout = new FileOutputStream(new File(path));
            bout = new BufferedOutputStream(fout);
        }
        catch (Exception e) {
            System.out.println("WriteToFile: can't open ".concat(String.valueOf(String.valueOf(path))));
            int n = -1;
            return n;
        }
        try {
            for (int i = 0; i < image.length; ++i) {
                byte[] b = ByteConverter.getBytes(image[i]);
                bout.write(b);
            }
            bout.flush();
            bout.close();
        }
        catch (Exception e) {
            System.out.println("WriteToFile: can't write ".concat(String.valueOf(String.valueOf(path))));
            int n = -2;
            return n;
        }
        return 0;
    }

    public static int writeImage(String path, short[] image) {
        BufferedOutputStream bout;
        try {
            FileOutputStream fout = new FileOutputStream(new File(path));
            bout = new BufferedOutputStream(fout);
        }
        catch (Exception e) {
            System.out.println("WriteToFile: can't open ".concat(String.valueOf(String.valueOf(path))));
            int n = -1;
            return n;
        }
        try {
            for (int i = 0; i < image.length; ++i) {
                byte[] b = ByteConverter.getBytes(image[i]);
                bout.write(b);
            }
            bout.flush();
            bout.close();
        }
        catch (Exception e) {
            System.out.println("WriteToFile: can't write ".concat(String.valueOf(String.valueOf(path))));
            int n = -2;
            return n;
        }
        return 0;
    }

    public static int writeImage(String path, byte[] image) {
        BufferedOutputStream bout;
        try {
            FileOutputStream fout = new FileOutputStream(new File(path));
            bout = new BufferedOutputStream(fout);
        }
        catch (Exception e) {
            System.out.println("WriteToFile: can't open ".concat(String.valueOf(String.valueOf(path))));
            int n = -1;
            return n;
        }
        try {
            bout.write(image);
            bout.flush();
            bout.close();
        }
        catch (Exception e) {
            System.out.println("WriteToFile: can't write ".concat(String.valueOf(String.valueOf(path))));
            int n = -2;
            return n;
        }
        return 0;
    }

    public static int writeImage(String path, float[][][] image) {
        BufferedOutputStream bout;
        try {
            FileOutputStream fout = new FileOutputStream(new File(path));
            bout = new BufferedOutputStream(fout);
        }
        catch (Exception e) {
            System.out.println("WriteToFile: can't open ".concat(String.valueOf(String.valueOf(path))));
            int n = -10;
            return n;
        }
        try {
            int totalBytes = 0;
            for (int z = 0; z < image[0][0].length; ++z) {
                for (int y = 0; y < image[0].length; ++y) {
                    for (int x = 0; x < image.length; ++x) {
                        byte[] b = ByteConverter.getBytes(image[x][y][z]);
                        bout.write(b);
                        totalBytes += b.length;
                    }
                }
            }
            System.out.println(String.valueOf(String.valueOf(totalBytes)).concat(" bytes written"));
            bout.flush();
            bout.close();
        }
        catch (Exception e) {
            System.out.println("WriteToFile: can't write ".concat(String.valueOf(String.valueOf(path))));
            int n = -2;
            return n;
        }
        return 0;
    }

    public static int writeImage(String path, double[][][] image) {
        BufferedOutputStream bout;
        try {
            FileOutputStream fout = new FileOutputStream(new File(path));
            bout = new BufferedOutputStream(fout);
        }
        catch (Exception e) {
            System.out.println("WriteToFile: can't open ".concat(String.valueOf(String.valueOf(path))));
            int n = -10;
            return n;
        }
        try {
            int totalBytes = 0;
            for (int z = 0; z < image[0][0].length; ++z) {
                for (int y = 0; y < image[0].length; ++y) {
                    for (int x = 0; x < image.length; ++x) {
                        byte[] b = ByteConverter.getBytes(image[x][y][z]);
                        bout.write(b);
                        totalBytes += b.length;
                    }
                }
            }
            System.out.println(String.valueOf(String.valueOf(totalBytes)).concat(" bytes written"));
            bout.flush();
            bout.close();
        }
        catch (Exception e) {
            System.out.println("WriteToFile: can't write ".concat(String.valueOf(String.valueOf(path))));
            int n = -2;
            return n;
        }
        return 0;
    }

    public static boolean[] readMask(BufferedInputStream bin, ImageHeader header) {
        if (bin == null || header == null) {
            return null;
        }
        int bytes = header.getBits() / 8;
        short[] dim = header.getDimensions();
        int numVoxels = dim[1] * dim[2] * dim[3];
        boolean[] mask = new boolean[numVoxels];
        try {
            byte[] b = new byte[bytes];
            for (int i = 0; i < numVoxels; ++i) {
                bin.read(b);
                if (bytes == 8) {
                    double d = ByteConverter.getDouble(b, 0);
                    mask[i] = d != 0.0;
                    continue;
                }
                if (bytes == 4) {
                    float f = ByteConverter.getFloat(b, 0);
                    mask[i] = f != 0.0f;
                    continue;
                }
                if (bytes == 2) {
                    short s = ByteConverter.getShort(b, 0);
                    mask[i] = s != 0;
                    continue;
                }
                if (bytes != 1) continue;
                mask[i] = b[0] != 0;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            boolean[] blArray = null;
            return blArray;
        }
        return mask;
    }

    public short[] readShortImage(BufferedInputStream bin) {
        return ImageHeader.readShortImage(bin, this);
    }

    public static short[] readShortImage(BufferedInputStream bin, ImageHeader header) {
        short[] dim = header.getDimensions();
        int numVoxels = dim[1] * dim[2] * dim[3];
        int bytes = header.getBits() / 8;
        short[] image = new short[numVoxels];
        try {
            byte[] barr = new byte[bytes];
            for (int i = 0; i < numVoxels; ++i) {
                bin.read(barr);
                if (bytes == 8) {
                    double d = ByteConverter.getDouble(barr, 0);
                    image[i] = (short)d;
                    continue;
                }
                if (bytes == 4) {
                    int j = ByteConverter.getInt(barr, 0);
                    image[i] = (short)j;
                    continue;
                }
                if (bytes == 2) {
                    short s;
                    image[i] = s = ByteConverter.getShort(barr, 0);
                    continue;
                }
                if (bytes != 1) continue;
                image[i] = barr[0];
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            short[] j = null;
            return j;
        }
        return image;
    }

    public static boolean checkImageFile(ImageHeader header, String path, long offset) {
        short[] dim = header.getDimensions();
        int numVoxels = dim[1] * dim[2] * dim[3];
        int bytes = header.getBits() / 8;
        File file = new File(path);
        if (!file.exists()) {
            System.out.println(String.valueOf(String.valueOf(path)).concat(" does not exist"));
            return false;
        }
        if (!file.canRead()) {
            System.out.println(String.valueOf(String.valueOf(path)).concat(" is not readable"));
            return false;
        }
        if (!file.isFile()) {
            System.out.println(String.valueOf(String.valueOf(path)).concat(" is not a file"));
            return false;
        }
        long fileSize = file.length();
        long size = fileSize - offset;
        if (size != (long)(numVoxels * bytes)) {
            System.out.print(String.valueOf(String.valueOf(new StringBuffer("dimensions: (").append(dim[1]).append(",").append(dim[2]).append(",").append(dim[3]).append(",").append(bytes).append(")"))));
            System.out.println(" -> expected size: ".concat(String.valueOf(String.valueOf(numVoxels * bytes))));
            System.out.print(String.valueOf(String.valueOf(new StringBuffer("file size: ").append(fileSize).append(", offset: ").append(offset))));
            System.out.println(" -> image size: ".concat(String.valueOf(String.valueOf(size))));
            return false;
        }
        return true;
    }

    public short[] readShortImage(String path) {
        return ImageHeader.readShortImage(this, path, 0L);
    }

    public static short[] readShortImage(ImageHeader header, String path, long offset) {
        if (!ImageHeader.checkImageFile(header, path, offset)) {
            return null;
        }
        try {
            FileInputStream fis = new FileInputStream(path);
            BufferedInputStream bis = new BufferedInputStream(fis);
            bis.skip(offset);
            short[] sArray = ImageHeader.readShortImage(bis, header);
            return sArray;
        }
        catch (Exception e) {
            System.out.println("ReadToFile: can't open ".concat(String.valueOf(String.valueOf(path))));
            short[] sArray = null;
            return sArray;
        }
    }

    public int[] readIntImage(String path) {
        return ImageHeader.readIntImage(this, path, 0L);
    }

    public static int[] readIntImage(ImageHeader header, String path, long offset) {
        BufferedInputStream bis;
        if (!ImageHeader.checkImageFile(header, path, offset)) {
            return null;
        }
        try {
            FileInputStream fis = new FileInputStream(path);
            bis = new BufferedInputStream(fis);
        }
        catch (Exception e) {
            System.out.println("ReadToFile: can't open ".concat(String.valueOf(String.valueOf(path))));
            int[] nArray = null;
            return nArray;
        }
        short[] dim = header.getDimensions();
        int numVoxels = dim[1] * dim[2] * dim[3];
        int bytes = header.getBits() / 8;
        int[] image = new int[numVoxels];
        try {
            byte[] barr = new byte[bytes];
            bis.skip(offset);
            for (int i = 0; i < numVoxels; ++i) {
                bis.read(barr);
                if (bytes == 8) {
                    double d = ByteConverter.getDouble(barr, 0);
                    image[i] = (int)d;
                    continue;
                }
                if (bytes == 4) {
                    int j;
                    image[i] = j = ByteConverter.getInt(barr, 0);
                    continue;
                }
                if (bytes == 2) {
                    short s = ByteConverter.getShort(barr, 0);
                    image[i] = s;
                    continue;
                }
                if (bytes != 1) continue;
                image[i] = barr[0];
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            int[] j = null;
            return j;
        }
        return image;
    }

    public float[] readImage(String path) {
        return ImageHeader.readImage(this, path, 0L);
    }

    public static float[] readImage(ImageHeader header, String path, long offset) {
        BufferedInputStream bis;
        if (!ImageHeader.checkImageFile(header, path, offset)) {
            return null;
        }
        try {
            FileInputStream fis = new FileInputStream(path);
            bis = new BufferedInputStream(fis);
        }
        catch (Exception e) {
            System.out.println("ReadToFile: can't open ".concat(String.valueOf(String.valueOf(path))));
            float[] fArray = null;
            return fArray;
        }
        short[] dim = header.getDimensions();
        int numVoxels = dim[1] * dim[2] * dim[3];
        int bytes = header.getBits() / 8;
        float[] image = new float[numVoxels];
        try {
            byte[] barr = new byte[bytes];
            bis.skip(offset);
            for (int i = 0; i < numVoxels; ++i) {
                bis.read(barr);
                if (bytes == 8) {
                    double d = ByteConverter.getDouble(barr, 0);
                    image[i] = (float)d;
                    continue;
                }
                if (bytes == 4) {
                    float f;
                    image[i] = f = ByteConverter.getFloat(barr, 0);
                    continue;
                }
                if (bytes == 2) {
                    short s = ByteConverter.getShort(barr, 0);
                    image[i] = s;
                    continue;
                }
                if (bytes != 1) continue;
                image[i] = barr[0];
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            float[] f = null;
            return f;
        }
        return image;
    }

    static {
        DT_BINARY = 1;
        DT_BYTE = (short)2;
        DT_SHORT = (short)4;
        DT_INT = (short)8;
        DT_FLOAT = (short)16;
        DT_DOUBLE = (short)64;
    }
}

