/*
 * Decompiled with CFR 0.152.
 */
package org.brainmap.talairach;

import java.io.BufferedReader;
import java.util.StringTokenizer;
import org.brainmap.image.AnalyzeHeader;
import org.brainmap.image.AnalyzeIO;
import org.brainmap.image.NiftiImage;
import org.brainmap.talairach.Database;
import org.brainmap.talairach.TDLabel;
import org.brainmap.talairach.TalairachUtility;
import org.brainmap.util.FileIO;
import org.brainmap.util.StringUtilities;
import org.brainmap.util.XyzCoordinates;

public class TalairachImage {
    public static void main(String[] args) {
        TalairachImage ti = new TalairachImage();
        ti.compareDatabases();
    }

    public void saveNiftiImage() {
        Database d = new Database();
        NiftiImage nii = NiftiImage.readNiftiImage("talairach.nii");
        d.load(nii);
    }

    public void testNearestGrayTies() {
        Database d = new Database();
        d.loadImage("talairach");
        XyzCoordinates min = d.getMin();
        XyzCoordinates max = d.getMax();
        int x = (int)min.x;
        while ((float)x <= max.x) {
            System.out.println("x = ".concat(String.valueOf(String.valueOf(x))));
            int y = (int)min.y;
            while ((float)y <= max.x) {
                int z = (int)min.z;
                while ((float)z <= max.x) {
                    String s;
                    TDLabel label = d.nearestGray(x, y, z, 5);
                    if (label != null && (s = label.getString(".")).startsWith("*")) {
                        System.out.println(s);
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
    }

    public void createGrayImage() {
        String input = "bounds_gray";
        String output = "gray";
        System.out.print("loading the TD database...");
        Database db = new Database();
        db.loadImage(input);
        if (!db.loaded) {
            System.out.println("\nDatabase did not load - ".concat(String.valueOf(String.valueOf(db.Error))));
            return;
        }
        System.out.println();
        XyzCoordinates min = db.getMin();
        XyzCoordinates max = db.getMax();
        XyzCoordinates size = db.getSize();
        AnalyzeHeader hdr = new AnalyzeHeader();
        hdr.setBytes(AnalyzeHeader.readHeaderBytes(String.valueOf(String.valueOf(input)).concat(".hdr")));
        short[] dim = new short[]{4, (short)size.x, (short)size.y, (short)size.z, 1};
        hdr.setDimensions(dim);
        hdr.setType(AnalyzeHeader.DT_SHORT);
        short[] image = hdr.readShortImage(String.valueOf(String.valueOf(input)).concat(".img"));
        int length = 0;
        int maxLabels = 1920;
        String[] labels = new String[maxLabels];
        TDLabel lab = null;
        String sep = ".";
        String[] array = new String[5];
        int z = (int)min.z;
        while ((float)z <= max.z) {
            int y = (int)min.y;
            while ((float)y <= max.y) {
                int x = (int)min.x;
                while ((float)x <= max.x) {
                    int q;
                    lab = db.nearestGray(x, y, z);
                    for (q = 0; q < 5; ++q) {
                        array[q] = lab == null ? "*" : lab.Labels[q];
                    }
                    String label = "";
                    for (q = 0; q < 5; ++q) {
                        label = String.valueOf(String.valueOf(label)).concat(String.valueOf(String.valueOf(array[q])));
                        if (q == 4) continue;
                        label = String.valueOf(String.valueOf(label)).concat(String.valueOf(String.valueOf(sep)));
                    }
                    int k = z - (int)min.z;
                    int j = y - (int)min.y;
                    int i = x - (int)min.x;
                    int index = (int)size.x * (int)size.y * k + (int)size.x * j + i;
                    if (index < 0 || index >= image.length) {
                        System.out.println("bad index: ".concat(String.valueOf(String.valueOf(index))));
                        System.out.println(String.valueOf(String.valueOf(new StringBuffer("xyz: ").append(x).append(",").append(y).append(",").append(z))));
                        System.out.println(String.valueOf(String.valueOf(new StringBuffer("ijk: ").append(i).append(",").append(j).append(",").append(k))));
                        break;
                    }
                    boolean found = false;
                    for (int q2 = 0; q2 < length; q2 = (int)((short)(q2 + 1))) {
                        if (!labels[q2].equals(label)) continue;
                        image[index] = q2;
                        found = true;
                        break;
                    }
                    if (!found) {
                        labels[length] = label;
                        image[index] = length;
                        length = (short)(length + 1);
                        System.out.println(String.valueOf(String.valueOf(new StringBuffer("slice ").append(z).append(": \t").append(label))));
                    }
                    ++x;
                }
                ++y;
            }
            ++z;
        }
        String first = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(length))).append(" ").append((int)min.x).append(" ").append((int)min.y).append(" ").append((int)min.z).append(" ").append((int)max.x).append(" ").append((int)max.y).append(" ").append((int)max.z)));
        String[] header = new String[length + 1];
        header[0] = first;
        for (int q = 1; q <= length; ++q) {
            header[q] = labels[q - 1];
        }
        StringUtilities.writeStrings(String.valueOf(String.valueOf(output)).concat(".txt"), header);
        AnalyzeIO.writeImage(String.valueOf(String.valueOf(output)).concat(".img"), image);
        AnalyzeIO.writeHeader(output, hdr);
    }

    public void addCerebralGray() {
        String input = "bounds";
        String output = "bounds_gray";
        System.out.print("loading the TD database...");
        Database db = new Database();
        db.loadImage(input);
        if (!db.loaded) {
            System.out.println("\nDatabase did not load - ".concat(String.valueOf(String.valueOf(db.Error))));
            return;
        }
        System.out.println();
        XyzCoordinates min = db.getMin();
        XyzCoordinates max = db.getMax();
        XyzCoordinates size = db.getSize();
        AnalyzeHeader hdr = new AnalyzeHeader();
        hdr.setBytes(AnalyzeHeader.readHeaderBytes(String.valueOf(String.valueOf(input)).concat(".hdr")));
        short[] dim = new short[]{4, (short)size.x, (short)size.y, (short)size.z, 1};
        hdr.setDimensions(dim);
        hdr.setType(AnalyzeHeader.DT_SHORT);
        short[] image = hdr.readShortImage(String.valueOf(String.valueOf(input)).concat(".img"));
        int length = 0;
        int maxLabels = 1920;
        String[] labels = new String[maxLabels];
        TDLabel lab = null;
        String sep = ".";
        String[] array = new String[5];
        int z = (int)min.z;
        while ((float)z <= max.z) {
            int y = (int)min.y;
            while ((float)y <= max.y) {
                int x = (int)min.x;
                while ((float)x <= max.x) {
                    int q;
                    int k = z - (int)min.z;
                    int j = y - (int)min.y;
                    int i = x - (int)min.x;
                    int index = (int)size.x * (int)size.y * k + (int)size.x * j + i;
                    if (index < 0 || index >= image.length) {
                        System.out.println("bad index: ".concat(String.valueOf(String.valueOf(index))));
                        System.out.println(String.valueOf(String.valueOf(new StringBuffer("xyz: ").append(x).append(",").append(y).append(",").append(z))));
                        System.out.println(String.valueOf(String.valueOf(new StringBuffer("ijk: ").append(i).append(",").append(j).append(",").append(k))));
                        break;
                    }
                    lab = db.findLabel(x, y, z);
                    for (q = 0; q < 5; ++q) {
                        array[q] = lab == null ? "*" : lab.Labels[q];
                    }
                    if (array[0].indexOf("Cerebellum") >= 0 && array[3].equals("*")) {
                        array[3] = "Gray Matter";
                    }
                    String label = "";
                    for (q = 0; q < 5; ++q) {
                        label = String.valueOf(String.valueOf(label)).concat(String.valueOf(String.valueOf(array[q])));
                        if (q == 4) continue;
                        label = String.valueOf(String.valueOf(label)).concat(String.valueOf(String.valueOf(sep)));
                    }
                    boolean found = false;
                    for (int q2 = 0; q2 < length; q2 = (int)((short)(q2 + 1))) {
                        if (!labels[q2].equals(label)) continue;
                        image[index] = q2;
                        found = true;
                        break;
                    }
                    if (!found) {
                        labels[length] = label;
                        image[index] = length;
                        length = (short)(length + 1);
                        System.out.println(String.valueOf(String.valueOf(new StringBuffer("slice ").append(z).append(": \t").append(label))));
                    }
                    ++x;
                }
                ++y;
            }
            ++z;
        }
        String first = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(length))).append(" ").append((int)min.x).append(" ").append((int)min.y).append(" ").append((int)min.z).append(" ").append((int)max.x).append(" ").append((int)max.y).append(" ").append((int)max.z)));
        String[] header = new String[length + 1];
        header[0] = first;
        for (int q = 1; q <= length; ++q) {
            header[q] = labels[q - 1];
        }
        StringUtilities.writeStrings(String.valueOf(String.valueOf(output)).concat(".txt"), header);
        AnalyzeIO.writeImage(String.valueOf(String.valueOf(output)).concat(".img"), image);
        AnalyzeIO.writeHeader(output, hdr);
    }

    public void createSortedImage() {
        int i;
        int i2;
        long start = System.currentTimeMillis();
        System.out.print("loading the TD database...");
        Database db = new Database();
        db.loadImage("talairach");
        if (!db.loaded) {
            System.out.println("\nDatabase did not load - ".concat(String.valueOf(String.valueOf(db.Error))));
            return;
        }
        long diff = System.currentTimeMillis() - start;
        System.out.println(String.valueOf(String.valueOf(new StringBuffer(" loaded (").append(diff / (long)1000).append(" sec)\n"))));
        int length = 0;
        int maxLabels = 1920;
        String[] labels = new String[maxLabels];
        int[] count = new int[maxLabels];
        System.out.print("loading in labels...");
        try {
            int nLines = StringUtilities.CountLinesInFile("talairach.txt");
            BufferedReader reader = FileIO.openReader(this.getClass(), "talairach.txt");
            if (reader == null) {
                nLines = 0;
            }
            for (int i3 = 0; i3 < nLines; ++i3) {
                String line = reader.readLine();
                if (line == null || line.length() <= 0) continue;
                labels[length++] = line;
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        System.out.println(String.valueOf(String.valueOf(new StringBuffer("found ").append(length + 1).append(" labels\n"))));
        XyzCoordinates min = db.getMin();
        XyzCoordinates max = db.getMax();
        XyzCoordinates size = db.getSize();
        TDLabel lab = null;
        String sep = ".";
        String[] array = new String[5];
        int perSlice = 5;
        start = System.currentTimeMillis();
        System.out.println("count how often each label is used");
        System.out.print("slice ");
        int z = (int)min.z;
        while ((float)z <= max.z) {
            if (z % perSlice == 0) {
                System.out.print(String.valueOf(String.valueOf(z)).concat("..."));
            }
            int y = (int)min.y;
            while ((float)y <= max.y) {
                int x = (int)min.x;
                while ((float)x <= max.x) {
                    lab = db.findLabel(x, y, z);
                    for (i2 = 0; i2 < 5; ++i2) {
                        array[i2] = lab == null ? "*" : lab.Labels[i2];
                    }
                    if (array[0].indexOf("Cerebellum") >= 0 && array[3].equals("*")) {
                        array[3] = "Gray Matter";
                    }
                    String label = "";
                    for (i2 = 0; i2 < 5; ++i2) {
                        label = String.valueOf(String.valueOf(label)).concat(String.valueOf(String.valueOf(array[i2])));
                        if (i2 == 4) continue;
                        label = String.valueOf(String.valueOf(label)).concat(String.valueOf(String.valueOf(sep)));
                    }
                    boolean found = false;
                    for (i = 0; i < length; ++i) {
                        if (!labels[i].equals(label)) continue;
                        int n = i;
                        count[n] = count[n] + 1;
                        found = true;
                        break;
                    }
                    if (!found) {
                        labels[length] = label;
                        int n = length++;
                        count[n] = count[n] + 1;
                    }
                    ++x;
                }
                ++y;
            }
            ++z;
        }
        diff = System.currentTimeMillis() - start;
        System.out.println(String.valueOf(String.valueOf(new StringBuffer("\ntook ").append(diff / (long)1000).append(" seconds\n"))));
        start = System.currentTimeMillis();
        System.out.print("sorting labels...");
        boolean unusedLabels = false;
        int[] tally = new int[maxLabels];
        String[] sorted = new String[maxLabels];
        for (i2 = 0; i2 < length; ++i2) {
            int biggest = -1;
            int index = -1;
            for (int j = 0; j < length; ++j) {
                if (count[j] <= biggest) continue;
                index = j;
                biggest = count[j];
            }
            if (biggest < 0) {
                System.out.println("\nWarning: stopping at i=".concat(String.valueOf(String.valueOf(i2))));
                length = i2;
                break;
            }
            if (biggest == 0) {
                unusedLabels = true;
                continue;
            }
            tally[i2] = biggest;
            sorted[i2] = labels[index];
            count[index] = -1;
        }
        if (unusedLabels) {
            System.out.println("\nfound unused labels:");
            for (i2 = 0; i2 < length; ++i2) {
                if (tally[i2] != 0) continue;
                System.out.println("  ".concat(String.valueOf(String.valueOf(labels[i2]))));
            }
        }
        labels = new String[length + 1];
        labels[0] = "index  #voxels  label";
        for (i = 0; i < length; ++i) {
            String s = " ";
            if (i < 10) {
                s = String.valueOf(String.valueOf(s)).concat(" ");
            }
            if (i < 100) {
                s = String.valueOf(String.valueOf(s)).concat(" ");
            }
            if (i < 1000) {
                s = String.valueOf(String.valueOf(s)).concat(" ");
            }
            s = String.valueOf(String.valueOf(s)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(i)).concat("  "))));
            if (tally[i] < 10) {
                s = String.valueOf(String.valueOf(s)).concat(" ");
            }
            if (tally[i] < 100) {
                s = String.valueOf(String.valueOf(s)).concat(" ");
            }
            if (tally[i] < 1000) {
                s = String.valueOf(String.valueOf(s)).concat(" ");
            }
            if (tally[i] < 10000) {
                s = String.valueOf(String.valueOf(s)).concat(" ");
            }
            if (tally[i] < 100000) {
                s = String.valueOf(String.valueOf(s)).concat(" ");
            }
            if (tally[i] < 1000000) {
                s = String.valueOf(String.valueOf(s)).concat(" ");
            }
            s = String.valueOf(String.valueOf(s)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(tally[i])).concat("  "))));
            labels[i + 1] = s = String.valueOf(String.valueOf(s)).concat(String.valueOf(String.valueOf(sorted[i])));
        }
        StringUtilities.writeStrings("talairach_sorted.txt", sorted);
        StringUtilities.writeStrings("talairach_tally.txt", labels);
        diff = System.currentTimeMillis() - start;
        System.out.println(String.valueOf(String.valueOf(new StringBuffer("done (").append(diff / (long)1000).append(" sec)\n"))));
    }

    public void findBounds() {
        int z;
        int z2;
        int index;
        int i;
        int j;
        int k;
        int x;
        int y;
        XyzCoordinates min = new XyzCoordinates();
        min.x = -128.0f;
        min.y = -128.0f;
        min.z = -50.0f;
        XyzCoordinates max = new XyzCoordinates();
        max.x = 128.0f;
        max.y = 128.0f;
        max.z = 80.0f;
        XyzCoordinates size = new XyzCoordinates();
        size.x = max.x - min.x + 1.0f;
        size.y = max.y - min.y + 1.0f;
        size.z = max.z - min.z + 1.0f;
        short[] dim = new short[]{4, (short)size.x, (short)size.y, (short)size.z, 1};
        AnalyzeHeader hdr = new AnalyzeHeader();
        hdr.setBytes(AnalyzeHeader.readHeaderBytes("128.hdr"));
        hdr.setDimensions(dim);
        hdr.setType(AnalyzeHeader.DT_SHORT);
        short[] image = hdr.readShortImage("128.img");
        int zmin = 0;
        int zmax = 0;
        int ymin = 0;
        int ymax = 0;
        int xmin = 0;
        int xmax = 0;
        boolean found = false;
        int z3 = (int)min.z;
        while (!found && (float)z3 <= max.z) {
            y = (int)min.y;
            while (!found && (float)y <= max.y) {
                x = (int)min.x;
                while (!found && (float)x <= max.x) {
                    k = z3 - (int)min.z;
                    j = y - (int)min.y;
                    i = x - (int)min.x;
                    index = (int)size.x * (int)size.y * k + (int)size.y * j + i;
                    if (index < 0 || index >= image.length) {
                        System.out.println("bad index: ".concat(String.valueOf(String.valueOf(index))));
                        break;
                    }
                    if (image[index] != 0) {
                        zmin = z3;
                        found = true;
                    }
                    ++x;
                }
                ++y;
            }
            ++z3;
        }
        found = false;
        for (z3 = (int)max.z - 1; !found && z3 >= 0; --z3) {
            y = (int)min.y;
            while (!found && (float)y <= max.y) {
                x = (int)min.x;
                while (!found && (float)x <= max.x) {
                    k = z3 - (int)min.z;
                    j = y - (int)min.y;
                    i = x - (int)min.x;
                    index = (int)size.x * (int)size.y * k + (int)size.y * j + i;
                    if (index < 0 || index >= image.length) {
                        System.out.println("bad index: ".concat(String.valueOf(String.valueOf(index))));
                        break;
                    }
                    if (image[index] != 0) {
                        zmax = z3;
                        found = true;
                    }
                    ++x;
                }
                ++y;
            }
        }
        found = false;
        int y2 = (int)min.y;
        while (!found && (float)y2 <= max.y) {
            z2 = (int)min.z;
            while (!found && (float)z2 <= max.z) {
                x = (int)min.x;
                while (!found && (float)x <= max.x) {
                    k = z2 - (int)min.z;
                    j = y2 - (int)min.y;
                    i = x - (int)min.x;
                    index = (int)size.x * (int)size.y * k + (int)size.y * j + i;
                    if (index < 0 || index >= image.length) {
                        System.out.println("bad index: ".concat(String.valueOf(String.valueOf(index))));
                        break;
                    }
                    if (image[index] != 0) {
                        ymin = y2;
                        found = true;
                    }
                    ++x;
                }
                ++z2;
            }
            ++y2;
        }
        found = false;
        for (y2 = (int)max.y - 1; !found && y2 >= 0; --y2) {
            z2 = (int)min.z;
            while (!found && (float)z2 <= max.z) {
                x = (int)min.x;
                while (!found && (float)x <= max.x) {
                    k = z2 - (int)min.z;
                    j = y2 - (int)min.y;
                    i = x - (int)min.x;
                    index = (int)size.x * (int)size.y * k + (int)size.y * j + i;
                    if (index < 0 || index >= image.length) {
                        System.out.println("bad index: ".concat(String.valueOf(String.valueOf(index))));
                        break;
                    }
                    if (image[index] != 0) {
                        ymax = y2;
                        found = true;
                    }
                    ++x;
                }
                ++z2;
            }
        }
        found = false;
        int x2 = (int)min.x;
        while (!found && (float)x2 <= max.x) {
            y = (int)min.y;
            while (!found && (float)y <= max.y) {
                z = (int)min.z;
                while (!found && (float)z <= max.z) {
                    k = z - (int)min.z;
                    j = y - (int)min.y;
                    i = x2 - (int)min.x;
                    index = (int)size.x * (int)size.y * k + (int)size.y * j + i;
                    if (index < 0 || index >= image.length) {
                        System.out.println("bad index: ".concat(String.valueOf(String.valueOf(index))));
                        break;
                    }
                    if (image[index] != 0) {
                        xmin = x2;
                        found = true;
                    }
                    ++z;
                }
                ++y;
            }
            ++x2;
        }
        found = false;
        for (x2 = (int)max.x - 1; !found && x2 >= 0; --x2) {
            y = (int)min.y;
            while (!found && (float)y <= max.y) {
                z = (int)min.z;
                while (!found && (float)z <= max.z) {
                    k = z - (int)min.z;
                    j = y - (int)min.y;
                    i = x2 - (int)min.x;
                    index = (int)size.x * (int)size.y * k + (int)size.y * j + i;
                    if (index < 0 || index >= image.length) {
                        System.out.println("bad index: ".concat(String.valueOf(String.valueOf(index))));
                        break;
                    }
                    if (image[index] != 0) {
                        xmax = x2;
                        found = true;
                    }
                    ++z;
                }
                ++y;
            }
        }
        System.out.println(String.valueOf(String.valueOf(new StringBuffer("xmin: ").append(xmin).append(", xmax: ").append(xmax))));
        System.out.println(String.valueOf(String.valueOf(new StringBuffer("ymin: ").append(ymin).append(", ymax: ").append(ymax))));
        System.out.println(String.valueOf(String.valueOf(new StringBuffer("zmin: ").append(zmin).append(", zmax: ").append(zmax))));
    }

    /*
     * Unable to fully structure code
     */
    public void createShortImage() {
        cerebellarGray = true;
        saveName = "tal_new";
        start = System.currentTimeMillis();
        System.out.print("loading the TD database...");
        tal = new TalairachUtility();
        db = new Database();
        db.loadImage("128");
        if (!db.loaded) {
            System.out.println("\nDatabase did not load - ".concat(String.valueOf(String.valueOf(db.Error))));
            return;
        }
        diff = System.currentTimeMillis() - start;
        System.out.println(String.valueOf(String.valueOf(new StringBuffer(" loaded (").append(diff / (long)1000).append(" sec)\n"))));
        maxLabels = 1280;
        nLabels = 0;
        labels = new String[maxLabels];
        System.out.print("loading in labels...");
        try {
            labelPath = "talairach.txt-sdlkfj";
            nLines = StringUtilities.CountLinesInFile(labelPath);
            reader = FileIO.openReader(this.getClass(), labelPath);
            for (i = 0; i < nLines; ++i) {
                line = reader.readLine();
                if (line == null || line.length() < 5) continue;
                labels[nLabels++] = reader.readLine();
            }
        }
        catch (Throwable labelPath) {
            // empty catch block
        }
        System.out.println(String.valueOf(String.valueOf(new StringBuffer("found ").append(nLabels).append("\n"))));
        brainMin = db.getMin();
        brainMax = db.getMax();
        size = db.getSize();
        brainMin = new XyzCoordinates();
        brainMin.x = -70.0f;
        brainMin.y = -102.0f;
        brainMin.z = -42.0f;
        brainMax = new XyzCoordinates();
        brainMax.x = 70.0f;
        brainMax.y = 69.0f;
        brainMax.z = 67.0f;
        size = new XyzCoordinates();
        size.x = brainMax.x - brainMin.x + (float)true;
        size.y = brainMax.y - brainMin.y + (float)true;
        size.z = brainMax.z - brainMin.z + (float)true;
        System.out.println(String.valueOf(String.valueOf(new StringBuffer("creating image ").append(brainMin.toString()).append(" to ").append(brainMax.toString()))));
        nVoxels = (int)(size.x * size.y * size.z);
        image = new short[nVoxels];
        netString = "";
        sep = ".";
        blank = new String[]{"*", "*", "*", "*", "*"};
        perSlice = 1;
        start = System.currentTimeMillis();
        for (i = 0; i < image.length; ++i) {
            x = i % (int)size.x;
            y = i / (int)size.x % (int)size.y;
            z = i / (int)(size.x * size.y);
            x = (int)brainMax.x - x;
            y = (int)((float)y + brainMin.y);
            if ((z = (int)((float)z + brainMin.z)) % perSlice == 0 && (float)x == brainMax.x && (float)y == brainMin.y) {
                System.out.println("slice: ".concat(String.valueOf(String.valueOf(z))));
            }
            image[i] = 0;
            label = null;
            current = (String[])blank.clone();
            if (db.loaded) {
                try {
                    label = db.findLabel(x, y, z);
                    for (j = 0; j < 5; ++j) {
                        current[j] = label.Labels[j];
                    }
                }
                catch (Throwable t) {
                    if (label == null) ** GOTO lbl97
                    if (label.Labels == null || label.Labels.length != 5) {
                        System.out.println(String.valueOf(String.valueOf(new StringBuffer("non-standard label at ").append(x).append(",").append(y).append(",").append(z))));
                        t.printStackTrace();
                    }
                    t.printStackTrace();
                }
            } else {
                netString = tal.run(x, y, z);
                tries = 1;
                while (netString.startsWith("Could not connect")) {
                    try {
                        this.wait(2000L);
                    }
                    catch (Throwable t) {
                        message = t.getMessage();
                        var31_41 = "woe is me";
                    }
                    netString = tal.run(x, y, z);
                    ++tries;
                }
                st = new StringTokenizer(netString, ",");
                j = 0;
                while (st.hasMoreTokens()) {
                    current[j] = st.nextToken();
                    ++j;
                }
            }
lbl97:
            // 5 sources

            if (cerebellarGray && current[0].indexOf("Cerebellum") > 0 && current[3].equals("*")) {
                current[3] = "Gray Matter";
            }
            s = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(current[0]))).append(sep).append(current[1]).append(sep).append(current[2]).append(sep).append(current[3]).append(sep).append(current[4])));
            found = false;
            for (j = 0; j < nLabels; ++j) {
                if (!s.equals(labels[j])) continue;
                image[i] = (short)j;
                found = true;
                break;
            }
            if (found) continue;
            System.out.println("adding ".concat(String.valueOf(String.valueOf(s))));
            labels[nLabels] = s;
            image[i] = (short)nLabels;
            ++nLabels;
        }
        diff = System.currentTimeMillis() - start;
        System.out.println(String.valueOf(String.valueOf(new StringBuffer("\ncreated in ").append(diff / (long)1000).append(" seconds\n"))));
        System.out.println(String.valueOf(String.valueOf(new StringBuffer("saving image: ").append(saveName).append(".img"))));
        AnalyzeIO.writeImage(String.valueOf(String.valueOf(saveName)).concat(".img"), image);
        System.out.println(String.valueOf(String.valueOf(new StringBuffer("saving labels: ").append(saveName).append(".txt"))));
        first = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(nLabels))).append(" ").append((int)brainMin.x).append(" ").append((int)brainMin.y).append(" ").append((int)brainMin.z).append(" ").append((int)brainMax.x).append(" ").append((int)brainMax.y).append(" ").append((int)brainMax.z)));
        header = new String[nLabels + 1];
        header[0] = first;
        for (i = 1; i <= nLabels; ++i) {
            header[i] = labels[i - 1];
        }
        StringUtilities.writeStrings(String.valueOf(String.valueOf(saveName)).concat(".txt"), header);
        System.out.println(String.valueOf(String.valueOf(new StringBuffer("saving header: ").append(saveName).append(".hdr"))));
        head = AnalyzeIO.newHeader();
        dim = new short[]{4, (short)size.x, (short)size.y, (short)size.z};
        head.setDimensions(dim);
        head.setMax(nLabels);
        head.setMin(0.0f);
        head.setType(AnalyzeHeader.DT_SHORT);
        head.setDescription("");
        AnalyzeIO.writeHeader(saveName, head);
    }

    public void compareDatabases() {
        boolean image = true;
        boolean image2 = true;
        boolean daemon = false;
        Database d1 = new Database();
        Database d2 = new Database();
        TalairachUtility tu = null;
        if (image) {
            d1.loadFromShortImage("bounds");
        }
        if (image2) {
            d2.load(NiftiImage.readNiftiImage("talairach.nii"));
        }
        if (daemon) {
            tu = new TalairachUtility();
        }
        XyzCoordinates min = d1.getMin();
        XyzCoordinates max = d1.getMax();
        TDLabel lab1 = null;
        TDLabel lab2 = null;
        String sep = ".";
        String label1 = "";
        String label2 = "";
        String label3 = "";
        String label4 = "";
        String[] array1 = new String[5];
        String[] array2 = new String[5];
        String[] array3 = new String[5];
        String netString = null;
        System.out.print("slice ");
        int z = (int)min.z;
        while ((float)z <= max.z) {
            if (z % 5 == 0) {
                System.out.print(String.valueOf(String.valueOf(z)).concat("..."));
            }
            int y = (int)min.y;
            while ((float)y <= max.y) {
                int x = (int)min.x;
                while ((float)x <= max.x) {
                    if (image) {
                        lab1 = d1.findLabel(x, y, z);
                    }
                    if (image2) {
                        lab2 = d2.findLabel(x, y, z);
                    }
                    if (daemon) {
                        array3 = new String[]{"*", "*", "*", "*", "*"};
                        int tries = 0;
                        do {
                            netString = tu.run(x, y, z);
                            try {
                                this.wait(500L);
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                            ++tries;
                        } while (netString.startsWith("Could not connect"));
                        if (tries > 4) {
                            System.out.println(String.valueOf(String.valueOf(tries)).concat(" tries"));
                        }
                        StringTokenizer st = new StringTokenizer(netString, ",");
                        for (int i = 0; st.hasMoreTokens() && i < 5; ++i) {
                            array3[i] = st.nextToken();
                        }
                    }
                    for (int i = 0; i < 5; ++i) {
                        if (image) {
                            array1[i] = lab1 == null ? "*" : lab1.Labels[i];
                        }
                        if (!image2) continue;
                        array2[i] = lab2 == null ? "*" : lab2.Labels[i];
                    }
                    if (image) {
                        label1 = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(array1[0]))).append(sep).append(array1[1]).append(sep).append(array1[2]).append(sep).append(array1[3]).append(sep).append(array1[4])));
                    }
                    if (image2) {
                        label2 = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(array2[0]))).append(sep).append(array2[1]).append(sep).append(array2[2]).append(sep).append(array2[3]).append(sep).append(array2[4])));
                    }
                    if (daemon) {
                        label3 = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(array3[0]))).append(sep).append(array3[1]).append(sep).append(array3[2]).append(sep).append(array3[3]).append(sep).append(array3[4])));
                    }
                    if (!(label1.equals(label2) || array2[3].equals("*") && array1[3].equals("Gray Matter") && array2[0].indexOf("Cerebellum") > 0 || array1[3].equals("*") && array2[3].equals("Gray Matter") && array2[0].indexOf("Cerebellum") > 0)) {
                        System.out.println();
                        System.out.println(String.valueOf(String.valueOf(new StringBuffer("Found a difference at ").append(x).append(",").append(y).append(",").append(z).append(":"))));
                        if (image) {
                            System.out.println("image:  ".concat(String.valueOf(String.valueOf(label1))));
                        }
                        if (image2) {
                            System.out.println("image:  ".concat(String.valueOf(String.valueOf(label2))));
                        }
                        if (daemon) {
                            System.out.println("daemon: ".concat(String.valueOf(String.valueOf(label3))));
                        }
                        System.out.println();
                    }
                    ++x;
                }
                ++y;
            }
            ++z;
        }
        System.out.println("\ndone");
    }

    public void tallyImage() {
        int i;
        boolean prependTally = false;
        Database db = new Database();
        db.loadImage("networkTDImage");
        XyzCoordinates min = db.getMin();
        XyzCoordinates max = db.getMax();
        int length = 0;
        int maxSize = 1280;
        String[] labels = new String[maxSize];
        int[] count = new int[maxSize];
        System.out.print("loading in labels...");
        try {
            int nLines = StringUtilities.CountLinesInFile("talairach_sorted.txt");
            BufferedReader reader = FileIO.openReader(this.getClass(), "talairach_sorted.txt");
            for (int i2 = 0; i2 < nLines; ++i2) {
                labels[i2] = reader.readLine();
                length = i2 + 1;
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        System.out.println(String.valueOf(String.valueOf(new StringBuffer("found ").append(length).append("\n"))));
        TDLabel lab = null;
        String sep = ".";
        String[] array = new String[5];
        System.out.print("slice ");
        int z = (int)min.z;
        while ((float)z <= max.z) {
            if (z % 5 == 0) {
                System.out.print(String.valueOf(String.valueOf(z)).concat("..."));
            }
            int y = (int)min.y;
            while ((float)y <= max.y) {
                int x = (int)min.x;
                while ((float)x <= max.x) {
                    int i3;
                    lab = db.findLabel(x, y, z);
                    for (i3 = 0; i3 < 5; ++i3) {
                        array[i3] = lab == null ? "*" : lab.Labels[i3];
                    }
                    String label = "";
                    for (i3 = 0; i3 < 5; ++i3) {
                        label = String.valueOf(String.valueOf(label)).concat(String.valueOf(String.valueOf(array[i3])));
                        if (i3 == 4) continue;
                        label = String.valueOf(String.valueOf(label)).concat(String.valueOf(String.valueOf(sep)));
                    }
                    boolean found = false;
                    for (int i4 = 0; i4 < length; ++i4) {
                        if (!labels[i4].equals(label)) continue;
                        int n = i4;
                        count[n] = count[n] + 1;
                        found = true;
                        break;
                    }
                    if (!found) {
                        labels[length] = label;
                        int n = length++;
                        count[n] = count[n] + 1;
                    }
                    ++x;
                }
                ++y;
            }
            ++z;
        }
        System.out.println("\n");
        System.out.println("sorting labels");
        int[] tally = new int[length];
        String[] sorted = new String[length];
        for (i = 0; i < length; ++i) {
            int biggest = -1;
            int index = -1;
            for (int j = 0; j < length; ++j) {
                if (count[j] <= biggest) continue;
                index = j;
                biggest = count[j];
            }
            if (biggest <= 0) {
                System.out.println("stopping at i=".concat(String.valueOf(String.valueOf(i))));
                break;
            }
            tally[i] = biggest;
            sorted[i] = prependTally ? String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(biggest))).append("\t").append(labels[index]))) : labels[index];
            count[index] = -1;
        }
        StringUtilities.writeStrings("network_sorted.txt", sorted);
        for (i = 0; i < length; ++i) {
            System.out.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(tally[i]))).append("\t").append(sorted[i]))));
        }
    }
}

