/*
 * Decompiled with CFR 0.152.
 */
package org.brainmap.util;

import java.io.File;
import java.util.ArrayList;
import org.brainmap.util.StringUtilities;

public class MatrixTools {
    public static double[][] multiply(double[][] mat1, double[][] mat2) {
        if (mat1 == null || mat2 == null || mat1.length == 0 || mat2.length == 0) {
            return null;
        }
        int A = mat1.length;
        int B = mat1[0].length;
        for (int i = 0; i < A; ++i) {
            if (mat1[i].length == B) continue;
            return null;
        }
        int C = mat2.length;
        int D = mat2[0].length;
        for (int i = 0; i < C; ++i) {
            if (mat2[i].length == D) continue;
            return null;
        }
        if (B != C) {
            return null;
        }
        double[][] result = new double[A][D];
        for (int d = 0; d < D; ++d) {
            for (int a = 0; a < A; ++a) {
                float sum = 0.0f;
                for (int b = 0; b < B; ++b) {
                    sum = (float)((double)sum + mat1[a][b] * mat2[b][d]);
                }
                result[a][d] = sum;
            }
        }
        return result;
    }

    public static boolean equals(double[][] mat1, double[][] mat2) {
        int i;
        if (mat1 == null || mat2 == null || mat1.length == 0 || mat2.length == 0) {
            return false;
        }
        int A = mat1.length;
        int B = mat1[0].length;
        for (i = 0; i < A; ++i) {
            if (mat1[i].length == B) continue;
            return false;
        }
        if (mat2.length != A) {
            return false;
        }
        for (i = 0; i < A; ++i) {
            if (mat2[i].length == B) continue;
            return false;
        }
        for (int a = 0; a < A; ++a) {
            for (int b = 0; b < B; ++b) {
                if (mat1[a][b] == mat2[a][b]) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isSquare(double[][] matrix) {
        if (matrix == null || matrix.length == 0) {
            return false;
        }
        int A = matrix.length;
        int B = matrix[0].length;
        for (int i = 0; i < A; ++i) {
            if (matrix[i].length == B) continue;
            return false;
        }
        return A == B;
    }

    public static boolean isSymmetric(double[][] matrix) {
        int a;
        if (matrix == null || matrix.length == 0) {
            return false;
        }
        int A = matrix.length;
        int B = matrix[0].length;
        for (a = 0; a < A; ++a) {
            if (matrix[a].length == B) continue;
            return false;
        }
        if (A != B) {
            return false;
        }
        for (a = 0; a < A; ++a) {
            for (int b = 0; b < B; ++b) {
                if (matrix[a][b] == matrix[b][a]) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isBoolean(double[][] matrix) {
        int a;
        if (matrix == null || matrix.length == 0) {
            return false;
        }
        int A = matrix.length;
        int B = matrix[0].length;
        for (a = 0; a < A; ++a) {
            if (matrix[a].length == B) continue;
            return false;
        }
        for (a = 0; a < A; ++a) {
            for (int b = 0; b < B; ++b) {
                if (matrix[a][b] == 0.0 || matrix[a][b] == 1.0) continue;
                return false;
            }
        }
        return true;
    }

    public static double[][] transpose(double[][] matrix) {
        if (matrix == null || matrix.length == 0) {
            return null;
        }
        int A = matrix.length;
        int B = matrix[0].length;
        for (int i = 0; i < A; ++i) {
            if (matrix[i].length == B) continue;
            return null;
        }
        double[][] result = new double[B][A];
        for (int a = 0; a < A; ++a) {
            for (int b = 0; b < B; ++b) {
                result[b][a] = matrix[a][b];
            }
        }
        return result;
    }

    public static float[][] inverse(float[][] matrix) {
        if (matrix == null || matrix.length <= 1 || !MatrixTools.isSquare(matrix)) {
            return null;
        }
        float[][] cofactors = new float[matrix.length][matrix.length];
        for (int row = 0; row < matrix.length; ++row) {
            for (int col = 0; col < matrix.length; ++col) {
                cofactors[row][col] = MatrixTools.cofactor(matrix, row, col);
            }
        }
        float[][] adjoint = MatrixTools.transpose(cofactors);
        float determinant = MatrixTools.determinant(matrix);
        for (int row = 0; row < matrix.length; ++row) {
            int col = 0;
            while (col < matrix.length) {
                float[] fArray = adjoint[row];
                int n = col++;
                fArray[n] = fArray[n] / determinant;
            }
        }
        return adjoint;
    }

    public static float determinant(float[][] matrix) {
        if (matrix == null || matrix.length <= 1 || !MatrixTools.isSquare(matrix)) {
            System.out.println("no determinant");
            return 0.0f;
        }
        if (matrix.length == 2) {
            return matrix[0][0] * matrix[1][1] - matrix[1][0] * matrix[0][1];
        }
        float sum = 0.0f;
        for (int i = 0; i < matrix.length; ++i) {
            sum += matrix[0][i] * MatrixTools.cofactor(matrix, 0, i);
        }
        return sum;
    }

    public static float cofactor(float[][] matrix, int i, int j) {
        if (matrix == null || matrix.length < 1 || !MatrixTools.isSquare(matrix)) {
            return 0.0f;
        }
        int negative = -1;
        if ((i + j) % 2 == 0) {
            negative = 1;
        }
        float[][] beta = new float[matrix.length - 1][matrix.length - 1];
        for (int row = 0; row < matrix.length; ++row) {
            if (row == i) continue;
            int indexR = row;
            if (row > i) {
                --indexR;
            }
            for (int col = 0; col < matrix.length; ++col) {
                if (col == j) continue;
                int indexC = col;
                if (col > j) {
                    --indexC;
                }
                beta[indexR][indexC] = matrix[row][col];
            }
        }
        return (float)negative * MatrixTools.determinant(beta);
    }

    public static float[][] toFloat(double[][] matrix) {
        if (matrix == null || matrix.length == 0) {
            return null;
        }
        int A = matrix.length;
        int B = matrix[0].length;
        for (int i = 0; i < A; ++i) {
            if (matrix[i].length == B) continue;
            return null;
        }
        float[][] result = new float[A][B];
        for (int a = 0; a < A; ++a) {
            for (int b = 0; b < B; ++b) {
                result[a][b] = (float)matrix[a][b];
            }
        }
        return result;
    }

    public static double[][] toDouble(int[][] matrix) {
        if (matrix == null || matrix.length == 0) {
            return null;
        }
        int A = matrix.length;
        int B = matrix[0].length;
        for (int i = 0; i < A; ++i) {
            if (matrix[i].length == B) continue;
            return null;
        }
        double[][] result = new double[A][B];
        for (int a = 0; a < A; ++a) {
            for (int b = 0; b < B; ++b) {
                result[a][b] = matrix[a][b];
            }
        }
        return result;
    }

    public static void print(double[][] matrix) {
        if (matrix == null || matrix.length == 0) {
            return;
        }
        int A = matrix.length;
        int B = matrix[0].length;
        for (int i = 0; i < A; ++i) {
            if (matrix[i].length == B) continue;
            return;
        }
        for (int a = 0; a < A; ++a) {
            System.out.print("[ ");
            for (int b = 0; b < B; ++b) {
                System.out.print(String.valueOf(String.valueOf(matrix[a][b])).concat(" "));
            }
            System.out.println("]");
        }
    }

    public static double[][] copy(double[][] matrix) {
        if (matrix == null || matrix.length == 0) {
            return null;
        }
        int A = matrix.length;
        int B = matrix[0].length;
        for (int i = 0; i < A; ++i) {
            if (matrix[i].length == B) continue;
            return null;
        }
        double[][] result = new double[A][B];
        for (int a = 0; a < A; ++a) {
            for (int b = 0; b < B; ++b) {
                result[a][b] = matrix[a][b];
            }
        }
        return result;
    }

    public static float[][] multiply(float[][] mat1, float[][] mat2) {
        if (mat1 == null || mat2 == null || mat1.length == 0 || mat2.length == 0) {
            return null;
        }
        int A = mat1.length;
        int B = mat1[0].length;
        for (int i = 0; i < A; ++i) {
            if (mat1[i].length == B) continue;
            return null;
        }
        int C = mat2.length;
        int D = mat2[0].length;
        for (int i = 0; i < C; ++i) {
            if (mat2[i].length == D) continue;
            return null;
        }
        if (B != C) {
            return null;
        }
        float[][] result = new float[A][D];
        for (int d = 0; d < D; ++d) {
            for (int a = 0; a < A; ++a) {
                float sum = 0.0f;
                for (int b = 0; b < B; ++b) {
                    sum += mat1[a][b] * mat2[b][d];
                }
                result[a][d] = sum;
            }
        }
        return result;
    }

    public static boolean equals(float[][] mat1, float[][] mat2) {
        int i;
        if (mat1 == null || mat2 == null || mat1.length == 0 || mat2.length == 0) {
            return false;
        }
        int A = mat1.length;
        int B = mat1[0].length;
        for (i = 0; i < A; ++i) {
            if (mat1[i].length == B) continue;
            return false;
        }
        if (mat2.length != A) {
            return false;
        }
        for (i = 0; i < A; ++i) {
            if (mat2[i].length == B) continue;
            return false;
        }
        for (int a = 0; a < A; ++a) {
            for (int b = 0; b < B; ++b) {
                if (mat1[a][b] == mat2[a][b]) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isSquare(float[][] matrix) {
        if (matrix == null || matrix.length == 0) {
            return false;
        }
        int A = matrix.length;
        int B = matrix[0].length;
        for (int i = 0; i < A; ++i) {
            if (matrix[i].length == B) continue;
            return false;
        }
        return A == B;
    }

    public static boolean isSymmetric(float[][] matrix) {
        int a;
        if (matrix == null || matrix.length == 0) {
            return false;
        }
        int A = matrix.length;
        int B = matrix[0].length;
        for (a = 0; a < A; ++a) {
            if (matrix[a].length == B) continue;
            return false;
        }
        if (A != B) {
            return false;
        }
        for (a = 0; a < A; ++a) {
            for (int b = 0; b < B; ++b) {
                if (matrix[a][b] == matrix[b][a]) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isBoolean(float[][] matrix) {
        int a;
        if (matrix == null || matrix.length == 0) {
            return false;
        }
        int A = matrix.length;
        int B = matrix[0].length;
        for (a = 0; a < A; ++a) {
            if (matrix[a].length == B) continue;
            return false;
        }
        for (a = 0; a < A; ++a) {
            for (int b = 0; b < B; ++b) {
                if (matrix[a][b] == 0.0f || matrix[a][b] == 1.0f) continue;
                return false;
            }
        }
        return true;
    }

    public static float[][] transpose(float[][] matrix) {
        if (matrix == null || matrix.length == 0) {
            return null;
        }
        int A = matrix.length;
        int B = matrix[0].length;
        for (int i = 0; i < A; ++i) {
            if (matrix[i].length == B) continue;
            return null;
        }
        float[][] result = new float[B][A];
        for (int a = 0; a < A; ++a) {
            for (int b = 0; b < B; ++b) {
                result[b][a] = matrix[a][b];
            }
        }
        return result;
    }

    public static float[][] toFloat(int[][] matrix) {
        if (matrix == null || matrix.length == 0) {
            return null;
        }
        int A = matrix.length;
        int B = matrix[0].length;
        for (int i = 0; i < A; ++i) {
            if (matrix[i].length == B) continue;
            return null;
        }
        float[][] result = new float[A][B];
        for (int a = 0; a < A; ++a) {
            for (int b = 0; b < B; ++b) {
                result[a][b] = matrix[a][b];
            }
        }
        return result;
    }

    public static void print(float[][] matrix) {
        if (matrix == null || matrix.length == 0) {
            return;
        }
        int A = matrix.length;
        int B = matrix[0].length;
        for (int i = 0; i < A; ++i) {
            if (matrix[i].length == B) continue;
            return;
        }
        for (int a = 0; a < A; ++a) {
            System.out.print("[ ");
            for (int b = 0; b < B; ++b) {
                System.out.print(String.valueOf(String.valueOf(matrix[a][b])).concat(" "));
            }
            System.out.println("]");
        }
    }

    public static float[][] copy(float[][] matrix) {
        if (matrix == null || matrix.length == 0) {
            return null;
        }
        int A = matrix.length;
        int B = matrix[0].length;
        for (int i = 0; i < A; ++i) {
            if (matrix[i].length == B) continue;
            return null;
        }
        float[][] result = new float[A][B];
        for (int a = 0; a < A; ++a) {
            for (int b = 0; b < B; ++b) {
                result[a][b] = matrix[a][b];
            }
        }
        return result;
    }

    public static int[][] multiply(int[][] mat1, int[][] mat2) {
        if (mat1 == null || mat2 == null || mat1.length == 0 || mat2.length == 0) {
            return null;
        }
        int A = mat1.length;
        int B = mat1[0].length;
        for (int i = 0; i < A; ++i) {
            if (mat1[i].length == B) continue;
            return null;
        }
        int C = mat2.length;
        int D = mat2[0].length;
        for (int i = 0; i < C; ++i) {
            if (mat2[i].length == D) continue;
            return null;
        }
        if (B != C) {
            return null;
        }
        int[][] result = new int[A][D];
        for (int d = 0; d < D; ++d) {
            for (int a = 0; a < A; ++a) {
                int sum = 0;
                for (int b = 0; b < B; ++b) {
                    sum += mat1[a][b] * mat2[b][d];
                }
                result[a][d] = sum;
            }
        }
        return result;
    }

    public static boolean equals(int[][] mat1, int[][] mat2) {
        int i;
        if (mat1 == null || mat2 == null || mat1.length == 0 || mat2.length == 0) {
            return false;
        }
        int A = mat1.length;
        int B = mat1[0].length;
        for (i = 0; i < A; ++i) {
            if (mat1[i].length == B) continue;
            return false;
        }
        if (mat2.length != A) {
            return false;
        }
        for (i = 0; i < A; ++i) {
            if (mat2[i].length == B) continue;
            return false;
        }
        for (int a = 0; a < A; ++a) {
            for (int b = 0; b < B; ++b) {
                if (mat1[a][b] == mat2[a][b]) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isSquare(int[][] matrix) {
        if (matrix == null || matrix.length == 0) {
            return false;
        }
        int A = matrix.length;
        int B = matrix[0].length;
        for (int i = 0; i < A; ++i) {
            if (matrix[i].length == B) continue;
            return false;
        }
        return A == B;
    }

    public static boolean isSymmetric(int[][] matrix) {
        int a;
        if (matrix == null || matrix.length == 0) {
            return false;
        }
        int A = matrix.length;
        int B = matrix[0].length;
        for (a = 0; a < A; ++a) {
            if (matrix[a].length == B) continue;
            return false;
        }
        if (A != B) {
            return false;
        }
        for (a = 0; a < A; ++a) {
            for (int b = 0; b < B; ++b) {
                if (matrix[a][b] == matrix[b][a]) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isBoolean(int[][] matrix) {
        int a;
        if (matrix == null || matrix.length == 0) {
            return false;
        }
        int A = matrix.length;
        int B = matrix[0].length;
        for (a = 0; a < A; ++a) {
            if (matrix[a].length == B) continue;
            return false;
        }
        for (a = 0; a < A; ++a) {
            for (int b = 0; b < B; ++b) {
                if (matrix[a][b] == 0 || matrix[a][b] == 1) continue;
                return false;
            }
        }
        return true;
    }

    public static int[][] transpose(int[][] matrix) {
        if (matrix == null || matrix.length == 0) {
            return null;
        }
        int A = matrix.length;
        int B = matrix[0].length;
        for (int i = 0; i < A; ++i) {
            if (matrix[i].length == B) continue;
            return null;
        }
        int[][] result = new int[B][A];
        for (int a = 0; a < A; ++a) {
            for (int b = 0; b < B; ++b) {
                result[b][a] = matrix[a][b];
            }
        }
        return result;
    }

    public static int[][] toInteger(float[][] matrix) {
        if (matrix == null || matrix.length == 0) {
            return null;
        }
        int A = matrix.length;
        int B = matrix[0].length;
        for (int i = 0; i < A; ++i) {
            if (matrix[i].length == B) continue;
            return null;
        }
        int[][] result = new int[A][B];
        for (int a = 0; a < A; ++a) {
            for (int b = 0; b < B; ++b) {
                result[a][b] = (int)matrix[a][b];
            }
        }
        return result;
    }

    public static void print(int[][] matrix) {
        if (matrix == null || matrix.length == 0) {
            return;
        }
        int A = matrix.length;
        int B = matrix[0].length;
        for (int i = 0; i < A; ++i) {
            if (matrix[i].length == B) continue;
            return;
        }
        for (int a = 0; a < A; ++a) {
            System.out.print("[ ");
            for (int b = 0; b < B; ++b) {
                System.out.print(String.valueOf(String.valueOf(matrix[a][b])).concat(" "));
            }
            System.out.println("]");
        }
    }

    public static String[] toString(int[][] matrix) {
        if (matrix == null || matrix.length == 0) {
            return null;
        }
        int A = matrix.length;
        int B = matrix[0].length;
        for (int i = 0; i < A; ++i) {
            if (matrix[i].length == B) continue;
            return null;
        }
        String[] result = new String[A];
        int a = 0;
        while (a < A) {
            result[a] = "[ ";
            for (int b = 0; b < B; ++b) {
                int n = a;
                result[n] = String.valueOf(String.valueOf(result[n])).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(matrix[a][b])).concat(" "))));
            }
            int n = a++;
            result[n] = String.valueOf(String.valueOf(result[n])).concat("]");
        }
        return result;
    }

    public static String[] toString(float[][] matrix, int digits) {
        if (matrix == null || matrix.length == 0) {
            return null;
        }
        int A = matrix.length;
        int B = matrix[0].length;
        for (int i = 0; i < A; ++i) {
            if (matrix[i].length == B) continue;
            return null;
        }
        String[] result = new String[A];
        int a = 0;
        while (a < A) {
            result[a] = "[ ";
            for (int b = 0; b < B; ++b) {
                String temp = String.valueOf(String.valueOf(matrix[a][b])).concat("");
                temp = temp.substring(0, digits);
                int n = a;
                result[n] = String.valueOf(String.valueOf(result[n])).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(temp)).concat(" "))));
            }
            int n = a++;
            result[n] = String.valueOf(String.valueOf(result[n])).concat("]");
        }
        return result;
    }

    public static String[] toString(double[][] matrix, int digits) {
        if (matrix == null || matrix.length == 0) {
            return null;
        }
        int A = matrix.length;
        int B = matrix[0].length;
        for (int i = 0; i < A; ++i) {
            if (matrix[i].length == B) continue;
            return null;
        }
        if (digits < 3) {
            digits = 3;
        }
        int mult = 1;
        for (int i = 0; i < digits - 2; ++i) {
            mult *= 10;
        }
        String[] result = new String[A];
        int a = 0;
        while (a < A) {
            result[a] = "[ ";
            for (int b = 0; b < B; ++b) {
                int rounded = (int)Math.round((double)mult * matrix[a][b]);
                double fract = (double)rounded / (double)mult;
                String temp = String.valueOf(String.valueOf(fract)).concat("");
                while (temp.length() < digits) {
                    temp = String.valueOf(String.valueOf(temp)).concat("0");
                }
                temp = temp.substring(0, digits);
                int n = a;
                result[n] = String.valueOf(String.valueOf(result[n])).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(temp)).concat(" "))));
            }
            int n = a++;
            result[n] = String.valueOf(String.valueOf(result[n])).concat("]");
        }
        return result;
    }

    public static int[][] copy(int[][] matrix) {
        if (matrix == null || matrix.length == 0) {
            return null;
        }
        int A = matrix.length;
        int B = matrix[0].length;
        for (int i = 0; i < A; ++i) {
            if (matrix[i].length == B) continue;
            return null;
        }
        int[][] result = new int[A][B];
        for (int a = 0; a < A; ++a) {
            for (int b = 0; b < B; ++b) {
                result[a][b] = matrix[a][b];
            }
        }
        return result;
    }

    public static int[][] add(int[][] mata, int[][] matb) {
        if (mata == null || mata.length == 0 || matb == null || matb.length == 0) {
            return null;
        }
        if (mata.length != matb.length) {
            return null;
        }
        int A = mata.length;
        int B = matb[0].length;
        for (int i = 0; i < A; ++i) {
            if (mata[i].length == B && matb[i].length == B) continue;
            return null;
        }
        int[][] result = new int[A][B];
        for (int a = 0; a < A; ++a) {
            for (int b = 0; b < B; ++b) {
                result[a][b] = mata[a][b] + matb[a][b];
            }
        }
        return result;
    }

    public static boolean isNonZero(int[][] matrix) {
        try {
            int A = matrix.length;
            int B = matrix[0].length;
            for (int a = 0; a < A; ++a) {
                for (int b = 0; b < B; ++b) {
                    if (matrix[a][b] == 0) continue;
                    boolean bl = true;
                    return bl;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static double[][] similar(int[][] A, int[][] B, boolean zeros) {
        int i;
        if (A == null || A.length == 0 || B == null || B.length == 0) {
            return null;
        }
        int x = A.length;
        int y = B[0].length;
        int m = B.length;
        for (i = 0; i < x; ++i) {
            if (A[i].length == m) continue;
            return null;
        }
        for (i = 0; i < m; ++i) {
            if (B[i].length == y) continue;
            return null;
        }
        double[][] result = new double[x][y];
        for (int a = 0; a < x; ++a) {
            for (int b = 0; b < y; ++b) {
                int i2;
                int numerator = 0;
                int denominator = 0;
                if (zeros) {
                    for (i2 = 0; i2 < m; ++i2) {
                        if (A[a][i2] != B[i2][b]) continue;
                        ++numerator;
                    }
                    denominator = m;
                } else {
                    for (i2 = 0; i2 < m; ++i2) {
                        if (A[a][i2] == B[i2][b] && A[a][i2] != 0) {
                            ++numerator;
                        }
                        if (A[a][i2] == 0 && B[i2][b] == 0) continue;
                        ++denominator;
                    }
                }
                result[a][b] = denominator == 0 ? 0.0 : (double)numerator / (double)denominator;
            }
        }
        return result;
    }

    public static int[][] scanIntegerMatrix(File f) {
        String[] current;
        int nLines = StringUtilities.CountLinesInFile(f.getPath());
        String[] file = StringUtilities.getHeader(f.getPath(), nLines);
        ArrayList<String[]> lines = new ArrayList<String[]>();
        int nCol = 0;
        boolean inMatrix = false;
        for (int i = 0; i < nLines; ++i) {
            if (file[i].startsWith("#") || file[i].startsWith("//") || file[i].equals("") || (current = StringUtilities.scan(file[i])).length <= 0 && !inMatrix) continue;
            if (current.length <= 0 || inMatrix && nCol != current.length) break;
            lines.add(current);
            nCol = current.length;
            inMatrix = true;
        }
        if (lines.size() <= 0) {
            return null;
        }
        int nRows = lines.size();
        int nCols = ((String[])lines.get(0)).length;
        int[][] m = new int[nRows][nCols];
        try {
            for (int i = 0; i < nRows; ++i) {
                current = (String[])lines.get(i);
                for (int j = 0; j < nCols; ++j) {
                    m[i][j] = Integer.parseInt(current[j]);
                }
            }
        }
        catch (Exception e) {
            int[][] nArray = null;
            return nArray;
        }
        return m;
    }
}

