/*
 * Decompiled with CFR 0.152.
 */
package org.brainmap.image;

import java.io.PrintStream;
import org.brainmap.image.ImageHeader;
import org.brainmap.image.data_history;
import org.brainmap.image.header_key;
import org.brainmap.image.image_dimension;
import org.brainmap.util.ByteConverter;

public class AnalyzeHeader
extends ImageHeader {
    public static short DT_BYTE = (short)2;
    public static short DT_SHORT = (short)4;
    public static short DT_INT = (short)8;
    public static short DT_FLOAT = (short)16;
    public static short DT_DOUBLE = (short)64;
    header_key hk = new header_key();
    image_dimension dime = new image_dimension();
    data_history dh = new data_history();

    public float[] getVoxelSizes() {
        return this.dime.pixdim;
    }

    public void setVoxelSizes(float[] pixdim) {
        for (int i = 0; i < pixdim.length && i < this.dime.pixdim.length; ++i) {
            this.dime.pixdim[i] = pixdim[i];
        }
    }

    public short[] getDimensions() {
        return this.dime.dim;
    }

    public void setDimensions(short[] dim) {
        for (int i = 0; i < dim.length && i < this.dime.dim.length; ++i) {
            this.dime.dim[i] = dim[i];
        }
    }

    public float getMax() {
        return this.dime.cal_max;
    }

    public float getMin() {
        return this.dime.cal_min;
    }

    public void setMax(float f) {
        this.dime.cal_max = f;
    }

    public void setMin(float f) {
        this.dime.cal_min = f;
    }

    public short getBits() {
        return this.dime.bitpix;
    }

    public short getType() {
        return this.dime.datatype;
    }

    public void setType(short s) {
        switch (s) {
            case 1: {
                this.dime.datatype = 1;
                this.dime.bitpix = 1;
                return;
            }
            case 2: {
                this.dime.datatype = (short)2;
                this.dime.bitpix = (short)8;
                return;
            }
            case 4: {
                this.dime.datatype = (short)4;
                this.dime.bitpix = (short)16;
                return;
            }
            case 8: {
                this.dime.datatype = (short)8;
                this.dime.bitpix = (short)32;
                return;
            }
            case 16: {
                this.dime.datatype = (short)16;
                this.dime.bitpix = (short)32;
                return;
            }
            case 32: {
                this.dime.datatype = (short)32;
                this.dime.bitpix = (short)64;
                return;
            }
            case 64: {
                this.dime.datatype = (short)64;
                this.dime.bitpix = (short)64;
                return;
            }
            case 128: {
                this.dime.datatype = (short)128;
                this.dime.bitpix = (short)128;
                return;
            }
            case 255: {
                this.dime.datatype = (short)255;
                this.dime.bitpix = (short)255;
                return;
            }
        }
        this.dime.datatype = 0;
        this.dime.bitpix = 0;
    }

    public void out(PrintStream out) {
        out.println("sizeof_hdr=".concat(String.valueOf(String.valueOf(this.hk.sizeof_hdr))));
        out.println("data_type=".concat(String.valueOf(String.valueOf(this.toString(this.hk.data_type)))));
        out.println("db_name=".concat(String.valueOf(String.valueOf(this.toString(this.hk.db_name)))));
        out.println("extents=".concat(String.valueOf(String.valueOf(this.hk.extents))));
        out.println("session_error=".concat(String.valueOf(String.valueOf(this.hk.session_error))));
        out.println("regular=".concat(String.valueOf(String.valueOf((char)this.hk.regular))));
        if (this.hk.hkey_un0 == 48) {
            out.println("hkey_un0='0'");
        } else {
            out.println("hkey_un0=".concat(String.valueOf(String.valueOf(this.hk.hkey_un0))));
        }
        out.println(String.valueOf(String.valueOf(new StringBuffer("dim=[ ").append(this.toString(this.dime.dim)).append("]"))));
        out.println("vox_units=".concat(String.valueOf(String.valueOf(this.toString(this.dime.vox_units)))));
        out.println("cal_units=".concat(String.valueOf(String.valueOf(this.toString(this.dime.cal_units)))));
        out.println("unused1=".concat(String.valueOf(String.valueOf(this.dime.unused1))));
        out.println("datatype=".concat(String.valueOf(String.valueOf(this.dime.datatype))));
        out.println("bitpix=".concat(String.valueOf(String.valueOf(this.dime.bitpix))));
        out.println("dim_un0=".concat(String.valueOf(String.valueOf(this.dime.dim_un0))));
        out.println(String.valueOf(String.valueOf(new StringBuffer("pixdim=[ ").append(this.toString(this.dime.pixdim)).append("]"))));
        out.println("vox_offset=".concat(String.valueOf(String.valueOf(this.dime.vox_offset))));
        out.println("funused1=".concat(String.valueOf(String.valueOf(this.dime.funused1))));
        out.println("funused2=".concat(String.valueOf(String.valueOf(this.dime.funused2))));
        out.println("funused3=".concat(String.valueOf(String.valueOf(this.dime.funused3))));
        out.println("cal_max=".concat(String.valueOf(String.valueOf(this.dime.cal_max))));
        out.println("cal_min=".concat(String.valueOf(String.valueOf(this.dime.cal_min))));
        out.println("compressed=".concat(String.valueOf(String.valueOf(this.dime.compressed))));
        out.println("verified=".concat(String.valueOf(String.valueOf(this.dime.verified))));
        out.println("glmax=".concat(String.valueOf(String.valueOf(this.dime.glmax))));
        out.println("glmin=".concat(String.valueOf(String.valueOf(this.dime.glmin))));
        out.println("descrip=".concat(String.valueOf(String.valueOf(this.toString(this.dh.descrip)))));
        out.println("aux_file=".concat(String.valueOf(String.valueOf(this.toString(this.dh.aux_file)))));
        out.println("orient=".concat(String.valueOf(String.valueOf(this.dh.orient))));
        out.println(String.valueOf(String.valueOf(new StringBuffer("originator=[ ").append(this.toString2(this.dh.originator)).append("]"))));
        out.println("generated=".concat(String.valueOf(String.valueOf(this.toString(this.dh.generated)))));
        out.println("scannum=".concat(String.valueOf(String.valueOf(this.toString(this.dh.scannum)))));
        out.println("patient_id=".concat(String.valueOf(String.valueOf(this.toString(this.dh.patient_id)))));
        out.println("exp_date=".concat(String.valueOf(String.valueOf(this.toString(this.dh.exp_date)))));
        out.println("exp_time=".concat(String.valueOf(String.valueOf(this.toString(this.dh.exp_time)))));
        out.println(String.valueOf(String.valueOf(new StringBuffer("hist_un0=[ ").append(this.toString2(this.dh.hist_un0)).append("]"))));
        out.println("views=".concat(String.valueOf(String.valueOf(this.dh.views))));
        out.println("vols_added=".concat(String.valueOf(String.valueOf(this.dh.vols_added))));
        out.println("start_field=".concat(String.valueOf(String.valueOf(this.dh.start_field))));
        out.println("field_skip=".concat(String.valueOf(String.valueOf(this.dh.field_skip))));
        out.println("omax=".concat(String.valueOf(String.valueOf(this.dh.omax))));
        out.println("omin=".concat(String.valueOf(String.valueOf(this.dh.omin))));
        out.println("smax=".concat(String.valueOf(String.valueOf(this.dh.smax))));
        out.println("smin=".concat(String.valueOf(String.valueOf(this.dh.smin))));
    }

    public String getDescription() {
        byte b;
        int length = this.dh.descrip.length;
        String s = "";
        for (int i = 0; i < length && (b = this.dh.descrip[i]) != 0; ++i) {
            s = String.valueOf(String.valueOf(s)).concat(String.valueOf(String.valueOf((char)b)));
        }
        return s;
    }

    public void setDescription(String s) {
        this.fromString(this.dh.descrip, s);
    }

    public byte[] getHeaderKeyBytes() {
        return this.getHeaderKeyBytes(this.hk);
    }

    public byte[] getHeaderKeyBytes(header_key hk) {
        byte[] b = new byte[hk.sizeOf];
        int offset = 0;
        offset = this.addInt(b, offset, hk.sizeof_hdr);
        offset = this.addByteArr(b, offset, hk.data_type);
        offset = this.addByteArr(b, offset, hk.db_name);
        offset = this.addInt(b, offset, hk.extents);
        offset = this.addShort(b, offset, hk.session_error);
        b[offset++] = hk.regular;
        b[offset++] = hk.hkey_un0;
        if (offset != hk.sizeOf) {
            System.out.println("uh-oh");
        }
        return b;
    }

    public void setHeaderKeyBytes(byte[] b) {
        int i;
        if (b.length < this.hk.sizeOf) {
            System.out.println("setHeaderKeyBytes: wrong #bytes");
            return;
        }
        int offset = 0;
        this.hk.sizeof_hdr = ByteConverter.getInt(b, offset);
        offset += 4;
        for (i = 0; i < 10; ++i) {
            this.hk.data_type[i] = b[offset++];
        }
        for (i = 0; i < 18; ++i) {
            this.hk.db_name[i] = b[offset++];
        }
        this.hk.extents = ByteConverter.getInt(b, offset);
        this.hk.session_error = ByteConverter.getShort(b, offset += 4);
        offset += 2;
        this.hk.regular = b[offset++];
        this.hk.hkey_un0 = b[offset++];
        if (offset != this.hk.sizeOf) {
            System.out.println("setHeaderKeyBytes: uh-oh");
        }
    }

    public byte[] getImageDimensionBytes() {
        return this.getImageDimensionBytes(this.dime);
    }

    public byte[] getImageDimensionBytes(image_dimension dime) {
        byte[] b = new byte[dime.sizeOf];
        int offset = 0;
        offset = this.addShortArr(b, offset, dime.dim);
        offset = this.addByteArr(b, offset, dime.vox_units);
        offset = this.addByteArr(b, offset, dime.cal_units);
        offset = this.addShort(b, offset, dime.unused1);
        offset = this.addShort(b, offset, dime.datatype);
        offset = this.addShort(b, offset, dime.bitpix);
        offset = this.addShort(b, offset, dime.dim_un0);
        offset = this.addFloatArr(b, offset, dime.pixdim);
        offset = this.addFloat(b, offset, dime.vox_offset);
        offset = this.addFloat(b, offset, dime.funused1);
        offset = this.addFloat(b, offset, dime.funused2);
        offset = this.addFloat(b, offset, dime.funused3);
        offset = this.addFloat(b, offset, dime.cal_max);
        offset = this.addFloat(b, offset, dime.cal_min);
        offset = this.addInt(b, offset, dime.compressed);
        offset = this.addInt(b, offset, dime.verified);
        offset = this.addInt(b, offset, dime.glmax);
        if ((offset = this.addInt(b, offset, dime.glmin)) != dime.sizeOf) {
            System.out.println("uh-oh");
        }
        return b;
    }

    public void setImageDimensionBytes(byte[] b) {
        int i;
        if (b.length < this.dime.sizeOf) {
            System.out.println("setImageDimensionBytes: wrong #bytes");
            return;
        }
        int offset = 0;
        for (i = 0; i < 8; ++i) {
            this.dime.dim[i] = ByteConverter.getShort(b, offset);
            offset += 2;
        }
        for (i = 0; i < 4; ++i) {
            this.dime.vox_units[i] = b[offset++];
        }
        for (i = 0; i < 8; ++i) {
            this.dime.cal_units[i] = b[offset++];
        }
        this.dime.unused1 = ByteConverter.getShort(b, offset);
        this.dime.datatype = ByteConverter.getShort(b, offset += 2);
        this.dime.bitpix = ByteConverter.getShort(b, offset += 2);
        this.dime.dim_un0 = ByteConverter.getShort(b, offset += 2);
        offset += 2;
        for (i = 0; i < 8; ++i) {
            this.dime.pixdim[i] = ByteConverter.getFloat(b, offset);
            offset += 4;
        }
        this.dime.vox_offset = ByteConverter.getFloat(b, offset);
        this.dime.funused1 = ByteConverter.getFloat(b, offset += 4);
        this.dime.funused2 = ByteConverter.getFloat(b, offset += 4);
        this.dime.funused3 = ByteConverter.getFloat(b, offset += 4);
        this.dime.cal_max = ByteConverter.getFloat(b, offset += 4);
        this.dime.cal_min = ByteConverter.getFloat(b, offset += 4);
        this.dime.compressed = ByteConverter.getInt(b, offset += 4);
        this.dime.verified = ByteConverter.getInt(b, offset += 4);
        this.dime.glmax = ByteConverter.getInt(b, offset += 4);
        this.dime.glmin = ByteConverter.getInt(b, offset += 4);
        if ((offset += 4) != this.dime.sizeOf) {
            System.out.println("setImageDimensionBytes: uh-oh");
        }
    }

    public byte[] getDataHistoryBytes() {
        return this.getDataHistoryBytes(this.dh);
    }

    public byte[] getDataHistoryBytes(data_history dh) {
        int i;
        byte[] b = new byte[dh.sizeOf];
        int offset = 0;
        for (i = 0; i < dh.descrip.length; ++i) {
            b[offset++] = dh.descrip[i];
        }
        for (i = 0; i < dh.aux_file.length; ++i) {
            b[offset++] = dh.aux_file[i];
        }
        b[offset++] = dh.orient;
        offset = this.addByteArr(b, offset, dh.originator);
        offset = this.addByteArr(b, offset, dh.generated);
        offset = this.addByteArr(b, offset, dh.scannum);
        offset = this.addByteArr(b, offset, dh.patient_id);
        offset = this.addByteArr(b, offset, dh.exp_date);
        offset = this.addByteArr(b, offset, dh.exp_time);
        offset = this.addByteArr(b, offset, dh.hist_un0);
        offset = this.addInt(b, offset, dh.views);
        offset = this.addInt(b, offset, dh.vols_added);
        offset = this.addInt(b, offset, dh.start_field);
        offset = this.addInt(b, offset, dh.field_skip);
        offset = this.addInt(b, offset, dh.omax);
        offset = this.addInt(b, offset, dh.omin);
        offset = this.addInt(b, offset, dh.smax);
        if ((offset = this.addInt(b, offset, dh.smin)) != dh.sizeOf) {
            System.out.println("uh-oh");
        }
        return b;
    }

    public void setDataHistoryBytes(byte[] b) {
        int i;
        if (b.length < this.dh.sizeOf) {
            System.out.println("setDataHistoryBytes: wrong #bytes");
            return;
        }
        int offset = 0;
        for (i = 0; i < 80; ++i) {
            this.dh.descrip[i] = b[offset++];
        }
        for (i = 0; i < 24; ++i) {
            this.dh.aux_file[i] = b[offset++];
        }
        this.dh.orient = b[offset++];
        for (i = 0; i < 10; ++i) {
            this.dh.originator[i] = b[offset++];
        }
        for (i = 0; i < 10; ++i) {
            this.dh.generated[i] = b[offset++];
        }
        for (i = 0; i < 10; ++i) {
            this.dh.scannum[i] = b[offset++];
        }
        for (i = 0; i < 10; ++i) {
            this.dh.patient_id[i] = b[offset++];
        }
        for (i = 0; i < 10; ++i) {
            this.dh.exp_date[i] = b[offset++];
        }
        for (i = 0; i < 10; ++i) {
            this.dh.exp_time[i] = b[offset++];
        }
        for (i = 0; i < 3; ++i) {
            this.dh.hist_un0[i] = b[offset++];
        }
        this.dh.views = ByteConverter.getInt(b, offset);
        this.dh.vols_added = ByteConverter.getInt(b, offset += 4);
        this.dh.start_field = ByteConverter.getInt(b, offset += 4);
        this.dh.field_skip = ByteConverter.getInt(b, offset += 4);
        this.dh.omax = ByteConverter.getInt(b, offset += 4);
        this.dh.omin = ByteConverter.getInt(b, offset += 4);
        this.dh.smax = ByteConverter.getInt(b, offset += 4);
        this.dh.smin = ByteConverter.getInt(b, offset += 4);
        if ((offset += 4) != this.dh.sizeOf) {
            System.out.println("setDataHistoryBytes: uh-oh");
        }
    }

    public byte[] getBytes() {
        int i;
        byte[] headerKey = this.getHeaderKeyBytes(this.hk);
        byte[] imageDim = this.getImageDimensionBytes(this.dime);
        byte[] dataHist = this.getDataHistoryBytes(this.dh);
        byte[] total = new byte[headerKey.length + imageDim.length + dataHist.length];
        for (i = 0; i < headerKey.length; ++i) {
            total[i] = headerKey[i];
        }
        for (i = 0; i < imageDim.length; ++i) {
            total[headerKey.length + i] = imageDim[i];
        }
        for (i = 0; i < dataHist.length; ++i) {
            total[headerKey.length + imageDim.length + i] = dataHist[i];
        }
        return total;
    }
}

