/*
 * Decompiled with CFR 0.152.
 */
package org.brainmap.image;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import org.brainmap.image.AnalyzeHeader;
import org.brainmap.util.ByteConverter;
import org.brainmap.util.StringUtilities;

public class AnalyzeIO {
    public static AnalyzeHeader newHeader() {
        AnalyzeHeader hdr = new AnalyzeHeader();
        hdr.hk.sizeof_hdr = 348;
        hdr.hk.extents = 16384;
        hdr.hk.regular = (byte)114;
        hdr.hk.hkey_un0 = 0;
        hdr.dime.dim[0] = 4;
        hdr.dime.dim[4] = 1;
        hdr.fromString(hdr.dime.vox_units, "mm.");
        hdr.fromString(hdr.dime.cal_units, "pixels");
        hdr.dime.pixdim[0] = 4.0f;
        hdr.dime.funused1 = 1.0f;
        hdr.dime.glmax = 1;
        hdr.dime.glmin = 0;
        hdr.dh.orient = (byte)3;
        return hdr;
    }

    public static int writeHeader(String fileName, int xdim, int ydim, int zdim, int talX, int talY, int talZ, float pixDimX, float pixDimY, float pixDimZ, short bitsPerPixel, float max, float min, short datatype) {
        AnalyzeHeader hdr = AnalyzeIO.newHeader();
        hdr.dime.dim[1] = (short)xdim;
        hdr.dime.dim[2] = (short)ydim;
        hdr.dime.dim[3] = (short)zdim;
        hdr.dime.datatype = datatype;
        hdr.dime.bitpix = bitsPerPixel;
        hdr.dime.pixdim[1] = pixDimX;
        hdr.dime.pixdim[2] = pixDimY;
        hdr.dime.pixdim[3] = pixDimZ;
        hdr.dime.cal_max = max;
        hdr.dime.cal_min = min;
        hdr.dh.originator[0] = (byte)talX;
        hdr.dh.originator[2] = (byte)talY;
        hdr.dh.originator[4] = (byte)talZ;
        String root = StringUtilities.getFileRoot(fileName);
        AnalyzeIO.writeHeader(root, hdr);
        return 0;
    }

    public static int writeImage(String path, double[] image) {
        BufferedOutputStream bout;
        ByteConverter c = new ByteConverter();
        try {
            FileOutputStream fout = new FileOutputStream(new File(path));
            bout = new BufferedOutputStream(fout);
        }
        catch (Exception e) {
            System.out.println("WriteToFile: can't open ".concat(String.valueOf(String.valueOf(path))));
            int n = -1;
            return n;
        }
        try {
            for (int i = 0; i < image.length; ++i) {
                byte[] b = ByteConverter.getBytes(image[i]);
                bout.write(b);
            }
            bout.flush();
            bout.close();
        }
        catch (Exception e) {
            System.out.println("WriteToFile: can't write ".concat(String.valueOf(String.valueOf(path))));
            int n = -2;
            return n;
        }
        return -1;
    }

    public static int writeImage(String path, float[] image) {
        BufferedOutputStream bout;
        ByteConverter c = new ByteConverter();
        try {
            FileOutputStream fout = new FileOutputStream(new File(path));
            bout = new BufferedOutputStream(fout);
        }
        catch (Exception e) {
            System.out.println("WriteToFile: can't open ".concat(String.valueOf(String.valueOf(path))));
            int n = -1;
            return n;
        }
        try {
            for (int i = 0; i < image.length; ++i) {
                byte[] b = ByteConverter.getBytes(image[i]);
                bout.write(b);
            }
            bout.flush();
            bout.close();
        }
        catch (Exception e) {
            System.out.println("WriteToFile: can't write ".concat(String.valueOf(String.valueOf(path))));
            int n = -2;
            return n;
        }
        return 0;
    }

    public static int writeImage(String path, int[] image) {
        BufferedOutputStream bout;
        ByteConverter c = new ByteConverter();
        try {
            FileOutputStream fout = new FileOutputStream(new File(path));
            bout = new BufferedOutputStream(fout);
        }
        catch (Exception e) {
            System.out.println("WriteToFile: can't open ".concat(String.valueOf(String.valueOf(path))));
            int n = -1;
            return n;
        }
        try {
            for (int i = 0; i < image.length; ++i) {
                byte[] b = ByteConverter.getBytes(image[i]);
                bout.write(b);
            }
            bout.flush();
            bout.close();
        }
        catch (Exception e) {
            System.out.println("WriteToFile: can't write ".concat(String.valueOf(String.valueOf(path))));
            int n = -2;
            return n;
        }
        return 0;
    }

    public static int writeImage(String path, short[] image) {
        BufferedOutputStream bout;
        ByteConverter c = new ByteConverter();
        try {
            FileOutputStream fout = new FileOutputStream(new File(path));
            bout = new BufferedOutputStream(fout);
        }
        catch (Exception e) {
            System.out.println("WriteToFile: can't open ".concat(String.valueOf(String.valueOf(path))));
            int n = -1;
            return n;
        }
        try {
            for (int i = 0; i < image.length; ++i) {
                byte[] b = ByteConverter.getBytes(image[i]);
                bout.write(b);
            }
            bout.flush();
            bout.close();
        }
        catch (Exception e) {
            System.out.println("WriteToFile: can't write ".concat(String.valueOf(String.valueOf(path))));
            int n = -2;
            return n;
        }
        return 0;
    }

    public static int writeImage(String path, byte[] image) {
        BufferedOutputStream bout;
        try {
            FileOutputStream fout = new FileOutputStream(new File(path));
            bout = new BufferedOutputStream(fout);
        }
        catch (Exception e) {
            System.out.println("WriteToFile: can't open ".concat(String.valueOf(String.valueOf(path))));
            int n = -1;
            return n;
        }
        try {
            bout.write(image);
            bout.flush();
            bout.close();
        }
        catch (Exception e) {
            System.out.println("WriteToFile: can't write ".concat(String.valueOf(String.valueOf(path))));
            int n = -2;
            return n;
        }
        return 0;
    }

    public static int writeImage(String path, float[][][] image) {
        BufferedOutputStream bout;
        ByteConverter c = new ByteConverter();
        try {
            FileOutputStream fout = new FileOutputStream(new File(path));
            bout = new BufferedOutputStream(fout);
        }
        catch (Exception e) {
            System.out.println("WriteToFile: can't open ".concat(String.valueOf(String.valueOf(path))));
            int n = -10;
            return n;
        }
        try {
            int totalBytes = 0;
            for (int z = 0; z < image[0][0].length; ++z) {
                for (int y = 0; y < image[0].length; ++y) {
                    for (int x = 0; x < image.length; ++x) {
                        byte[] b = ByteConverter.getBytes(image[x][y][z]);
                        bout.write(b);
                        totalBytes += b.length;
                    }
                }
            }
            System.out.println(String.valueOf(String.valueOf(totalBytes)).concat(" bytes written"));
            bout.flush();
            bout.close();
        }
        catch (Exception e) {
            System.out.println("WriteToFile: can't write ".concat(String.valueOf(String.valueOf(path))));
            int n = -2;
            return n;
        }
        return 0;
    }

    public static int writeImage(String path, double[][][] image) {
        BufferedOutputStream bout;
        ByteConverter c = new ByteConverter();
        try {
            FileOutputStream fout = new FileOutputStream(new File(path));
            bout = new BufferedOutputStream(fout);
        }
        catch (Exception e) {
            System.out.println("WriteToFile: can't open ".concat(String.valueOf(String.valueOf(path))));
            int n = -10;
            return n;
        }
        try {
            int totalBytes = 0;
            for (int z = 0; z < image[0][0].length; ++z) {
                for (int y = 0; y < image[0].length; ++y) {
                    for (int x = 0; x < image.length; ++x) {
                        byte[] b = ByteConverter.getBytes(image[x][y][z]);
                        bout.write(b);
                        totalBytes += b.length;
                    }
                }
            }
            System.out.println(String.valueOf(String.valueOf(totalBytes)).concat(" bytes written"));
            bout.flush();
            bout.close();
        }
        catch (Exception e) {
            System.out.println("WriteToFile: can't write ".concat(String.valueOf(String.valueOf(path))));
            int n = -2;
            return n;
        }
        return 0;
    }

    public static int writeTempHeader(String file, AnalyzeHeader header) {
        BufferedOutputStream bout;
        try {
            FileOutputStream fout = new FileOutputStream(file);
            bout = new BufferedOutputStream(fout);
        }
        catch (Exception e) {
            System.out.println("WriteToFile: can't open ".concat(String.valueOf(String.valueOf(file))));
            int n = -1;
            return n;
        }
        return AnalyzeIO.writeHeader(bout, header);
    }

    public static int writeHeader(String path, AnalyzeHeader header) {
        BufferedOutputStream bout;
        try {
            FileOutputStream fout = new FileOutputStream(String.valueOf(String.valueOf(path)).concat(".hdr"));
            bout = new BufferedOutputStream(fout);
        }
        catch (Exception e) {
            System.out.println("WriteToFile: can't open ".concat(String.valueOf(String.valueOf(path))));
            int n = -1;
            return n;
        }
        return AnalyzeIO.writeHeader(bout, header);
    }

    private static int writeHeader(BufferedOutputStream bout, AnalyzeHeader header) {
        try {
            byte[] b = header.getHeaderKeyBytes();
            bout.write(b);
            b = header.getImageDimensionBytes();
            bout.write(b);
            b = header.getDataHistoryBytes();
            bout.write(b);
            bout.flush();
            bout.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            int n = -2;
            return n;
        }
        return 0;
    }

    public static AnalyzeHeader readHeader(String path) {
        File f = new File(path);
        if (!f.exists()) {
            return null;
        }
        try {
            AnalyzeHeader head;
            FileInputStream fis = new FileInputStream(path);
            AnalyzeHeader analyzeHeader = head = AnalyzeIO.readHeader(new BufferedInputStream(fis));
            return analyzeHeader;
        }
        catch (Throwable t) {
            System.out.println("readHeader: can't read file ".concat(String.valueOf(String.valueOf(f.getName()))));
            AnalyzeHeader analyzeHeader = null;
            return analyzeHeader;
        }
    }

    public static AnalyzeHeader readHeader(BufferedInputStream bin) {
        if (bin == null) {
            return null;
        }
        try {
            AnalyzeHeader header = new AnalyzeHeader();
            byte[] b = new byte[200];
            bin.read(b, 0, 40);
            header.setHeaderKeyBytes(b);
            bin.read(b, 0, 108);
            header.setImageDimensionBytes(b);
            bin.read(b, 0, 200);
            header.setDataHistoryBytes(b);
            bin.close();
            AnalyzeHeader analyzeHeader = header;
            return analyzeHeader;
        }
        catch (Exception e) {
            e.printStackTrace();
            AnalyzeHeader analyzeHeader = null;
            return analyzeHeader;
        }
    }

    public static short[] readShortImage(BufferedInputStream bin, AnalyzeHeader header) {
        ByteConverter c = new ByteConverter();
        short[] dim = header.dime.dim;
        int numVoxels = dim[1] * dim[2] * dim[3];
        short bits = header.dime.bitpix;
        int bytes = bits / 8;
        float min = header.dime.cal_min;
        short[] image = new short[numVoxels];
        try {
            byte[] barr = new byte[bytes];
            for (int i = 0; i < numVoxels; ++i) {
                bin.read(barr);
                if (bytes == 8) {
                    double d = ByteConverter.getDouble(barr, 0);
                    image[i] = (short)d;
                    continue;
                }
                if (bytes == 4) {
                    int j = ByteConverter.getInt(barr, 0);
                    image[i] = (short)j;
                    continue;
                }
                if (bytes == 2) {
                    short s;
                    image[i] = s = ByteConverter.getShort(barr, 0);
                    continue;
                }
                if (bytes != 1) continue;
                image[i] = barr[0];
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            short[] j = null;
            return j;
        }
        return image;
    }

    public static short[] readShortImage(String path, AnalyzeHeader header) {
        BufferedInputStream bin;
        ByteConverter c = new ByteConverter();
        try {
            FileInputStream fout = new FileInputStream(new File(path));
            bin = new BufferedInputStream(fout);
            bin.available();
        }
        catch (Exception e) {
            System.out.println("ReadToFile: can't open ".concat(String.valueOf(String.valueOf(path))));
            short[] sArray = null;
            return sArray;
        }
        short[] dim = header.dime.dim;
        int numVoxels = dim[1] * dim[2] * dim[3];
        short bits = header.dime.bitpix;
        int bytes = bits / 8;
        float min = header.dime.cal_min;
        File file = new File(path);
        long size = file.length();
        if (size != (long)(numVoxels * bytes)) {
            System.out.println(String.valueOf(String.valueOf(new StringBuffer("image is not of expected size (").append(dim[1]).append(",").append(dim[2]).append(",").append(dim[3]).append(",").append(bytes).append(")"))));
        }
        short[] image = new short[numVoxels];
        try {
            byte[] barr = new byte[bytes];
            for (int i = 0; i < numVoxels; ++i) {
                bin.read(barr);
                if (bytes == 8) {
                    double d = ByteConverter.getDouble(barr, 0);
                    image[i] = (short)d;
                    continue;
                }
                if (bytes == 4) {
                    int j = ByteConverter.getInt(barr, 0);
                    image[i] = (short)j;
                    continue;
                }
                if (bytes == 2) {
                    short s;
                    image[i] = s = ByteConverter.getShort(barr, 0);
                    continue;
                }
                if (bytes != 1) continue;
                image[i] = barr[0];
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            short[] j = null;
            return j;
        }
        return image;
    }

    public static int[] readIntImage(String path, AnalyzeHeader header) {
        BufferedInputStream bin;
        ByteConverter c = new ByteConverter();
        try {
            FileInputStream fout = new FileInputStream(new File(path));
            bin = new BufferedInputStream(fout);
            bin.available();
        }
        catch (Exception e) {
            System.out.println("ReadToFile: can't open ".concat(String.valueOf(String.valueOf(path))));
            int[] nArray = null;
            return nArray;
        }
        short[] dim = header.dime.dim;
        int numVoxels = dim[1] * dim[2] * dim[3];
        short bits = header.dime.bitpix;
        int bytes = bits / 8;
        float min = header.dime.cal_min;
        File file = new File(path);
        long size = file.length();
        if (size != (long)(numVoxels * bytes)) {
            System.out.println(String.valueOf(String.valueOf(new StringBuffer("dimensions: (").append(dim[1]).append(",").append(dim[2]).append(",").append(dim[3]).append(",").append(bytes).append(")"))));
            System.out.println("expected size: ".concat(String.valueOf(String.valueOf(numVoxels * bytes))));
            System.out.println("actual size:   ".concat(String.valueOf(String.valueOf(size))));
        }
        int[] image = new int[numVoxels];
        try {
            byte[] barr = new byte[bytes];
            for (int i = 0; i < numVoxels; ++i) {
                bin.read(barr);
                if (bytes == 8) {
                    double d = ByteConverter.getDouble(barr, 0);
                    image[i] = (int)d;
                    continue;
                }
                if (bytes == 4) {
                    int j;
                    image[i] = j = ByteConverter.getInt(barr, 0);
                    continue;
                }
                if (bytes == 2) {
                    short s = ByteConverter.getShort(barr, 0);
                    image[i] = s;
                    continue;
                }
                if (bytes != 1) continue;
                image[i] = barr[0];
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            int[] j = null;
            return j;
        }
        return image;
    }

    public static float[] readImage(String path, AnalyzeHeader header) {
        BufferedInputStream bin;
        ByteConverter c = new ByteConverter();
        try {
            FileInputStream fout = new FileInputStream(new File(path));
            bin = new BufferedInputStream(fout);
            bin.available();
        }
        catch (Exception e) {
            System.out.println("ReadToFile: can't open ".concat(String.valueOf(String.valueOf(path))));
            float[] fArray = null;
            return fArray;
        }
        short[] dim = header.dime.dim;
        int numVoxels = dim[1] * dim[2] * dim[3];
        short bits = header.dime.bitpix;
        int bytes = bits / 8;
        float min = header.dime.cal_min;
        File file = new File(path);
        long size = file.length();
        if (size != (long)(numVoxels * bytes)) {
            System.out.println(String.valueOf(String.valueOf(new StringBuffer("dimensions: (").append(dim[1]).append(",").append(dim[2]).append(",").append(dim[3]).append(",").append(bytes).append(")"))));
            System.out.println("expected size: ".concat(String.valueOf(String.valueOf(numVoxels * bytes))));
            System.out.println("actual size:   ".concat(String.valueOf(String.valueOf(size))));
        }
        float[] image = new float[numVoxels];
        try {
            byte[] barr = new byte[bytes];
            for (int i = 0; i < numVoxels; ++i) {
                bin.read(barr);
                if (bytes == 8) {
                    double d = ByteConverter.getDouble(barr, 0);
                    image[i] = (float)d;
                    continue;
                }
                if (bytes == 4) {
                    float f;
                    image[i] = f = ByteConverter.getFloat(barr, 0);
                    continue;
                }
                if (bytes == 2) {
                    short s = ByteConverter.getShort(barr, 0);
                    image[i] = s;
                    continue;
                }
                if (bytes != 1) continue;
                image[i] = barr[0];
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            float[] f = null;
            return f;
        }
        return image;
    }

    public static boolean[] readMask(BufferedInputStream bin, AnalyzeHeader header) {
        ByteConverter c = new ByteConverter();
        if (bin == null || header == null) {
            return null;
        }
        short[] dim = header.getDimensions();
        int numVoxels = dim[1] * dim[2] * dim[3];
        int bytes = header.dime.bitpix / 8;
        boolean[] mask = new boolean[numVoxels];
        byte[] b = new byte[bytes];
        try {
            for (int i = 0; i < numVoxels; ++i) {
                bin.read(b);
                if (bytes == 8) {
                    double d = ByteConverter.getDouble(b, 0);
                    mask[i] = d != 0.0;
                    continue;
                }
                if (bytes == 4) {
                    float f = ByteConverter.getFloat(b, 0);
                    mask[i] = f != 0.0f;
                    continue;
                }
                if (bytes == 2) {
                    short s = ByteConverter.getShort(b, 0);
                    mask[i] = s != 0;
                    continue;
                }
                if (bytes != 1) continue;
                mask[i] = b[0] != 0;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            boolean[] blArray = null;
            return blArray;
        }
        return mask;
    }
}

