/*
 * Decompiled with CFR 0.152.
 */
package org.brainmap.image;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.PrintStream;
import org.brainmap.image.AnalyzeHeader;
import org.brainmap.image.ImageHeader;
import org.brainmap.util.ByteConverter;
import org.brainmap.util.MatrixTools;
import org.brainmap.util.OpenResource;

public class NiftiHeader
extends ImageHeader {
    public static final byte NIFTI_UNITS_UNKNOWN = 0;
    public static final byte NIFTI_UNITS_METER = 1;
    public static final byte NIFTI_UNITS_MM = 2;
    public static final byte NIFTI_UNITS_MICRON = 3;
    public static final byte NIFTI_UNITS_SEC = 8;
    public static final byte NIFTI_UNITS_MSEC = 16;
    public static final byte NIFTI_UNITS_USEC = 24;
    public static final byte NIFTI_UNITS_HZ = 32;
    public static final byte NIFTI_UNITS_PPM = 40;
    public static final byte NIFTI_UNITS_RADS = 48;
    public static final byte NIFTI_XFORM_UNKNOWN = 0;
    public static final byte NIFTI_XFORM_SCANNER_ANAT = 1;
    public static final byte NIFTI_XFORM_ALIGNED_ANAT = 2;
    public static final byte NIFTI_XFORM_TALAIRACH = 3;
    public static final byte NIFTI_XFORM_MNI_152 = 4;
    private int sizeof_hdr = 348;
    private byte[] data_type = new byte[10];
    private byte[] db_name = new byte[18];
    private int extents = 0;
    private short session_error = 0;
    private byte regular = 0;
    private byte dim_info = 0;
    private short[] dim = new short[8];
    private float intent_p1;
    private float intent_p2;
    private float intent_p3;
    private short intent_code;
    private short datatype;
    private short bitpix;
    private short slice_start;
    private float[] pixdim = new float[8];
    private float vox_offset;
    private float scl_slope;
    private float scl_inter;
    private short slice_end;
    private byte slice_code;
    private byte xyzt_units;
    private float cal_max;
    private float cal_min;
    private float slice_duration;
    private float toffset;
    private int glmax;
    private int glmin;
    private byte[] descrip = new byte[80];
    private byte[] aux_file = new byte[24];
    private short qform_code;
    private short sform_code;
    private float quatern_b;
    private float quatern_c;
    private float quatern_d;
    private float qoffset_x;
    private float qoffset_y;
    private float qoffset_z;
    private float[] srow_x = new float[4];
    private float[] srow_y = new float[4];
    private float[] srow_z = new float[4];
    private byte[] intent_name = new byte[16];
    private byte[] magic = new byte[4];
    private float[][] qform = null;
    private float[] min;
    private float[] max;

    public NiftiHeader() {
        this.setDefaultValues();
    }

    public NiftiHeader(NiftiHeader hdr) {
        this();
        this.setBytes(hdr.getBytes());
    }

    public NiftiHeader(AnalyzeHeader hdr) {
        this();
        this.copy(hdr);
    }

    public void setDefaultValues() {
        this.sizeof_hdr = 348;
        this.datatype = 0;
        this.bitpix = 0;
        this.dim[0] = 3;
        this.dim[1] = 81;
        this.dim[2] = 96;
        this.dim[3] = 75;
        this.dim[4] = 1;
        this.dim[5] = 1;
        this.dim[6] = 1;
        this.dim[7] = 1;
        this.pixdim[0] = 1.0f;
        this.pixdim[1] = 2.0f;
        this.pixdim[2] = 2.0f;
        this.pixdim[3] = 2.0f;
        this.pixdim[4] = 0.0f;
        this.pixdim[5] = 0.0f;
        this.pixdim[6] = 0.0f;
        this.pixdim[7] = 0.0f;
        this.xyzt_units = (byte)2;
        this.intent_p1 = 0.0f;
        this.intent_p2 = 0.0f;
        this.intent_p3 = 0.0f;
        this.intent_code = 0;
        this.setOneFile(true);
        this.scl_slope = 0.0f;
        this.scl_inter = 0.0f;
        this.cal_min = 0.0f;
        this.cal_max = 0.0f;
        this.setRotationalOffset(-80.0f, -110.0f, -64.0f);
        this.setAffineOffset(-80.0f, -110.0f, -64.0f);
        this.dim_info = 0;
        this.slice_start = 0;
        this.slice_end = 0;
        this.slice_code = 0;
        this.slice_duration = 0.0f;
        this.toffset = 0.0f;
        this.session_error = 0;
        this.extents = 16384;
        this.regular = (byte)114;
        this.glmax = 0;
        this.glmin = 0;
    }

    public void copy(AnalyzeHeader hdr) {
        this.setVoxelSizes(hdr.getVoxelSizes());
        this.setDimensions(hdr.getDimensions());
        this.setMinMax(hdr.getMin(), hdr.getMax());
        this.setDataType(hdr.getType());
        this.setDescription(hdr.getDescription());
        this.setRotationalOffset(-128.0f, -146.0f, -62.0f);
        this.setAffineOffset(-128.0f, -146.0f, -62.0f);
    }

    public void out(PrintStream out) {
        out.println("sizeof_hdr=".concat(String.valueOf(String.valueOf(this.sizeof_hdr))));
        String type = "none";
        if (this.datatype == 1) {
            type = "binary";
        }
        if (this.datatype == 2) {
            type = "byte";
        }
        if (this.datatype == 4) {
            type = "short";
        }
        if (this.datatype == 16) {
            type = "float";
        }
        if (this.datatype == 8) {
            type = "integer";
        }
        if (this.datatype == 64) {
            type = "double";
        }
        out.println(String.valueOf(String.valueOf(new StringBuffer("datatype=").append(this.datatype).append(" (").append(type).append(")"))));
        out.println("bitpix=".concat(String.valueOf(String.valueOf(this.bitpix))));
        out.println(String.valueOf(String.valueOf(new StringBuffer("dim=[ ").append(this.toString(this.dim)).append("]"))));
        out.println(String.valueOf(String.valueOf(new StringBuffer("pixdim=[ ").append(this.toString(this.pixdim)).append("]"))));
        String units = "";
        if (this.xyzt_units / 8 == 32) {
            units = String.valueOf(String.valueOf(units)).concat("hz ");
        }
        if ((this.xyzt_units & 8) == 1) {
            units = String.valueOf(String.valueOf(units)).concat("meter ");
        }
        if ((this.xyzt_units & 8) == 3) {
            units = String.valueOf(String.valueOf(units)).concat("micron ");
        }
        if ((this.xyzt_units & 8) == 2) {
            units = String.valueOf(String.valueOf(units)).concat("mm ");
        }
        if (this.xyzt_units / 8 == 16) {
            units = String.valueOf(String.valueOf(units)).concat("msec ");
        }
        if (this.xyzt_units / 8 == 40) {
            units = String.valueOf(String.valueOf(units)).concat("ppm ");
        }
        if (this.xyzt_units / 8 == 48) {
            units = String.valueOf(String.valueOf(units)).concat("rads ");
        }
        if (this.xyzt_units / 8 == 8) {
            units = String.valueOf(String.valueOf(units)).concat("sec ");
        }
        if (this.xyzt_units == 0) {
            units = String.valueOf(String.valueOf(units)).concat("unknown ");
        }
        if (this.xyzt_units / 8 == 24) {
            units = String.valueOf(String.valueOf(units)).concat("usec ");
        }
        out.println(String.valueOf(String.valueOf(new StringBuffer("xyzt_units=").append(this.xyzt_units).append(" ( ").append(units).append(")"))));
        out.println("intent_p1=".concat(String.valueOf(String.valueOf(this.intent_p1))));
        out.println("intent_p2=".concat(String.valueOf(String.valueOf(this.intent_p2))));
        out.println("intent_p3=".concat(String.valueOf(String.valueOf(this.intent_p3))));
        out.println("intent_code=".concat(String.valueOf(String.valueOf(this.intent_code))));
        out.println("scl_slope=".concat(String.valueOf(String.valueOf(this.scl_slope))));
        out.println("scl_inter=".concat(String.valueOf(String.valueOf(this.scl_inter))));
        out.println("cal_max=".concat(String.valueOf(String.valueOf(this.cal_max))));
        out.println("cal_min=".concat(String.valueOf(String.valueOf(this.cal_min))));
        out.println("glmax=".concat(String.valueOf(String.valueOf(this.glmax))));
        out.println("glmin=".concat(String.valueOf(String.valueOf(this.glmin))));
        String xform = "?";
        if (this.qform_code == 0) {
            xform = "Unknown";
        }
        if (this.qform_code == 1) {
            xform = "Scanner-based anatomical";
        }
        if (this.qform_code == 2) {
            xform = "Aligned anatomical";
        }
        if (this.qform_code == 3) {
            xform = "Talairach";
        }
        if (this.qform_code == 4) {
            xform = "MNI 152";
        }
        out.println(String.valueOf(String.valueOf(new StringBuffer("qform_code=").append(this.qform_code).append(" (").append(xform).append(")"))));
        out.println("quatern_b=".concat(String.valueOf(String.valueOf(this.quatern_b))));
        out.println("quatern_c=".concat(String.valueOf(String.valueOf(this.quatern_c))));
        out.println("quatern_d=".concat(String.valueOf(String.valueOf(this.quatern_d))));
        out.println("qoffset_x=".concat(String.valueOf(String.valueOf(this.qoffset_x))));
        out.println("qoffset_y=".concat(String.valueOf(String.valueOf(this.qoffset_y))));
        out.println("qoffset_z=".concat(String.valueOf(String.valueOf(this.qoffset_z))));
        if (this.qform == null) {
            this.setQForm();
        }
        System.out.println("qform matrix:");
        MatrixTools.print(this.qform);
        xform = "?";
        if (this.sform_code == 0) {
            xform = "Unknown";
        }
        if (this.sform_code == 1) {
            xform = "Scanner-based anatomical";
        }
        if (this.sform_code == 2) {
            xform = "Aligned anatomical";
        }
        if (this.sform_code == 3) {
            xform = "Talairach";
        }
        if (this.sform_code == 4) {
            xform = "MNI 152";
        }
        out.println(String.valueOf(String.valueOf(new StringBuffer("sform_code=").append(this.sform_code).append(" (").append(xform).append(")"))));
        out.println("srow_x=".concat(String.valueOf(String.valueOf(this.toString(this.srow_x)))));
        out.println("srow_y=".concat(String.valueOf(String.valueOf(this.toString(this.srow_y)))));
        out.println("srow_z=".concat(String.valueOf(String.valueOf(this.toString(this.srow_z)))));
        out.println("dim_info=".concat(String.valueOf(String.valueOf(this.dim_info))));
        out.println("slice_start=".concat(String.valueOf(String.valueOf(this.slice_start))));
        out.println("slice_end=".concat(String.valueOf(String.valueOf(this.slice_end))));
        out.println("slice_code=".concat(String.valueOf(String.valueOf(this.slice_code))));
        out.println("slice_duration=".concat(String.valueOf(String.valueOf(this.slice_duration))));
        out.println("toffset=".concat(String.valueOf(String.valueOf(this.toffset))));
        out.println(String.valueOf(String.valueOf(new StringBuffer("intent_name=\"").append(this.toString(this.intent_name)).append("\""))));
        out.println(String.valueOf(String.valueOf(new StringBuffer("aux_file=\"").append(this.toString(this.aux_file)).append("\""))));
        out.println(String.valueOf(String.valueOf(new StringBuffer("descrip=\"").append(this.toString(this.descrip)).append("\""))));
        out.println(String.valueOf(String.valueOf(new StringBuffer("data_type=\"").append(this.toString(this.data_type)).append("\""))));
        out.println(String.valueOf(String.valueOf(new StringBuffer("db_name=\"").append(this.toString(this.db_name)).append("\""))));
        out.println("session_error=".concat(String.valueOf(String.valueOf(this.session_error))));
        out.println("extents=".concat(String.valueOf(String.valueOf(this.extents))));
        out.println("regular=".concat(String.valueOf(String.valueOf((char)this.regular))));
        out.println("vox_offset=".concat(String.valueOf(String.valueOf(this.vox_offset))));
        out.println(String.valueOf(String.valueOf(new StringBuffer("magic=\"").append(this.toString(this.magic)).append("\""))));
    }

    public float[] getXYZ(int index) {
        boolean verbose = false;
        int i = index % this.dim[1];
        int j = index / this.dim[1] % this.dim[2];
        int k = index / (this.dim[1] * this.dim[2]);
        if (i < 0 || i > this.dim[1] || j < 0 || j > this.dim[2] || k < 0 || k > this.dim[3]) {
            System.out.println("outside the bounds of the image");
        }
        float[] xyz = new float[3];
        if (this.qform_code > 0) {
            if (this.qform == null) {
                this.setQForm();
            }
            float[][] ijk = new float[3][1];
            ijk[0][0] = (float)i * this.pixdim[1];
            ijk[1][0] = (float)j * this.pixdim[2];
            ijk[2][0] = (float)k * this.pixdim[3] * this.pixdim[0];
            if (verbose) {
                System.out.println("qform matrix");
                MatrixTools.print(this.qform);
                System.out.println();
                System.out.println("ijk");
                MatrixTools.print(ijk);
                System.out.println();
                System.out.println("xyz");
            }
            float[][] result = MatrixTools.multiply(this.qform, ijk);
            float[] fArray = result[0];
            fArray[0] = fArray[0] + this.qoffset_x;
            float[] fArray2 = result[1];
            fArray2[0] = fArray2[0] + this.qoffset_y;
            float[] fArray3 = result[2];
            fArray3[0] = fArray3[0] + this.qoffset_z;
            if (verbose) {
                MatrixTools.print(result);
            }
            xyz[0] = result[0][0];
            xyz[1] = result[1][0];
            xyz[2] = result[2][0];
        } else if (this.sform_code > 0) {
            xyz[0] = this.srow_x[0] * (float)i + this.srow_x[1] * (float)j + this.srow_x[2] * (float)k + this.srow_x[3];
            xyz[1] = this.srow_y[0] * (float)i + this.srow_y[1] * (float)j + this.srow_y[2] * (float)k + this.srow_y[3];
            xyz[2] = this.srow_z[0] * (float)i + this.srow_z[1] * (float)j + this.srow_z[2] * (float)k + this.srow_z[3];
        } else {
            xyz[0] = (float)i * this.pixdim[1];
            xyz[1] = (float)j * this.pixdim[2];
            xyz[2] = (float)k * this.pixdim[3];
        }
        return xyz;
    }

    public int getIndex(float[] xyz) {
        return this.getIndex(xyz[0], xyz[1], xyz[2]);
    }

    public int getIndex(float x, float y, float z) {
        float[][] ijk = new float[3][1];
        if (this.qform_code > 0) {
            ijk[0][0] = (x - this.qoffset_x) / this.pixdim[1];
            ijk[1][0] = (y - this.qoffset_y) / this.pixdim[2];
            ijk[2][0] = (z - this.qoffset_z) / (this.pixdim[3] * this.pixdim[0]);
            if (this.qform == null) {
                this.setQForm();
            }
            float[][] inverse = MatrixTools.inverse(this.qform);
            ijk = MatrixTools.multiply(inverse, ijk);
        } else if (this.sform_code <= 0) {
            ijk[0][0] = x / this.pixdim[1];
            ijk[1][0] = y / this.pixdim[2];
            ijk[2][0] = z / this.pixdim[3];
        }
        int index = Math.round(ijk[2][0]) * (this.dim[1] * this.dim[2]);
        index += Math.round(ijk[1][0]) * this.dim[1];
        return index += Math.round(ijk[0][0]);
    }

    public void setQForm() {
        float b = this.quatern_b;
        float c = this.quatern_c;
        float d = this.quatern_d;
        float a = 1.0f - b * b - c * c - d * d;
        this.qform = new float[3][3];
        this.qform[0][0] = a * a + b * b - c * c - d * d;
        this.qform[0][1] = (float)2 * b * c - (float)2 * a * d;
        this.qform[0][2] = (float)2 * b * d + (float)2 * a * c;
        this.qform[1][0] = (float)2 * b * c + (float)2 * a * d;
        this.qform[1][1] = a * a + c * c - b * b - d * d;
        this.qform[1][2] = (float)2 * c * d + (float)2 * a * b;
        this.qform[2][0] = (float)2 * b * d - (float)2 * a * c;
        this.qform[2][1] = (float)2 * c * d + (float)2 * a * b;
        this.qform[2][2] = a * a + d * d - c * c - b * b;
    }

    public void setMinMax() {
        this.min = new float[3];
        this.max = new float[3];
        int size = this.dim[1] * this.dim[2] * this.dim[3];
        float[] first = this.getXYZ(0);
        float[] last = this.getXYZ(size - 1);
        this.min[0] = Math.min(first[0], last[0]);
        this.min[1] = Math.min(first[1], last[1]);
        this.min[2] = Math.min(first[2], last[2]);
        this.max[0] = Math.max(first[0], last[0]);
        this.max[1] = Math.max(first[1], last[1]);
        this.max[2] = Math.max(first[2], last[2]);
    }

    public float[] getMinXYZ() {
        if (this.min == null) {
            this.setMinMax();
        }
        return this.min;
    }

    public float[] getMaxXYZ() {
        if (this.max == null) {
            this.setMinMax();
        }
        return this.max;
    }

    public boolean isInsideBounds(float x, float y, float z) {
        if (x < this.min[0] || x > this.max[0]) {
            return false;
        }
        if (y < this.min[1] || y > this.max[1]) {
            return false;
        }
        return !(z < this.min[2]) && !(z > this.max[2]);
    }

    public boolean isOutsideBounds(float x, float y, float z) {
        if (x < this.min[0] || x > this.max[0]) {
            return true;
        }
        if (y < this.min[1] || y > this.max[1]) {
            return true;
        }
        return z < this.min[2] || z > this.max[2];
    }

    public void setRotationalOffset(float x, float y, float z) {
        this.qform_code = (short)3;
        this.quatern_b = 0.0f;
        this.quatern_c = 0.0f;
        this.quatern_d = 0.0f;
        this.pixdim[0] = 1.0f;
        this.qoffset_x = x;
        this.qoffset_y = y;
        this.qoffset_z = z;
    }

    public void setRotationalOrientation(short code, float qfac, float[] quat, float[] qoff) {
        if (quat == null || qoff == null) {
            return;
        }
        if (quat.length < 3 || qoff.length < 3) {
            return;
        }
        this.qform_code = code;
        this.pixdim[0] = qfac;
        this.quatern_b = quat[0];
        this.quatern_c = quat[1];
        this.quatern_d = quat[2];
        this.qoffset_x = qoff[0];
        this.qoffset_y = qoff[1];
        this.qoffset_z = qoff[2];
    }

    public void clearRotationalOrienation() {
        this.qform_code = 0;
        this.pixdim[0] = 0.0f;
        this.quatern_b = 0.0f;
        this.quatern_c = 0.0f;
        this.quatern_d = 0.0f;
        this.qoffset_x = 0.0f;
        this.qoffset_y = 0.0f;
        this.qoffset_z = 0.0f;
    }

    public void setAffineOffset(float x, float y, float z) {
        this.sform_code = (short)3;
        this.srow_x[0] = this.pixdim[1];
        this.srow_x[1] = 0.0f;
        this.srow_x[2] = 0.0f;
        this.srow_x[3] = x;
        this.srow_y[0] = 0.0f;
        this.srow_y[1] = this.pixdim[2];
        this.srow_y[2] = 0.0f;
        this.srow_y[3] = y;
        this.srow_z[0] = 0.0f;
        this.srow_z[1] = 0.0f;
        this.srow_z[2] = this.pixdim[3];
        this.srow_z[3] = z;
    }

    public void setAffineOrientation(short[] s1, short[] s2, short[] s3) {
        if (s1 == null || s2 == null || s3 == null) {
            return;
        }
        if (s1.length < 4 || s2.length < 4 || s3.length < 4) {
            return;
        }
        this.sform_code = 1;
        this.srow_x[0] = s1[0];
        this.srow_x[1] = s1[1];
        this.srow_x[2] = s1[2];
        this.srow_x[3] = s1[3];
        this.srow_y[0] = s2[0];
        this.srow_y[1] = s2[1];
        this.srow_y[2] = s2[2];
        this.srow_y[3] = s2[3];
        this.srow_z[0] = s3[0];
        this.srow_z[1] = s3[1];
        this.srow_z[2] = s3[2];
        this.srow_z[3] = s3[3];
    }

    public void clearAffineOrientation() {
        this.sform_code = 0;
        this.srow_x[0] = 0.0f;
        this.srow_x[1] = 0.0f;
        this.srow_x[2] = 0.0f;
        this.srow_x[3] = 0.0f;
        this.srow_y[0] = 0.0f;
        this.srow_y[1] = 0.0f;
        this.srow_y[2] = 0.0f;
        this.srow_y[3] = 0.0f;
        this.srow_z[0] = 0.0f;
        this.srow_z[1] = 0.0f;
        this.srow_z[2] = 0.0f;
        this.srow_z[3] = 0.0f;
    }

    public void setType(short dt) {
        this.setDataType(dt);
    }

    public void setDataType(short dt) {
        this.datatype = dt;
        if (dt == 1) {
            this.bitpix = 1;
        } else if (dt == 2) {
            this.bitpix = (short)8;
        } else if (dt == 4) {
            this.bitpix = (short)16;
        } else if (dt == 16) {
            this.bitpix = (short)32;
        } else if (dt == 8) {
            this.bitpix = (short)32;
        } else if (dt == 64) {
            this.bitpix = (short)64;
        } else {
            System.out.println("problem setting data type");
        }
    }

    public boolean isBinaryImage() {
        return this.datatype == 1;
    }

    public boolean isByteImage() {
        return this.datatype == 2;
    }

    public boolean isShortImage() {
        return this.datatype == 4;
    }

    public boolean isFloatImage() {
        return this.datatype == 16;
    }

    public boolean isIntegerImage() {
        return this.datatype == 8;
    }

    public boolean isDoubleImage() {
        return this.datatype == 64;
    }

    public short getDataType() {
        return this.datatype;
    }

    public short getBits() {
        return this.bitpix;
    }

    public float[] getVoxelSizes() {
        return this.pixdim;
    }

    public float getVoxelSize() {
        if (this.pixdim[1] != this.pixdim[2] || this.pixdim[2] != this.pixdim[3]) {
            return -1.0f;
        }
        return this.pixdim[1];
    }

    public void setVoxelSizes(float[] vdim) {
        for (int i = 0; i < this.pixdim.length && i < vdim.length; ++i) {
            this.pixdim[i] = vdim[i];
        }
    }

    public short[] getDimensions() {
        return this.dim;
    }

    public void setDimensions(short[] dimensions) {
        for (int i = 0; i < this.dim.length && i < dimensions.length; ++i) {
            this.dim[i] = dimensions[i];
        }
    }

    public void setDimensions(int x, int y, int z, float voxelSize) {
        this.dim[0] = 3;
        this.dim[1] = (short)x;
        this.dim[2] = (short)y;
        this.dim[3] = (short)z;
        this.pixdim[1] = voxelSize;
        this.pixdim[2] = voxelSize;
        this.pixdim[3] = voxelSize;
        for (int i = 4; i < 8; ++i) {
            this.dim[i] = 1;
            this.pixdim[i] = 0.0f;
        }
    }

    public float getMax() {
        return this.cal_max;
    }

    public float getMin() {
        return this.cal_min;
    }

    public void setMinMax(float min, float max) {
        this.cal_max = max;
        this.cal_min = min;
        this.glmax = (int)Math.ceil(max);
        this.glmin = (int)Math.floor(min);
    }

    public void setOffset(int off) {
        this.vox_offset = off;
    }

    public int getOffset() {
        return Math.round(this.vox_offset);
    }

    public void setOneFile(boolean b) {
        this.magic[0] = 110;
        this.magic[2] = 49;
        this.magic[3] = 0;
        if (b) {
            this.magic[1] = 43;
            this.vox_offset = 352.0f;
        } else {
            this.magic[1] = 105;
            this.vox_offset = 0.0f;
        }
    }

    public boolean isOneFile() {
        return this.magic[1] == 43;
    }

    public int niftiVersion() {
        char c = (char)this.magic[2];
        return Integer.parseInt("".concat(String.valueOf(String.valueOf(c))));
    }

    public boolean niftiNeedsSwap() {
        return this.dim[0] < 0 || this.dim[0] > 7;
    }

    public String getDescription() {
        byte b;
        String s = "";
        for (int i = 0; i < this.descrip.length && (b = this.descrip[i]) != 0; ++i) {
            s = String.valueOf(String.valueOf(s)).concat(String.valueOf(String.valueOf((char)b)));
        }
        return s;
    }

    public void setDescription(String s) {
        this.fromString(this.descrip, s);
    }

    public byte[] getBytes() {
        return NiftiHeader.getBytes(this);
    }

    public static byte[] getBytes(NiftiHeader n) {
        int i;
        byte[] b = new byte[n.sizeof_hdr];
        int offset = 0;
        offset = n.addInt(b, offset, n.sizeof_hdr);
        offset = n.addByteArr(b, offset, n.data_type);
        offset = n.addByteArr(b, offset, n.db_name);
        offset = n.addInt(b, offset, n.extents);
        offset = n.addShort(b, offset, n.session_error);
        b[offset++] = n.regular;
        b[offset++] = n.dim_info;
        offset = n.addShortArr(b, offset, n.dim);
        offset = n.addFloat(b, offset, n.intent_p1);
        offset = n.addFloat(b, offset, n.intent_p2);
        offset = n.addFloat(b, offset, n.intent_p3);
        offset = n.addShort(b, offset, n.intent_code);
        offset = n.addShort(b, offset, n.datatype);
        offset = n.addShort(b, offset, n.bitpix);
        offset = n.addShort(b, offset, n.slice_start);
        offset = n.addFloatArr(b, offset, n.pixdim);
        offset = n.addFloat(b, offset, n.vox_offset);
        offset = n.addFloat(b, offset, n.scl_slope);
        offset = n.addFloat(b, offset, n.scl_inter);
        offset = n.addShort(b, offset, n.slice_end);
        b[offset++] = n.slice_code;
        b[offset++] = n.xyzt_units;
        offset = n.addFloat(b, offset, n.cal_max);
        offset = n.addFloat(b, offset, n.cal_min);
        offset = n.addFloat(b, offset, n.slice_duration);
        offset = n.addFloat(b, offset, n.toffset);
        offset = n.addInt(b, offset, n.glmax);
        offset = n.addInt(b, offset, n.glmin);
        for (i = 0; i < n.descrip.length; ++i) {
            b[offset++] = n.descrip[i];
        }
        for (i = 0; i < n.aux_file.length; ++i) {
            b[offset++] = n.aux_file[i];
        }
        offset = n.addShort(b, offset, n.qform_code);
        offset = n.addShort(b, offset, n.sform_code);
        offset = n.addFloat(b, offset, n.quatern_b);
        offset = n.addFloat(b, offset, n.quatern_c);
        offset = n.addFloat(b, offset, n.quatern_d);
        offset = n.addFloat(b, offset, n.qoffset_x);
        offset = n.addFloat(b, offset, n.qoffset_y);
        offset = n.addFloat(b, offset, n.qoffset_z);
        offset = n.addFloatArr(b, offset, n.srow_x);
        offset = n.addFloatArr(b, offset, n.srow_y);
        offset = n.addFloatArr(b, offset, n.srow_z);
        for (i = 0; i < n.intent_name.length; ++i) {
            b[offset++] = n.intent_name[i];
        }
        for (i = 0; i < n.magic.length; ++i) {
            b[offset++] = n.magic[i];
        }
        if (offset != b.length) {
            return null;
        }
        return b;
    }

    public void setBytes(byte[] b) {
        int i;
        if (b.length != this.sizeof_hdr) {
            System.out.println("setHeaderKeyBytes: wrong #bytes");
            return;
        }
        int offset = 0;
        this.sizeof_hdr = ByteConverter.getInt(b, offset);
        offset += 4;
        for (i = 0; i < 10; ++i) {
            this.data_type[i] = b[offset++];
        }
        for (i = 0; i < 18; ++i) {
            this.db_name[i] = b[offset++];
        }
        this.extents = ByteConverter.getInt(b, offset);
        this.session_error = ByteConverter.getShort(b, offset += 4);
        offset += 2;
        this.regular = b[offset++];
        this.dim_info = b[offset++];
        for (i = 0; i < 8; ++i) {
            this.dim[i] = ByteConverter.getShort(b, offset);
            offset += 2;
        }
        this.intent_p1 = ByteConverter.getFloat(b, offset);
        this.intent_p2 = ByteConverter.getFloat(b, offset += 4);
        this.intent_p3 = ByteConverter.getFloat(b, offset += 4);
        this.intent_code = ByteConverter.getShort(b, offset += 4);
        this.datatype = ByteConverter.getShort(b, offset += 2);
        this.bitpix = ByteConverter.getShort(b, offset += 2);
        this.slice_start = ByteConverter.getShort(b, offset += 2);
        offset += 2;
        for (i = 0; i < 8; ++i) {
            this.pixdim[i] = ByteConverter.getFloat(b, offset);
            offset += 4;
        }
        this.vox_offset = ByteConverter.getFloat(b, offset);
        this.scl_slope = ByteConverter.getFloat(b, offset += 4);
        this.scl_inter = ByteConverter.getFloat(b, offset += 4);
        this.slice_end = ByteConverter.getShort(b, offset += 4);
        offset += 2;
        this.slice_code = b[offset++];
        this.xyzt_units = b[offset++];
        this.cal_max = ByteConverter.getFloat(b, offset);
        this.cal_min = ByteConverter.getFloat(b, offset += 4);
        this.slice_duration = ByteConverter.getFloat(b, offset += 4);
        this.toffset = ByteConverter.getFloat(b, offset += 4);
        this.glmax = ByteConverter.getInt(b, offset += 4);
        this.glmin = ByteConverter.getInt(b, offset += 4);
        offset += 4;
        for (i = 0; i < this.descrip.length; ++i) {
            this.descrip[i] = b[offset++];
        }
        for (i = 0; i < this.aux_file.length; ++i) {
            this.aux_file[i] = b[offset++];
        }
        this.qform_code = ByteConverter.getShort(b, offset);
        this.sform_code = ByteConverter.getShort(b, offset += 2);
        this.quatern_b = ByteConverter.getFloat(b, offset += 2);
        this.quatern_c = ByteConverter.getFloat(b, offset += 4);
        this.quatern_d = ByteConverter.getFloat(b, offset += 4);
        this.qoffset_x = ByteConverter.getFloat(b, offset += 4);
        this.qoffset_y = ByteConverter.getFloat(b, offset += 4);
        this.qoffset_z = ByteConverter.getFloat(b, offset += 4);
        offset += 4;
        for (i = 0; i < this.srow_x.length; ++i) {
            this.srow_x[i] = ByteConverter.getFloat(b, offset);
            offset += 4;
        }
        for (i = 0; i < this.srow_y.length; ++i) {
            this.srow_y[i] = ByteConverter.getFloat(b, offset);
            offset += 4;
        }
        for (i = 0; i < this.srow_z.length; ++i) {
            this.srow_z[i] = ByteConverter.getFloat(b, offset);
            offset += 4;
        }
        for (i = 0; i < this.intent_name.length; ++i) {
            this.intent_name[i] = b[offset++];
        }
        for (i = 0; i < this.magic.length; ++i) {
            this.magic[i] = b[offset++];
        }
        if (offset != this.sizeof_hdr) {
            System.out.println("setDataHistoryBytes: uh-oh");
        }
    }

    public int saveNii(String path, float[] image) {
        int size = this.getOffset() - 348;
        if (size <= 0) {
            size = 4;
        }
        return this.saveNii(path, image, new byte[size]);
    }

    public int saveNii(String path, float[] image, byte[] extensions) {
        String fullPath = path;
        int offset = this.getOffset();
        if (offset != 348 + extensions.length) {
            offset = 348 + extensions.length;
            this.setOffset(offset);
            System.out.println("changed offset to ".concat(String.valueOf(String.valueOf(offset))));
        }
        try {
            FileOutputStream fout = new FileOutputStream(fullPath);
            BufferedOutputStream bos = new BufferedOutputStream(fout);
            bos.write(this.getBytes());
            bos.write(extensions);
            for (int i = 0; i < image.length; ++i) {
                byte[] b = ByteConverter.getBytes(image[i]);
                bos.write(b);
            }
            bos.flush();
            bos.close();
        }
        catch (Exception e) {
            System.out.println("NiftiHeader.save(): can't write image ".concat(String.valueOf(String.valueOf(fullPath))));
            int n = -2;
            return n;
        }
        return 0;
    }

    public int saveNii(String path, short[] image) {
        int size = this.getOffset() - 348;
        if (size <= 0) {
            size = 4;
        }
        return this.saveNii(path, image, new byte[size]);
    }

    public int saveNii(String path, short[] image, byte[] extensions) {
        String fullPath = path;
        int offset = this.getOffset();
        if (offset != 348 + extensions.length) {
            offset = 348 + extensions.length;
            this.setOffset(offset);
            System.out.println("changed offset to ".concat(String.valueOf(String.valueOf(offset))));
        }
        try {
            FileOutputStream fout = new FileOutputStream(fullPath);
            BufferedOutputStream bos = new BufferedOutputStream(fout);
            bos.write(this.getBytes());
            bos.write(extensions);
            for (int i = 0; i < image.length; ++i) {
                byte[] b = ByteConverter.getBytes(image[i]);
                bos.write(b);
            }
            bos.flush();
            bos.close();
        }
        catch (Exception e) {
            System.out.println("NiftiHeader.save(): can't write image ".concat(String.valueOf(String.valueOf(fullPath))));
            int n = -2;
            return n;
        }
        return 0;
    }

    public int saveNii(String path, int[] image) {
        int size = this.getOffset() - 348;
        if (size <= 0) {
            size = 4;
        }
        return this.saveNii(path, image, new byte[size]);
    }

    public int saveNii(String path, int[] image, byte[] extensions) {
        String fullPath = path;
        int offset = this.getOffset();
        if (offset != 348 + extensions.length) {
            offset = 348 + extensions.length;
            this.setOffset(offset);
            System.out.println("changed offset to ".concat(String.valueOf(String.valueOf(offset))));
        }
        try {
            FileOutputStream fout = new FileOutputStream(fullPath);
            BufferedOutputStream bos = new BufferedOutputStream(fout);
            bos.write(this.getBytes());
            bos.write(extensions);
            for (int i = 0; i < image.length; ++i) {
                byte[] b = ByteConverter.getBytes(image[i]);
                bos.write(b);
            }
            bos.flush();
            bos.close();
        }
        catch (Exception e) {
            System.out.println("NiftiHeader.save(): can't write image ".concat(String.valueOf(String.valueOf(fullPath))));
            int n = -2;
            return n;
        }
        return 0;
    }

    public boolean[] readMask(Class c, String name) {
        BufferedInputStream bin;
        try {
            bin = OpenResource.openStream(c, name);
            bin.skip(this.getOffset());
        }
        catch (Exception e) {
            boolean[] blArray = null;
            return blArray;
        }
        return ImageHeader.readMask(bin, this);
    }

    public float[] readImage(String file) {
        return ImageHeader.readImage(this, file, this.getOffset());
    }

    public int[] readIntImage(String file) {
        return ImageHeader.readIntImage(this, file, this.getOffset());
    }

    public short[] readShortImage(String file) {
        return ImageHeader.readShortImage(this, file, this.getOffset());
    }

    public static NiftiHeader readHeader(Class c, String name) {
        NiftiHeader hdr = new NiftiHeader();
        hdr.setBytes(ImageHeader.readHeaderBytes(c, name));
        return hdr;
    }

    public static NiftiHeader readHeader(String file) {
        NiftiHeader hdr = new NiftiHeader();
        hdr.setBytes(ImageHeader.readHeaderBytes(file));
        return hdr;
    }

    public static NiftiHeader readHeader(BufferedInputStream bis) {
        NiftiHeader hdr = new NiftiHeader();
        hdr.setBytes(ImageHeader.readHeaderBytes(bis));
        return hdr;
    }

    public byte[] readExtensionBytes(String name) {
        long off = this.getOffset();
        long size = off - (long)348;
        if (size < (long)0) {
            return null;
        }
        if (size == (long)0) {
            return new byte[0];
        }
        byte[] bytes = new byte[(int)size];
        try {
            FileInputStream fis = new FileInputStream(name);
            BufferedInputStream bin = new BufferedInputStream(fis);
            bin.skip(348L);
            int read = bin.read(bytes);
            bin.close();
            if (read != bytes.length) {
                System.out.println(String.valueOf(String.valueOf(new StringBuffer("read only ").append(read).append(" of ").append(bytes.length))));
            }
            byte[] byArray = bytes;
            return byArray;
        }
        catch (Exception e) {
            e.printStackTrace();
            byte[] byArray = null;
            return byArray;
        }
    }

    static {
        NIFTI_UNITS_UNKNOWN = 0;
        NIFTI_UNITS_METER = 1;
        NIFTI_UNITS_MM = (byte)2;
        NIFTI_UNITS_MICRON = (byte)3;
        NIFTI_UNITS_SEC = (byte)8;
        NIFTI_UNITS_MSEC = (byte)16;
        NIFTI_UNITS_USEC = (byte)24;
        NIFTI_UNITS_HZ = (byte)32;
        NIFTI_UNITS_PPM = (byte)40;
        NIFTI_UNITS_RADS = (byte)48;
        NIFTI_XFORM_UNKNOWN = 0;
        NIFTI_XFORM_SCANNER_ANAT = 1;
        NIFTI_XFORM_ALIGNED_ANAT = (byte)2;
        NIFTI_XFORM_TALAIRACH = (byte)3;
        NIFTI_XFORM_MNI_152 = (byte)4;
    }
}

