/*
 * Decompiled with CFR 0.152.
 */
package org.brainmap.image;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.PrintStream;
import org.brainmap.image.NiftiHeader;
import org.brainmap.util.ByteConverter;
import org.brainmap.util.OpenResource;

public class NiftiImage
extends NiftiHeader {
    private byte[] extension = new byte[]{0, 0, 0, 0};
    private boolean[] imageBoolean;
    private byte[] imageByte = null;
    private short[] imageShort = null;
    private int[] imageInt = null;
    private float[] imageFloat = null;
    private double[] imageDouble = null;

    public NiftiImage() {
    }

    public NiftiImage(NiftiHeader hdr) {
        this();
        this.setBytes(hdr.getBytes());
    }

    public void out(PrintStream out) {
        super.out(out);
        if (this.extension == null) {
            System.out.println("extension bytes: null");
        } else {
            System.out.println("extension bytes: ".concat(String.valueOf(String.valueOf(this.extension.length))));
        }
        if (this.imageBoolean != null) {
            System.out.println("image (binary): ".concat(String.valueOf(String.valueOf(this.imageBoolean.length))));
        }
        if (this.imageByte != null) {
            System.out.println("image (byte): ".concat(String.valueOf(String.valueOf(this.imageByte.length))));
        }
        if (this.imageShort != null) {
            System.out.println("image (short): ".concat(String.valueOf(String.valueOf(this.imageShort.length))));
        }
        if (this.imageInt != null) {
            System.out.println("image (int): ".concat(String.valueOf(String.valueOf(this.imageInt.length))));
        }
        if (this.imageFloat != null) {
            System.out.println("image (float): ".concat(String.valueOf(String.valueOf(this.imageFloat.length))));
        }
        if (this.imageDouble != null) {
            System.out.println("image (double): ".concat(String.valueOf(String.valueOf(this.imageDouble.length))));
        }
        System.out.println();
    }

    public boolean[] getMask() {
        int nVoxels = this.getVoxelCount();
        boolean[] mask = new boolean[nVoxels];
        for (int i = 0; i < nVoxels; ++i) {
            mask[i] = false;
            byte[] voxel = this.getVoxelBytes(i);
            for (int j = 0; j < voxel.length; ++j) {
                if (voxel[j] == 0) continue;
                mask[i] = true;
            }
        }
        return mask;
    }

    public void setShortImage(boolean[] image) {
        this.imageShort = new short[image.length];
        for (int i = 0; i < this.imageShort.length; ++i) {
            this.imageShort[i] = image[i] ? (short)1 : 0;
        }
    }

    public void setByteImage(boolean[] image) {
        this.imageByte = new byte[image.length];
        for (int i = 0; i < this.imageByte.length; ++i) {
            this.imageByte[i] = image[i] ? (byte)1 : 0;
        }
    }

    public boolean[] getBinaryImage() {
        return this.imageBoolean;
    }

    public byte[] getByteImage() {
        return this.imageByte;
    }

    public short[] getShortImage() {
        return this.imageShort;
    }

    public int[] getIntegerImage() {
        return this.imageInt;
    }

    public float[] getFloatImage() {
        return this.imageFloat;
    }

    public double[] getDoubleImage() {
        return this.imageDouble;
    }

    public void setImage(boolean[] b) {
        if (this.getDataType() != 1) {
            System.out.println("NiftiImage.setImage(boolean[]) - bad data type");
            return;
        }
        short[] dim = this.getDimensions();
        int nVoxels = dim[1] * dim[2] * dim[3];
        if (b == null || b.length != nVoxels) {
            System.out.println("NiftiImage.setImage(boolean[]) - bad dimensions");
        }
        this.imageBoolean = b;
    }

    public void setImage(byte[] b) {
        if (this.getDataType() != 2) {
            System.out.println("NiftiImage.setImage(byte[]) - bad data type");
            return;
        }
        short[] dim = this.getDimensions();
        int nVoxels = dim[1] * dim[2] * dim[3];
        if (b == null || b.length != nVoxels) {
            System.out.println("NiftiImage.setImage(byte[]) - bad dimensions");
        }
        this.imageByte = b;
    }

    public void setImage(short[] b) {
        if (this.getDataType() != 4) {
            System.out.println("NiftiImage.setImage(short[]) - bad data type");
            return;
        }
        short[] dim = this.getDimensions();
        int nVoxels = dim[1] * dim[2] * dim[3];
        if (b == null || b.length != nVoxels) {
            System.out.println("NiftiImage.setImage(short[]) - bad dimensions");
        }
        this.imageShort = b;
    }

    public void setImage(int[] b) {
        if (this.getDataType() != 8) {
            System.out.println("NiftiImage.setImage(int[]) - bad data type");
            return;
        }
        short[] dim = this.getDimensions();
        int nVoxels = dim[1] * dim[2] * dim[3];
        if (b == null || b.length != nVoxels) {
            System.out.println("NiftiImage.setImage(int[]) - bad dimensions");
        }
        this.imageInt = b;
    }

    public void setImage(float[] b) {
        if (this.getDataType() != 16) {
            System.out.println("NiftiImage.setImage(float[]) - bad data type");
            return;
        }
        short[] dim = this.getDimensions();
        int nVoxels = dim[1] * dim[2] * dim[3];
        if (b == null || b.length != nVoxels) {
            System.out.println("NiftiImage.setImage(float[]) - bad dimensions");
        }
        this.imageFloat = b;
    }

    public void setImage(double[] b) {
        if (this.getDataType() != 64) {
            System.out.println("NiftiImage.setImage(double[]) - bad data type");
            return;
        }
        short[] dim = this.getDimensions();
        int nVoxels = dim[1] * dim[2] * dim[3];
        if (b == null || b.length != nVoxels) {
            System.out.println("NiftiImage.setImage(double[]) - bad dimensions");
        }
        this.imageDouble = b;
    }

    public static void main(String[] args) {
        NiftiImage nii = new NiftiImage();
        nii.cleanUnderlay();
    }

    public void cleanUnderlay() {
        boolean cleanExtensionBytes = false;
        boolean cleanImageData = true;
        NiftiImage nii = NiftiImage.readNiftiImage("colin1x1x1_tlrc.nii");
        if (cleanExtensionBytes) {
            String s = nii.getExtensionString();
            String par = "ANAT_PARENT";
            String tag = "<AFNI_atr";
            int anat = s.indexOf(par);
            while (anat > -1) {
                int start = s.lastIndexOf(tag, anat);
                int end = s.indexOf(tag, anat);
                s = String.valueOf(String.valueOf(s.substring(0, start))).concat(String.valueOf(String.valueOf(s.substring(end, s.length()))));
                anat = s.indexOf(par);
            }
            nii.extension = NiftiImage.getAfniExtensionBytes(s);
        }
        if (cleanImageData) {
            short[] image = nii.getShortImage();
            short max = 0;
            for (int i = 0; i < image.length; ++i) {
                short value = image[i];
                if (image[i] < 0) {
                    image[i] = 0;
                }
                if (image[i] > max) {
                    max = image[i];
                }
                image[i] = value;
            }
            nii.setMinMax(0.0f, max);
            nii.setImage(image);
        }
        nii.setDescription("Talairach aligned AFNI underlay of the Colin brain...");
        nii.out(System.out);
        nii.save("colin_cleaned.nii");
    }

    public void createMask() {
        String name = "colin1x1x1_tlrc.nii";
        NiftiImage nii = (NiftiImage)NiftiImage.readHeader(name);
        byte[] ext = nii.readExtensionBytes(name);
        short[] image = nii.readShortImage(name);
        int voxel = 2;
        int xMin = -80;
        int xMax = 80;
        int yMin = -110;
        int yMax = 80;
        int zMin = -64;
        int zMax = 84;
        int xDim = (xMax - xMin) / voxel + 1;
        int yDim = (yMax - yMin) / voxel + 1;
        int zDim = (zMax - zMin) / voxel + 1;
        System.out.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(xDim))).append(" ").append(yDim).append(" ").append(zDim))));
        NiftiHeader two = new NiftiHeader();
        two.setBytes(nii.getBytes());
        two.setDimensions(xDim, yDim, zDim, voxel);
        two.setMinMax(0.0f, 1.0f);
        two.setOffset(352);
        two.setRotationalOffset(xMin, yMin, zMin);
        two.setAffineOffset(xMin, yMin, zMin);
        short[] dim = two.getDimensions();
        short[] mask = new short[dim[1] * dim[2] * dim[3]];
        float[] near = new float[3];
        int nearby = 1;
        int sum = 0;
        for (int i = 0; i < mask.length; ++i) {
            int tally = 0;
            float[] xyz = two.getXYZ(i);
            if (xyz[0] == (float)xMin && xyz[1] == (float)yMin && xyz[2] % 1.0f == 0.0f) {
                System.out.println("slice ".concat(String.valueOf(String.valueOf(xyz[2]))));
            }
            for (int x = -1 * nearby; x <= nearby; ++x) {
                for (int y = -1 * nearby; y <= nearby; ++y) {
                    for (int z = -1 * nearby; z <= nearby; ++z) {
                        short value;
                        near[0] = xyz[0] + (float)x;
                        near[1] = xyz[1] + (float)y;
                        near[2] = xyz[2] + (float)z;
                        int index = nii.getIndex(near);
                        if (image.length <= index || index < 0 || (value = image[index]) <= 10) continue;
                        ++tally;
                    }
                }
            }
            if (tally >= 9) {
                mask[i] = 1;
                ++sum;
                continue;
            }
            mask[i] = 0;
        }
        System.out.println(String.valueOf(String.valueOf(new StringBuffer("mask has ").append(sum).append(" of ").append(mask.length))));
        two.out(System.out);
        mask = this.maskPlusPlus(two, mask);
        two.setDescription("Mask based on Talairach aligned Colin brain");
        two.saveNii("mask_bigger.nii", mask);
    }

    public short[] maskPlusPlus(NiftiHeader nii, short[] small) {
        System.out.println("expanding mask...");
        short[] big = new short[small.length];
        float[] near = new float[3];
        for (int i = 0; i < big.length; ++i) {
            float[] xyz = nii.getXYZ(i);
            if (xyz[0] == 0.0f && xyz[1] == 0.0f && xyz[2] % 1.0f == 0.0f) {
                System.out.println("slice ".concat(String.valueOf(String.valueOf(xyz[2]))));
            }
            boolean found = false;
            for (int x = -1; x <= 1; ++x) {
                for (int y = -1; y <= 1; ++y) {
                    for (int z = -1; z <= 1; ++z) {
                        near[0] = xyz[0] + (float)(x * 2);
                        near[1] = xyz[1] + (float)(y * 2);
                        near[2] = xyz[2] + (float)(z * 2);
                        try {
                            if (small[nii.getIndex(near)] > 0) {
                                found = true;
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (found) break;
                    }
                    if (found) break;
                }
                if (found) break;
            }
            big[i] = found ? (short)1 : 0;
        }
        return big;
    }

    public void setExtensionBytes(byte[] b) {
        this.extension = b;
        this.setOffset(348 + this.extension.length);
    }

    public String getExtensionString() {
        return NiftiImage.getExtensionString(this.extension);
    }

    public static String getExtensionString(byte[] ext) {
        int start = 12;
        int size = ext.length - start;
        for (int i = 1; i < 16 && ext[ext.length - i] == 0; ++i) {
            --size;
        }
        String t = new String(ext, start, size);
        return t;
    }

    public static byte[] getAfniExtensionBytes(String s) {
        int i;
        int length = s.length() + 8;
        int size = length / 16;
        if (length % 16 != 0) {
            ++size;
        }
        byte[] extensions = new byte[(size *= 16) + 4];
        byte[] num = ByteConverter.getBytes(0x1000000);
        for (i = 0; i < 4; ++i) {
            extensions[i] = num[i];
        }
        num = ByteConverter.getBytes(size);
        for (i = 0; i < 4; ++i) {
            extensions[i + 4] = num[i];
        }
        num = ByteConverter.getBytes(4);
        for (i = 0; i < 4; ++i) {
            extensions[i + 8] = num[i];
        }
        for (i = 0; i < s.length(); ++i) {
            extensions[i + 12] = (byte)s.charAt(i);
        }
        return extensions;
    }

    public void setTalairachExtension(String[][] labels) {
        this.setExtensionBytes(NiftiImage.getTalairachExtensionBytes(labels));
    }

    public static byte[] getTalairachExtensionBytes(String[][] labels) {
        int i;
        String total = "";
        for (int i2 = 0; i2 < labels.length; ++i2) {
            String line = "";
            for (int j = 0; j < labels[i2].length; ++j) {
                line = String.valueOf(String.valueOf(line)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(labels[i2][j])).concat("."))));
            }
            line = String.valueOf(String.valueOf(line.substring(0, line.length() - 1))).concat("\n");
            total = String.valueOf(String.valueOf(total)).concat(String.valueOf(String.valueOf(line)));
        }
        int length = total.length() + 8;
        int size = length / 16;
        if (length % 16 != 0) {
            ++size;
        }
        byte[] extensions = new byte[(size *= 16) + 4];
        byte[] num = ByteConverter.getBytes(0);
        for (i = 0; i < 4; ++i) {
            extensions[i] = num[i];
        }
        num = ByteConverter.getBytes(size);
        for (i = 0; i < 4; ++i) {
            extensions[i + 4] = num[i];
        }
        num = ByteConverter.getBytes(4);
        for (i = 0; i < 4; ++i) {
            extensions[i + 8] = num[i];
        }
        for (i = 0; i < total.length(); ++i) {
            extensions[i + 12] = (byte)total.charAt(i);
        }
        return extensions;
    }

    private void initImage() {
        short[] dim = this.getDimensions();
        int nVoxels = dim[1] * dim[2] * dim[3];
        if (this.isBinaryImage()) {
            this.imageBoolean = new boolean[nVoxels];
        }
        if (this.isByteImage()) {
            this.imageByte = new byte[nVoxels];
        }
        if (this.isShortImage()) {
            this.imageShort = new short[nVoxels];
        }
        if (this.isIntegerImage()) {
            this.imageInt = new int[nVoxels];
        }
        if (this.isFloatImage()) {
            this.imageFloat = new float[nVoxels];
        }
        if (this.isDoubleImage()) {
            this.imageDouble = new double[nVoxels];
        }
    }

    public int getVoxelCount() {
        int nVoxels = -1;
        if (this.imageBoolean != null && this.isBinaryImage()) {
            nVoxels = this.imageBoolean.length;
        }
        if (this.imageByte != null && this.isByteImage()) {
            nVoxels = this.imageByte.length;
        }
        if (this.imageShort != null && this.isShortImage()) {
            nVoxels = this.imageShort.length;
        }
        if (this.imageInt != null && this.isIntegerImage()) {
            nVoxels = this.imageInt.length;
        }
        if (this.imageFloat != null && this.isFloatImage()) {
            nVoxels = this.imageFloat.length;
        }
        if (this.imageDouble != null && this.isDoubleImage()) {
            nVoxels = this.imageDouble.length;
        }
        return nVoxels;
    }

    private byte[] getVoxelBytes(int i) {
        if (this.isBinaryImage()) {
            if (this.imageBoolean[i]) {
                return new byte[]{1};
            }
            return new byte[]{0};
        }
        if (this.isByteImage()) {
            return new byte[]{this.imageByte[i]};
        }
        if (this.isShortImage() && this.imageShort != null) {
            return ByteConverter.getBytes(this.imageShort[i]);
        }
        if (this.imageInt != null) {
            return ByteConverter.getBytes(this.imageInt[i]);
        }
        if (this.imageFloat != null) {
            return ByteConverter.getBytes(this.imageFloat[i]);
        }
        if (this.imageDouble != null) {
            return ByteConverter.getBytes(this.imageDouble[i]);
        }
        return null;
    }

    private void setVoxelBytes(int i, byte[] b) {
        if (b == null) {
            return;
        }
        short nBits = this.getBits();
        int nBytes = nBits / 8;
        if (nBytes < 1) {
            nBytes = 1;
        }
        if (b.length < nBits / 8) {
            return;
        }
        if (this.isBinaryImage()) {
            boolean bl = this.imageBoolean[i] = b[0] == 1;
        }
        if (this.isByteImage()) {
            this.imageByte[i] = b[0];
        }
        if (this.isShortImage()) {
            this.imageShort[i] = ByteConverter.getShort(b, 0);
        }
        if (this.isIntegerImage()) {
            this.imageInt[i] = ByteConverter.getInt(b, 0);
        }
        if (this.isFloatImage()) {
            this.imageFloat[i] = ByteConverter.getFloat(b, 0);
        }
        if (this.isDoubleImage()) {
            this.imageDouble[i] = ByteConverter.getDouble(b, 0);
        }
    }

    public byte[] getNiftiBytes() {
        int length = this.getVoxelCount();
        int offset = this.getOffset();
        if (offset != 348 + this.extension.length) {
            offset = 348 + this.extension.length;
            this.setOffset(offset);
            System.out.println("changed offset to ".concat(String.valueOf(String.valueOf(offset))));
        }
        int nBytes = offset + length * this.getBits() / 8;
        ByteArrayOutputStream baos = new ByteArrayOutputStream(nBytes);
        try {
            baos.write(this.getBytes());
            baos.write(this.extension);
            for (int i = 0; i < length; ++i) {
                baos.write(this.getVoxelBytes(i));
            }
            baos.flush();
            baos.close();
        }
        catch (Exception e) {
            System.out.println("NiftiImage.getNiftiBytes(): ");
            System.out.println(e.getMessage());
            byte[] byArray = null;
            return byArray;
        }
        return baos.toByteArray();
    }

    public int save(String path) {
        try {
            FileOutputStream fout = new FileOutputStream(path);
            BufferedOutputStream bos = new BufferedOutputStream(fout);
            bos.write(this.getNiftiBytes());
            bos.flush();
            bos.close();
        }
        catch (Exception e) {
            System.out.println("NiftiImage.save(String): ");
            System.out.println(e.getMessage());
            int n = -1;
            return n;
        }
        return 0;
    }

    public static NiftiImage readNiftiImage(String name) {
        File f = new File(name);
        if (!f.exists()) {
            return null;
        }
        try {
            FileInputStream fis = new FileInputStream(name);
            NiftiImage niftiImage = NiftiImage.readNiftiImage(new BufferedInputStream(fis));
            return niftiImage;
        }
        catch (Throwable t) {
            System.out.println("readNiftiImage: can't read file ".concat(String.valueOf(String.valueOf(name))));
            NiftiImage niftiImage = null;
            return niftiImage;
        }
    }

    public static NiftiImage readNiftiImage(Class c, String name) {
        BufferedInputStream bin;
        try {
            bin = OpenResource.openStream(c, name);
        }
        catch (Exception e) {
            NiftiImage niftiImage = null;
            return niftiImage;
        }
        return NiftiImage.readNiftiImage(bin);
    }

    public static NiftiImage readNiftiImage(BufferedInputStream bin) {
        if (bin == null) {
            return null;
        }
        NiftiImage nifti = new NiftiImage();
        try {
            byte[] b = new byte[348];
            bin.read(b, 0, 348);
            nifti.setBytes(b);
        }
        catch (Exception e) {
            e.printStackTrace();
            NiftiImage niftiImage = null;
            return niftiImage;
        }
        int offset = nifti.getOffset();
        int size = offset - 348;
        if (size < 4) {
            size = 4;
        }
        nifti.extension = new byte[size];
        try {
            bin.read(nifti.extension);
        }
        catch (Exception e) {
            e.printStackTrace();
            NiftiImage niftiImage = null;
            return niftiImage;
        }
        nifti.initImage();
        int length = nifti.getVoxelCount();
        int bytes = nifti.getBits() / 8;
        try {
            byte[] b = new byte[bytes];
            for (int i = 0; i < length; ++i) {
                bin.read(b);
                nifti.setVoxelBytes(i, b);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            NiftiImage niftiImage = null;
            return niftiImage;
        }
        return nifti;
    }
}

