/*
 * Decompiled with CFR 0.152.
 */
package org.brainmap.talairach;

import java.util.StringTokenizer;
import org.brainmap.talairach.TalairachUtility;

public class PointToTD {
    public static void main(String[] args) {
        double[] argList;
        PointToTD point = new PointToTD();
        try {
            argList = point.parseArgs(args);
        }
        catch (Exception e) {
            e.printStackTrace();
            argList = null;
        }
        if (argList == null) {
            point.usage();
        }
        int nArgs = argList.length;
        String coord = "";
        for (int i = nArgs - 3; i < nArgs; ++i) {
            coord = String.valueOf(String.valueOf(coord)).concat(String.valueOf(String.valueOf(",".concat(String.valueOf(String.valueOf(argList[i]))))));
        }
        String request = "";
        request = nArgs == 4 ? String.valueOf(String.valueOf((int)argList[0])).concat(String.valueOf(String.valueOf(coord))) : String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf((int)argList[0]))).append(":").append((int)argList[1]).append(coord)));
        TalairachUtility tUtil = new TalairachUtility();
        boolean okay = tUtil.test();
        if (!okay) {
            System.err.println("Error connecting to TD server");
            System.exit(1);
        }
        System.out.println("Sent: ".concat(String.valueOf(String.valueOf(request))));
        String result = tUtil.sendLine(request);
        point.parseResults((int)argList[0], result);
    }

    public void usage() {
        System.err.println("\nusage: PointtoTD <Code> [:Cubesize], xcoord, ycoord, zcoord");
        System.err.println();
        System.err.println("where <Code> must be one of the the following");
        System.err.println("  1 - SPMap data");
        System.err.println("  2 - Talairach Label Data");
        System.err.println("  3 - mm x mm x mm cube search area");
        System.err.println("      use [:Cubesize] for sizes of 3, 5, 7, 9, or 11. Default is 5.");
        System.err.println();
        System.err.println("for example:");
        System.err.println("   PointtotoTD 2, -15, 5, 3");
        System.err.println("   PointtotoTD 3:9, 23, -3, 2");
        System.err.println();
        System.exit(1);
    }

    public double[] parseArgs(String[] args) throws Exception {
        String total = "";
        for (int i = 0; i < args.length; ++i) {
            total = String.valueOf(String.valueOf(total)).concat(String.valueOf(String.valueOf(args[i])));
        }
        StringTokenizer st = new StringTokenizer(total, ",");
        if (st.countTokens() < 4) {
            System.err.println("Additional parameters needed.");
            throw new Exception("Too few arguments");
        }
        args = new String[4];
        for (int i = 0; i < 4; ++i) {
            args[i] = st.nextToken();
        }
        int code = Integer.parseInt("".concat(String.valueOf(String.valueOf(args[0].charAt(0)))));
        int range = 5;
        if (args[0].length() >= 3 && (range = Integer.parseInt("".concat(String.valueOf(String.valueOf(args[0].charAt(2)))))) != 1 && range != 3 && range != 5 && range != 7 && range != 9 && range != 11) {
            System.err.println("Invalid Cubesize- must be 3, 5, 7, 9 or 11.");
            throw new Exception("Invalid cube range");
        }
        double[] result = null;
        int index = 0;
        if (code == 1 || code == 2) {
            result = new double[4];
            result[index++] = code;
        } else if (code == 3) {
            result = new double[5];
            result[index++] = code;
            result[index++] = range;
        } else {
            throw new Exception("Invalid code");
        }
        result[index++] = Double.parseDouble(args[1]);
        result[index++] = Double.parseDouble(args[2]);
        result[index++] = Double.parseDouble(args[3]);
        return result;
    }

    public void parseResults(int type, String result) {
        System.out.println("Returned:");
        if (type == 1 || type == 2) {
            System.out.println(result);
            return;
        }
        StringTokenizer st = new StringTokenizer(result, ":");
        int nTokens = st.countTokens();
        int size = nTokens / 2;
        if (nTokens % 2 != 0) {
            System.err.println("why is the result odd?");
        }
        String[] labels = new String[size];
        int[] hits = new int[size];
        int index = 0;
        while (st.hasMoreTokens()) {
            String next = st.nextToken();
            hits[index] = Integer.parseInt(next);
            labels[index] = next = st.nextToken();
            ++index;
        }
        for (int i = 0; i < size; ++i) {
            for (int j = i + 1; j < size; ++j) {
                if (hits[i] >= hits[j]) continue;
                int tempHit = hits[i];
                hits[i] = hits[j];
                hits[j] = tempHit;
                String tempLabel = labels[i];
                labels[i] = labels[j];
                labels[j] = tempLabel;
            }
        }
        String[] padding = new String[]{"     ", "    ", "   ", "  ", " ", ""};
        for (int i = 0; i < size; ++i) {
            String out = "".concat(String.valueOf(String.valueOf(hits[i])));
            out = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(padding[out.length()]))).append(out).append(":")));
            out = String.valueOf(String.valueOf(out)).concat(String.valueOf(String.valueOf(labels[i])));
            System.out.println(out);
        }
        System.out.println();
    }
}

