/*
 * Decompiled with CFR 0.152.
 */
package org.brainmap.talairach;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.KeyStroke;
import javax.swing.border.TitledBorder;
import org.brainmap.gui.JFloatField;
import org.brainmap.gui.MsgBox;
import org.brainmap.gui.ScrollText;
import org.brainmap.gui.View;
import org.brainmap.image.NiftiImage;
import org.brainmap.talairach.CustomFileChooser;
import org.brainmap.talairach.Database;
import org.brainmap.talairach.ProcessorThread2;
import org.brainmap.talairach.TDLabel;
import org.brainmap.util.ExtensionFilter;
import org.brainmap.util.StringUtilities;

public class TalairachClient
extends JFrame
implements ActionListener,
WindowListener,
View {
    private File outputFile = null;
    private File lastDirectory = null;
    private String LoadFname;
    private String fileFilterFile = "inputFormats.txt";
    private int count = -1;
    private int fileCount = 0;
    private int fileType = 0;
    private JMenuItem fileInput;
    private JMenuItem fileOutput;
    private JMenuItem fileQuit;
    private boolean appendData = false;
    private File[] fileList;
    private int[] rows;
    private int[] cols;
    private ExtensionFilter[] exts;
    private int startRow;
    private int startCol;
    private int Records;
    private Database TDdatabase = new Database();
    private JRadioButton nearest;
    private JRadioButton single;
    private JRadioButton range;
    private JComboBox rangeDistance;
    private JFloatField xcoor;
    private JFloatField ycoor;
    private JFloatField zcoor;
    private JButton processCoords;
    private CustomFileChooser LoadD;
    private JButton chooseInput;
    private JButton processFile;
    private JLabel inputLabel;
    private byte[] X;
    private byte[] Y;
    private byte[] Z;
    private String[] remainders;
    private FileOutputStream fsubj_out;
    private PrintStream subj_out;
    private boolean is_subj_file_open = false;
    private JCheckBox outputCheck;
    private String outputPrefix = "Save to file: ";
    private JButton outputButton;
    private ScrollText Status;
    private JButton clearButton;
    private JButton viewResults;
    private JDialog progressDialog;
    private JProgressBar progressBar;
    private JLabel progressLabel;

    public static void main(String[] args) {
        new TalairachClient();
    }

    public TalairachClient() {
        this.TDdatabase.setView(this);
        this.loadFileFilters();
        this.LoadD = new CustomFileChooser(this, this.lastDirectory);
        this.LoadD.setLocation(0, 0);
        int meta = System.getProperty("os.name").startsWith("Win") ? 2 : 4;
        this.fileInput = new JMenuItem("Choose Input File");
        this.fileInput.addActionListener(this);
        this.fileInput.setAccelerator(KeyStroke.getKeyStroke(79, meta));
        this.fileOutput = new JMenuItem("Choose Output File");
        this.fileOutput.addActionListener(this);
        this.fileOutput.setAccelerator(KeyStroke.getKeyStroke(83, meta));
        this.fileQuit = new JMenuItem("Quit");
        this.fileQuit.addActionListener(this);
        this.fileQuit.setAccelerator(KeyStroke.getKeyStroke(81, meta));
        JMenuBar menu = new JMenuBar();
        JMenu file = new JMenu("File");
        file.add(this.fileInput);
        file.add(this.fileOutput);
        file.add(this.fileQuit);
        menu.add(file);
        this.setJMenuBar(menu);
        this.Status = new ScrollText();
        this.Status.setText("Welcome to the Talairach Daemon Client.\n\n");
        this.Status.setFont(new Font("dialoginput", 0, 12));
        this.Status.setEditable(false);
        this.Status.setScrollBarsSometimes(ScrollText.HORIZONTAL);
        this.Status.setScrollBarsSometimes(ScrollText.VERTICAL);
        this.viewResults = new JButton("View Results");
        this.viewResults.addActionListener(this);
        this.clearButton = new JButton("Clear Text");
        this.clearButton.addActionListener(this);
        this.single = new JRadioButton("Single Point", true);
        this.single.addActionListener(this);
        this.nearest = new JRadioButton("Nearest Gray Matter", false);
        this.nearest.addActionListener(this);
        this.range = new JRadioButton("Cube Range", false);
        this.range.addActionListener(this);
        ButtonGroup options = new ButtonGroup();
        options.add(this.single);
        options.add(this.nearest);
        options.add(this.range);
        this.rangeDistance = new JComboBox();
        this.rangeDistance.addItem("3 mm");
        this.rangeDistance.addItem("5 mm");
        this.rangeDistance.addItem("7 mm");
        this.rangeDistance.addItem("9 mm");
        this.rangeDistance.addItem("11 mm");
        this.rangeDistance.setEnabled(false);
        JPanel talairachPanel = new JPanel(new GridBagLayout());
        GridBagConstraints grid = new GridBagConstraints();
        grid.insets = new Insets(5, 5, 5, 5);
        grid.gridx = 1;
        talairachPanel.add((Component)this.nearest, grid);
        grid.gridx = 0;
        talairachPanel.add((Component)this.single, grid);
        grid.gridx = 3;
        talairachPanel.add((Component)this.range, grid);
        grid.gridx = 4;
        talairachPanel.add((Component)this.rangeDistance, grid);
        this.setContentPane(talairachPanel);
        TitledBorder b = BorderFactory.createTitledBorder("Database Search Options");
        talairachPanel.setBorder(b);
        JPanel inputFile = new JPanel(new GridBagLayout());
        grid = new GridBagConstraints();
        grid.insets = new Insets(5, 5, 5, 5);
        this.inputLabel = new JLabel("Data file:  None");
        grid.gridwidth = 1;
        grid.gridx = 0;
        grid.gridy = 0;
        grid.weightx = 10.0;
        grid.gridwidth = 2;
        grid.fill = 2;
        inputFile.add((Component)this.inputLabel, grid);
        this.chooseInput = new JButton("Choose file...");
        this.chooseInput.addActionListener(this);
        grid.gridx = 0;
        grid.gridy = 1;
        grid.weightx = 1.0;
        grid.gridwidth = 1;
        grid.fill = 0;
        inputFile.add((Component)this.chooseInput, grid);
        this.processFile = new JButton("Search");
        this.processFile.addActionListener(this);
        grid.gridx = 1;
        grid.gridy = 1;
        inputFile.add((Component)this.processFile, grid);
        b = BorderFactory.createTitledBorder("Input file");
        inputFile.setBorder(b);
        JPanel coordinatePanel = new JPanel(new GridBagLayout());
        grid = new GridBagConstraints();
        grid.insets = new Insets(5, 5, 5, 5);
        JLabel xLabel = new JLabel("X: ");
        JLabel yLabel = new JLabel("Y: ");
        JLabel zLabel = new JLabel("Z: ");
        grid.fill = 0;
        grid.weightx = 0.0;
        grid.gridx = 0;
        coordinatePanel.add((Component)xLabel, grid);
        grid.gridx = 2;
        coordinatePanel.add((Component)yLabel, grid);
        grid.gridx = 4;
        coordinatePanel.add((Component)zLabel, grid);
        this.xcoor = new JFloatField(0, 4);
        this.ycoor = new JFloatField(0, 4);
        this.zcoor = new JFloatField(0, 4);
        grid.fill = 2;
        grid.weightx = 5.0;
        grid.gridx = 1;
        coordinatePanel.add((Component)this.xcoor, grid);
        grid.gridx = 3;
        coordinatePanel.add((Component)this.ycoor, grid);
        grid.gridx = 5;
        coordinatePanel.add((Component)this.zcoor, grid);
        this.processCoords = new JButton("Search");
        this.processCoords.addActionListener(this);
        grid.gridx = 0;
        grid.gridy = 1;
        grid.gridwidth = 6;
        grid.weightx = 1.0;
        grid.fill = 0;
        grid.anchor = 10;
        coordinatePanel.add((Component)this.processCoords, grid);
        b = BorderFactory.createTitledBorder("Coordinate Search");
        coordinatePanel.setBorder(b);
        JPanel output = new JPanel(new GridBagLayout());
        grid = new GridBagConstraints();
        grid.insets = new Insets(5, 5, 5, 5);
        this.outputCheck = new JCheckBox(String.valueOf(String.valueOf(this.outputPrefix)).concat("None"), false);
        this.outputCheck.addActionListener(this);
        this.outputCheck.setEnabled(false);
        grid.weightx = 10.0;
        grid.gridx = 0;
        grid.anchor = 17;
        output.add((Component)this.outputCheck, grid);
        this.outputButton = new JButton("Choose file...");
        this.outputButton.addActionListener(this);
        grid.weightx = 1.0;
        grid.gridx = 1;
        grid.anchor = 13;
        output.add((Component)this.outputButton, grid);
        b = BorderFactory.createTitledBorder("Result file");
        output.setBorder(b);
        JPanel content = new JPanel(new GridBagLayout());
        grid = new GridBagConstraints();
        grid.insets = new Insets(5, 5, 5, 5);
        grid.gridwidth = 3;
        grid.fill = 2;
        grid.gridx = 0;
        grid.gridy = 0;
        content.add((Component)talairachPanel, grid);
        JPanel inputs = new JPanel(new GridLayout());
        inputs.add(inputFile);
        inputs.add(coordinatePanel);
        grid.gridx = 0;
        grid.gridy = 1;
        content.add((Component)inputs, grid);
        grid.gridx = 0;
        grid.gridy = 2;
        content.add((Component)output, grid);
        grid.fill = 1;
        grid.weighty = 1.0;
        grid.weightx = 1.0;
        grid.gridx = 0;
        grid.gridy = 3;
        content.add((Component)this.Status, grid);
        grid.fill = 0;
        grid.gridwidth = 1;
        grid.weighty = 0.0;
        grid.weightx = 0.0;
        grid.gridx = 1;
        grid.gridy = 4;
        content.add((Component)this.viewResults, grid);
        grid.gridx = 2;
        grid.gridy = 4;
        content.add((Component)this.clearButton, grid);
        this.setContentPane(content);
        this.setName("Talairach Database");
        this.setSize(500, 600);
        this.setTitle("TD Client");
        this.addWindowListener(this);
        this.setDefaultCloseOperation(2);
        this.initDialog();
        int halfWidth = Toolkit.getDefaultToolkit().getScreenSize().width / 2;
        int x = halfWidth - this.progressDialog.getWidth() / 2;
        int halfHeight = Toolkit.getDefaultToolkit().getScreenSize().height / 2;
        int y = halfHeight - this.progressDialog.getHeight() / 2;
        this.progressDialog.setLocation(x, y);
        this.progressLabel.setText("Loading Talairach Database");
        this.progressDialog.pack();
        this.progressBar.setValue(0);
        this.progressDialog.setModal(false);
        this.progressDialog.setVisible(true);
        if (new File("talairach.nii").exists()) {
            System.out.println("loading from .nii");
            NiftiImage nii = NiftiImage.readNiftiImage("talairach.nii");
            this.TDdatabase.load(nii);
        } else {
            this.TDdatabase.loadFromShortImage(this.getClass(), "talairach");
        }
    }

    private void init2() {
        this.progressDialog.dispose();
        if (!this.TDdatabase.loaded) {
            System.out.println(this.TDdatabase.Error);
            this.Status.setText("No database loaded - Error: ".concat(String.valueOf(String.valueOf(this.TDdatabase.Error))));
        }
        this.setVisible(true);
    }

    public void update(String s) {
        int i;
        String t;
        if (s == null) {
            return;
        }
        if (s.startsWith("init-")) {
            t = s.substring("init-".length(), s.length());
            i = Integer.parseInt(t);
            this.progressBar.setMaximum(i);
        }
        if (s.startsWith("update-")) {
            t = s.substring("update-".length(), s.length());
            i = Integer.parseInt(t);
            int max = this.progressBar.getMaximum();
            if (max > i) {
                this.progressBar.setValue(i);
            } else {
                this.init2();
            }
        }
        if (s.startsWith("failed")) {
            this.init2();
        }
    }

    private boolean toFile() {
        return this.outputFile != null && this.outputCheck.isSelected();
    }

    private String getDelimiter() {
        if (this.outputFile != null && this.outputCheck.isSelected()) {
            return ",";
        }
        return "";
    }

    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        this.rangeDistance.setEnabled(this.range.isSelected());
        if (!this.TDdatabase.loaded) {
            this.Status.setText("");
            this.Status.appendText("The database is not loaded.  Restart program from the original directory.\n\n");
            System.exit(0);
        }
        if (src.equals(this.processCoords)) {
            TDLabel r;
            int x = this.xcoor.getInt();
            int y = this.ycoor.getInt();
            int z = this.zcoor.getInt();
            String result = "";
            if (this.single.isSelected()) {
                r = this.TDdatabase.findLabel(x, y, z);
                result = r == null ? String.valueOf(String.valueOf(new StringBuffer("No data found at: ").append(x).append(",").append(y).append(",").append(z))) : r.toStr();
                this.addText(String.valueOf(String.valueOf(result)).concat("\n"));
            }
            if (this.nearest.isSelected()) {
                r = this.TDdatabase.nearestGray(x, y, z);
                result = r == null ? (this.toFile() ? "No GM found,,,,," : "No Gray Matter found within 11mm\n") : String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(r.toStr()))).append("Range=").append(r.hits[0]).append("\n")));
                this.addText(result);
            }
            if (this.range.isSelected()) {
                int r2 = this.getRange();
                TDLabel[] array = this.TDdatabase.search_range(x, y, z, r2);
                result = String.valueOf(String.valueOf(new StringBuffer("Search Range is: ").append(2 * r2 + 1).append(" mm.\n")));
                for (int i = 0; i < array.length; ++i) {
                    result = String.valueOf(String.valueOf(result)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(array[i].hits[1]))).append(",").append(array[i].toStr()).append("\n"))))));
                }
                this.addText(result);
                this.addText("End of query.\n");
            }
            if (this.outputCheck.isSelected()) {
                if (!this.is_subj_file_open) {
                    return;
                }
                if (this.range.isSelected()) {
                    this.writeToResultFile(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(x))).append(",").append(y).append(",").append(z))));
                    this.writeToResultFile(result);
                } else {
                    this.writeToResultFile(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(x))).append(",").append(y).append(",").append(z).append(",").append(result))));
                }
            }
        }
        if (src.equals(this.processFile)) {
            do {
                if (this.fileCount == 0) {
                    this.Status.appendText("You haven't selected and files to process.\n\n");
                    break;
                }
                if (this.count >= this.fileCount) {
                    this.Status.appendText("These files have already been processed.  Click \"View Results\" to see the results.\n");
                    continue;
                }
                this.Status.appendText(String.valueOf(String.valueOf(new StringBuffer("Processing ").append(this.fileList[this.count].getName()).append("....\n"))));
                this.processFile2();
                ++this.count;
                if (this.count == this.fileCount) continue;
                this.updateReadFile(this.fileList[this.count]);
                this.setOutputFile(this.fileList[this.count]);
                this.openFile(this.count);
            } while (this.count < this.fileCount);
        }
        if (src.equals(this.viewResults)) {
            if (this.outputFile == null) {
                this.chooseOutputFile("ViewResults");
            }
            if (this.outputFile != null) {
                this.readResultFile();
            }
        }
        if (src.equals(this.clearButton)) {
            this.Status.setText("");
        }
        if (src.equals(this.fileInput) || src.equals(this.chooseInput)) {
            this.chooseInputFile();
            if (this.fileCount > 0) {
                this.openFile(this.count);
            }
        }
        if (src.equals(this.fileOutput) || src.equals(this.outputButton)) {
            this.chooseOutputFile("ChooseOutput");
        }
        if (src.equals(this.fileQuit)) {
            this.exit();
        }
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
        this.exit();
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }

    private void exit() {
        this.setVisible(false);
        this.dispose();
        System.exit(0);
    }

    private void initDialog() {
        this.progressDialog = new JDialog(this, "Progress", true);
        this.progressBar = new JProgressBar();
        this.progressBar.setValue(0);
        this.progressLabel = new JLabel("");
        JPanel p = new JPanel(new GridBagLayout());
        GridBagConstraints grid = new GridBagConstraints();
        grid.insets = new Insets(5, 5, 5, 5);
        grid.fill = 2;
        grid.weightx = 1.0;
        grid.gridy = 0;
        p.add((Component)this.progressLabel, grid);
        grid.gridy = 1;
        p.add((Component)this.progressBar, grid);
        this.progressDialog.setContentPane(p);
        this.progressDialog.setLocation(300, 300);
        this.progressDialog.pack();
    }

    private void chooseOutputFile(String type) {
        JFileChooser chooser = new JFileChooser();
        chooser.setLocation(300, 300);
        chooser.setCurrentDirectory(this.lastDirectory);
        if ("ViewResults".equals(type)) {
            ExtensionFilter td = new ExtensionFilter(".td", "Talairach Daemon Result Files");
            chooser.setFileFilter(td);
            chooser.showOpenDialog(this);
        } else {
            chooser.showSaveDialog(this);
        }
        chooser.setVisible(true);
        File f = chooser.getSelectedFile();
        if (f == null) {
            return;
        }
        this.setOutputFile(f);
        this.Status.appendText(String.valueOf(String.valueOf(new StringBuffer("Will save results in: ").append(f.getName()).append(".\n\n"))));
    }

    private void setOutputFile(File w) {
        if (w == null) {
            return;
        }
        String outputName = w.getName();
        int period = outputName.lastIndexOf(".");
        if (period > 0) {
            outputName = outputName.substring(0, period);
        }
        outputName = String.valueOf(String.valueOf(outputName)).concat(".td");
        File parent = w.getParentFile();
        String outputPath = String.valueOf(String.valueOf(parent.getAbsolutePath())).concat(String.valueOf(String.valueOf(File.separator)));
        this.outputFile = new File(String.valueOf(String.valueOf(outputPath)).concat(String.valueOf(String.valueOf(outputName))));
        this.outputCheck.setText(String.valueOf(String.valueOf(this.outputPrefix)).concat(String.valueOf(String.valueOf(outputName))));
        this.outputCheck.setEnabled(true);
        this.outputCheck.setSelected(true);
    }

    private void readResultFile() {
        this.setCursor(new Cursor(3));
        String name = this.outputFile.getName();
        if (this.outputFile == null) {
            this.Status.appendText("No output file selected.\n\n");
            return;
        }
        if (!this.outputFile.exists()) {
            this.Status.appendText(String.valueOf(String.valueOf(name)).concat(" could not be found.\n\n"));
            return;
        }
        if (!this.outputFile.canRead()) {
            this.Status.appendText(String.valueOf(String.valueOf(name)).concat(" is not readable.\n\n"));
            return;
        }
        this.Status.appendText(String.valueOf(String.valueOf(new StringBuffer("Reading Result File, ").append(name).append(": \n"))));
        try {
            String line;
            FileReader fr = new FileReader(this.outputFile);
            BufferedReader in = new BufferedReader(fr);
            while ((line = in.readLine()) != null) {
                this.Status.appendText(String.valueOf(String.valueOf(line)).concat("\n"));
            }
            in.close();
            this.Status.appendText("\n");
        }
        catch (FileNotFoundException ex) {
            this.Status.appendText(String.valueOf(String.valueOf(new StringBuffer("File, ").append(name).append(", not found.\n\n"))));
        }
        catch (IOException ex) {
            this.Status.appendText(String.valueOf(String.valueOf(new StringBuffer("File, ").append(name).append(", not readable.\n\n"))));
        }
        this.setCursor(new Cursor(0));
    }

    private void chooseInputFile() {
        this.count = 0;
        if (this.lastDirectory != null) {
            this.LoadD.setCurrentDirectory(this.lastDirectory);
        }
        this.LoadD.setMultiSelectionEnabled(true);
        this.LoadD.setVisible(true);
        this.Records = 0;
        this.LoadFname = null;
        this.fileList = this.LoadD.getSelectedFiles();
        this.fileCount = this.fileList.length;
        if (this.fileCount > 0) {
            this.setCursor(new Cursor(3));
            this.updateReadFile(this.fileList[this.count]);
            this.setOutputFile(this.fileList[this.count]);
            this.lastDirectory = this.fileList[this.count].getParentFile();
            this.setCursor(new Cursor(0));
        } else {
            this.LoadFname = ".null";
        }
    }

    private void openFile(int idx) {
        if (this.LoadFname == null) {
            return;
        }
        this.Records = this.loadCoordinates(this.LoadFname, idx);
        String selectedName = this.LoadD.getSelectedFile().getName();
        switch (this.Records) {
            case -2: {
                this.Status.appendText(String.valueOf(String.valueOf(new StringBuffer("Couldn't read file: ").append(selectedName).append(" wrong format.\n\n"))));
                break;
            }
            case -1: {
                this.Status.appendText(String.valueOf(String.valueOf(new StringBuffer("Couldn't open file: ").append(selectedName).append(".\n\n"))));
                break;
            }
            case 0: {
                this.Status.appendText(String.valueOf(String.valueOf(new StringBuffer("No records loaded ").append(this.LoadFname).append(".\n\n"))));
                break;
            }
            default: {
                this.Status.appendText(String.valueOf(String.valueOf(new StringBuffer("Loaded: ").append(this.Records).append(" coordinates from file: ").append(this.LoadFname.substring(this.LoadFname.lastIndexOf(File.separator) + 1)).append(".\n\n"))));
            }
        }
    }

    private int loadCoordinates(String Filename, int rowColIdx) {
        BufferedReader inp;
        try {
            inp = new BufferedReader(new FileReader(Filename));
        }
        catch (IOException e) {
            System.out.println("unable to open the file: ".concat(String.valueOf(String.valueOf(Filename))));
            int n = -1;
            return n;
        }
        int nLines = StringUtilities.CountLinesInFile(Filename);
        if (nLines > 50000) {
            MsgBox box = new MsgBox(this);
            box.showOkayBox("Will only read the first 50,000 records.");
            nLines = 50000;
        }
        this.X = new byte[nLines];
        this.Y = new byte[nLines];
        this.Z = new byte[nLines];
        this.remainders = new String[nLines];
        String line = null;
        for (int r = 0; r < nLines; ++r) {
            try {
                line = inp.readLine();
            }
            catch (IOException e) {
                System.out.println(String.valueOf(String.valueOf(new StringBuffer("unable to read line ").append(r).append(" of ").append(nLines))));
                e.printStackTrace();
                nLines = r;
                break;
            }
            if (line == null) {
                System.out.println(String.valueOf(String.valueOf(new StringBuffer("unexpected null line at ").append(r).append(" of ").append(nLines))));
                nLines = r;
                break;
            }
            if (r + 1 < this.startRow) continue;
            StringTokenizer t = new StringTokenizer(line, " \t\n\r");
            int nTokens = t.countTokens();
            if (nTokens < this.startCol + 2) {
                System.out.println(String.valueOf(String.valueOf(new StringBuffer("startCol=").append(this.startCol).append(" and only ").append(nTokens).append(" and on line ").append(r))));
                return 0;
            }
            String token = null;
            int startIndex = 0;
            for (int tok = 0; tok < this.startCol - 1; ++tok) {
                token = t.nextToken();
                startIndex = line.indexOf(token, startIndex);
                startIndex += token.length();
            }
            String x = t.nextToken();
            String y = t.nextToken();
            String z = t.nextToken();
            if (x == null || y == null || z == null) {
                this.Status.appendText(String.valueOf(String.valueOf(new StringBuffer("** Error in the file, line ").append(r).append(". **\n"))));
                return 0;
            }
            try {
                this.X[r] = (byte)Math.round(Float.parseFloat(x));
                this.Y[r] = (byte)Math.round(Float.parseFloat(y));
                this.Z[r] = (byte)Math.round(Float.parseFloat(z));
            }
            catch (Exception e) {
                this.Status.appendText(String.valueOf(String.valueOf(new StringBuffer("** Error during conversion on line: ").append(r).append(". **\n"))));
                this.Status.appendText(String.valueOf(String.valueOf(new StringBuffer("** Record: ").append(x).append(", ").append(y).append(", ").append(z).append(" was not converted. **\n"))));
                this.X[r] = 0;
                this.Y[r] = 0;
                this.Z[r] = 0;
            }
            String remainder = line.substring(0, startIndex);
            if (remainder.length() > 0) {
                remainder = ",".concat(String.valueOf(String.valueOf(remainder)));
            }
            if (t.hasMoreTokens()) {
                int endIndex = 0;
                endIndex = startIndex + x.length();
                endIndex = line.indexOf(y, endIndex);
                endIndex += y.length();
                endIndex = line.indexOf(z, endIndex);
                endIndex += z.length();
                token = t.nextToken();
                endIndex = line.indexOf(token, endIndex);
                String end = line.substring(endIndex, line.length());
                if (end.length() > 0) {
                    remainder = String.valueOf(String.valueOf(remainder)).concat(String.valueOf(String.valueOf(",".concat(String.valueOf(String.valueOf(end))))));
                }
            }
            if (remainder.equals("")) continue;
            this.remainders[r] = remainder;
        }
        this.Status.appendText("\n");
        return nLines;
    }

    private void updateReadFile(File r) {
        if (r != null) {
            this.LoadFname = r.getPath();
            this.inputLabel.setText(String.valueOf(String.valueOf(new StringBuffer("Input File: ").append(r.getName()).append(" (").append(this.count + 1).append(" of ").append(this.fileCount).append(")"))));
        }
    }

    public File[] getFileList() {
        return this.fileList;
    }

    public void setAppend(boolean b) {
        this.appendData = b;
    }

    public ExtensionFilter[] getFilters() {
        return this.exts;
    }

    public void setStartRowCol(int row, int col) {
        this.startRow = row;
        this.startCol = col;
    }

    public int getStartRow() {
        return this.startRow;
    }

    public int getStartCol() {
        return this.startCol;
    }

    public int getRow(int i) {
        return this.rows[i];
    }

    public int getCol(int i) {
        return this.cols[i];
    }

    public void addText(String s) {
        this.Status.appendText(s);
    }

    private void processFile2() {
        if (this.is_subj_file_open) {
            this.close_save();
        }
        if (this.Records == 0 || this.LoadFname == null) {
            this.Status.appendText("No records to process.  Choose data file.\n\n");
            return;
        }
        String name = this.outputFile.getName();
        try {
            this.fsubj_out = new FileOutputStream(this.outputFile);
            this.subj_out = new PrintStream(new BufferedOutputStream(this.fsubj_out));
            this.is_subj_file_open = true;
            String xyz = "Record Number, X coor, Y coor, Z coor, ";
            String levels = "Level 1, Level 2, Level 3, Level 4, Level5";
            if (this.nearest.isSelected()) {
                this.subj_out.println(String.valueOf(String.valueOf(xyz)).concat(String.valueOf(String.valueOf(levels))));
            } else if (this.range.isSelected()) {
                this.subj_out.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(xyz))).append("Hits, ").append(levels))));
            }
        }
        catch (IOException e) {
            String bad = String.valueOf(String.valueOf(new StringBuffer("Could not open output file: ").append(name).append(".")));
            bad = String.valueOf(String.valueOf(bad)).concat("Check permissions and disk space.\n\n");
            this.Status.appendText(bad);
            return;
        }
        this.progressBar.setMaximum(this.Records);
        this.progressBar.setValue(0);
        this.progressLabel.setText(String.valueOf(String.valueOf(new StringBuffer("Processing ").append(name).append("..."))));
        this.progressDialog.setLocationRelativeTo(this);
        this.progressDialog.pack();
        ProcessorThread2 thread = new ProcessorThread2(this);
        thread.start();
        this.progressDialog.setVisible(true);
    }

    protected void process() {
        long time = System.currentTimeMillis();
        this.viewResults.setEnabled(false);
        String result = "";
        for (int i = 0; i < this.Records; ++i) {
            int increment;
            if (this.single.isSelected()) {
                result = "No label at this point";
                if (this.toFile()) {
                    result = String.valueOf(String.valueOf(result)).concat(",,,,");
                }
                result = String.valueOf(String.valueOf(result)).concat("\n");
                TDLabel label = this.searchPoint(i);
                if (label != null) {
                    result = label.toStr();
                }
            } else if (this.nearest.isSelected()) {
                TDLabel label = this.searchNearestGM(i);
                result = label == null ? "No Gray Matter found,,,,," : String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(label.toStr()))).append(" Range=").append(label.hits[0])));
            } else if (this.range.isSelected()) {
                TDLabel[] array = this.searchRange(i);
                if (array.length > 0) {
                    int j;
                    result = "";
                    for (j = 0; j < array.length - 1; ++j) {
                        result = String.valueOf(String.valueOf(result)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(array[j].hits[1]))).append(",").append(array[j].toStr()).append("\n,,,,"))))));
                    }
                    result = String.valueOf(String.valueOf(result)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(array[j].hits[1]))).append(",").append(array[j].toStr()))))));
                } else {
                    result = "** No data at this location. **";
                }
            }
            if (this.Records <= 1000) {
                increment = 1;
            } else {
                float f = (float)this.Records / 1000.0f;
                increment = (int)Math.ceil(f);
            }
            if (i % increment == 0) {
                this.progressBar.setValue(i);
            }
            this.appendThreadResult(i, result);
        }
        float ftime = (System.currentTimeMillis() - time) / (long)1000;
        this.progressBar.setValue(this.Records);
        this.addText(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.Records))).append(" records were processed in ").append(ftime).append(" sec.\n"))));
        this.addText("Closing output file.\n\n");
        this.close_save();
        this.viewResults.setEnabled(true);
        this.progressDialog.dispose();
    }

    public void close_save() {
        if (!this.is_subj_file_open) {
            return;
        }
        try {
            this.subj_out.flush();
            this.subj_out.close();
            this.is_subj_file_open = false;
            this.fsubj_out.flush();
            this.fsubj_out.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private TDLabel searchPoint(int i) {
        return this.TDdatabase.findLabel(this.X[i], this.Y[i], this.Z[i]);
    }

    private TDLabel searchNearestGM(int i) {
        return this.TDdatabase.nearestGray(this.X[i], this.Y[i], this.Z[i]);
    }

    private TDLabel[] searchRange(int i) {
        return this.TDdatabase.search_range(this.X[i], this.Y[i], this.Z[i], this.getRange());
    }

    private void appendThreadResult(int i, String result) {
        String remainder = this.remainders[i];
        if (remainder == null || !this.appendData) {
            remainder = "";
        }
        String s = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(i))).append(", ").append(this.X[i]).append(", ").append(this.Y[i]).append(", ").append(this.Z[i]).append(", ").append(result).append(remainder)));
        this.subj_out.println(s);
    }

    private void writeToResultFile(String s) {
        if (this.is_subj_file_open) {
            this.subj_out.println(s);
        }
    }

    private int getRange() {
        return this.rangeDistance.getSelectedIndex() + 1;
    }

    private void loadFileFilters() {
        File filter = new File(this.fileFilterFile);
        if (!filter.exists()) {
            System.out.println("TDClient - default filters");
            this.rows = new int[]{1, 1};
            this.cols = new int[]{2, 1};
            this.exts = new ExtensionFilter[2];
            this.exts[0] = new ExtensionFilter("dat", "MIPS Input File");
            this.exts[1] = new ExtensionFilter("txt", "Text Input File");
            return;
        }
        try {
            String line;
            FileReader fr = new FileReader(this.fileFilterFile);
            BufferedReader in = new BufferedReader(fr);
            while ((line = in.readLine()) != null) {
                int count = Integer.parseInt(line);
                this.rows = new int[count];
                this.cols = new int[count];
                this.exts = new ExtensionFilter[count];
                for (int i = 0; i < count; ++i) {
                    StringTokenizer t;
                    line = in.readLine();
                    if (line == null || (t = new StringTokenizer(line, "\t\n\r")).countTokens() < 4) continue;
                    String s = t.nextToken();
                    int r = Integer.parseInt(t.nextToken());
                    int c = Integer.parseInt(t.nextToken());
                    String e = t.nextToken();
                    this.rows[i] = r;
                    this.cols[i] = c;
                    this.exts[i] = new ExtensionFilter(e, s);
                }
                if (line != null) continue;
                break;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

