/*
 * Decompiled with CFR 0.152.
 */
package org.brainmap.talairach;

public class TranslateToTalairach88 {
    private float[] coord = new float[3];
    private float[] trans = new float[3];
    private String atlas;
    private String origin;
    private String error;

    public TranslateToTalairach88() {
        this.atlas = "";
        this.origin = "";
        this.coord = new float[]{0.0f, 0.0f, 0.0f};
    }

    public TranslateToTalairach88(float[] c, String a, String o) {
        this.setAtlas(a);
        this.setOrigin(o);
        this.coord = new float[c.length];
        for (int i = 0; i < c.length; ++i) {
            this.coord[i] = c[i];
        }
        this.trans = this.translateCoordinates();
    }

    public void setAtlas(String a) {
        this.atlas = a;
    }

    public void setOrigin(String o) {
        this.origin = o;
    }

    public void setCoordinates(float[] c) {
        for (int i = 0; i < c.length; ++i) {
            this.coord[i] = c[i];
        }
    }

    public float[] getTranslatedCoordinates() {
        return this.trans;
    }

    public String getErrorMessage() {
        return this.error;
    }

    public float[] translateCoordinates() {
        float[] newCoordinates = new float[3];
        this.error = "Brain Used is ".concat(String.valueOf(String.valueOf(this.atlas)));
        if (this.atlas.equals("Talairach 1988")) {
            newCoordinates[0] = this.coord[0];
            newCoordinates[1] = this.coord[1];
            newCoordinates[2] = this.coord[2];
        } else if (this.atlas.equals("Talairach 1967:HD5")) {
            newCoordinates[0] = new Double((double)this.coord[0] * 1.0303030303030303).intValue();
            newCoordinates[1] = new Double((double)this.coord[1] * 1.048780487804878).intValue();
            newCoordinates[2] = new Double((double)this.coord[2] * 1.0535714285714286).intValue();
            if (this.origin.equals("Mid AC-PC")) {
                newCoordinates[1] = newCoordinates[1] - (float)7;
            } else if (this.origin.equals("AC")) {
                newCoordinates[1] = newCoordinates[1] - (float)13;
            } else {
                this.error = "Do not understand the origin defined ".concat(String.valueOf(String.valueOf(this.origin)));
            }
        } else if (this.atlas.equals("Talairach 1967:HD6")) {
            newCoordinates[0] = new Double((double)this.coord[0] * 0.9315068493150684).intValue();
            newCoordinates[1] = new Double((double)this.coord[1] * 1.036144578313253).intValue();
            newCoordinates[2] = new Double((double)this.coord[2] * 1.063063063063063).intValue();
            if (this.origin.equals("Mid AC-PC")) {
                newCoordinates[1] = newCoordinates[1] - (float)12;
            } else if (this.origin.equals("AC")) {
                newCoordinates[1] = newCoordinates[1] - (float)14;
            } else {
                this.error = "Do not understand the origin defined ".concat(String.valueOf(String.valueOf(this.origin)));
            }
        } else if (this.atlas.equals("Talairach 1967:s34d")) {
            newCoordinates[0] = new Double((double)this.coord[0] * 0.9855072463768116).intValue();
            newCoordinates[1] = new Double((double)this.coord[1] * 1.1168831168831168).intValue();
            newCoordinates[2] = new Double((double)this.coord[2] * 1.0172413793103448).intValue();
            if (this.origin.equals("Mid AC-PC")) {
                newCoordinates[1] = newCoordinates[1] - (float)7;
            } else if (this.origin.equals("AC")) {
                newCoordinates[1] = newCoordinates[1] - (float)8;
            } else {
                this.error = "Do not understand the origin defined ".concat(String.valueOf(String.valueOf(this.origin)));
            }
        } else if (this.atlas.equals("Talairach 1967:s39g")) {
            newCoordinates[0] = new Double((double)this.coord[0] * 0.9855072463768116).intValue();
            newCoordinates[1] = new Double((double)this.coord[1] * 1.029940119760479).intValue();
            newCoordinates[2] = new Double((double)this.coord[2] * 1.063063063063063).intValue();
            if (this.origin.equals("Mid AC-PC")) {
                newCoordinates[1] = newCoordinates[1] - (float)10;
            } else if (this.origin.equals("AC")) {
                newCoordinates[1] = (float)((double)newCoordinates[1] - 14.5);
            } else {
                this.error = "Do not understand the origin defined ".concat(String.valueOf(String.valueOf(this.origin)));
            }
        } else if (this.atlas.equals("Talairach 1967:vf48")) {
            newCoordinates[0] = new Double((double)this.coord[0] * 0.9315068493150684).intValue();
            newCoordinates[1] = new Double((double)this.coord[1] * 1.029940119760479).intValue();
            newCoordinates[2] = new Double((double)this.coord[2] * 0.9915966386554622).intValue();
            if (this.origin.equals("Mid AC-PC")) {
                newCoordinates[1] = newCoordinates[1] - (float)8;
            } else if (this.origin.equals("AC")) {
                newCoordinates[1] = (float)((double)newCoordinates[1] - 14.5);
            } else {
                this.error = "Do not understand the origin defined ".concat(String.valueOf(String.valueOf(this.origin)));
            }
        } else if (this.atlas.equals("Talairach 1967:vf25")) {
            newCoordinates[0] = new Double((double)this.coord[0] * 0.8774193548387097).intValue();
            newCoordinates[1] = new Double((double)this.coord[1] * 1.036144578313253).intValue();
            newCoordinates[2] = new Double((double)this.coord[2] * 0.9833333333333333).intValue();
            if (this.origin.equals("Mid AC-PC")) {
                newCoordinates[1] = newCoordinates[1] - (float)10;
            } else if (this.origin.equals("AC")) {
                newCoordinates[1] = newCoordinates[1] - (float)14;
            } else {
                this.error = "Do not understand the origin defined ".concat(String.valueOf(String.valueOf(this.origin)));
            }
        } else if (this.atlas.equals("MNI305")) {
            float x = this.coord[0];
            float y = this.coord[1];
            float z = this.coord[2];
            newCoordinates[0] = 0.925f * x + 0.0025f * y - 0.0127f * z - 1.94f;
            newCoordinates[1] = -0.0051f * x + 0.9314f * y - 0.0871f * z - 0.93f;
            newCoordinates[2] = 0.0162f * x - 0.0886f * y + 0.893f * z + 5.04f;
            System.out.println("using the new transform");
            System.out.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(newCoordinates[0]))).append(" ").append(newCoordinates[1]).append(" ").append(newCoordinates[2]))));
        } else {
            this.error = String.valueOf(String.valueOf(new StringBuffer("No location translation routine found for the brain, ").append(this.atlas).append(".  Using given coordinates.")));
            newCoordinates[0] = this.coord[0];
            newCoordinates[1] = this.coord[1];
            newCoordinates[2] = this.coord[2];
        }
        return newCoordinates;
    }
}

