/*
 * Decompiled with CFR 0.152.
 */
package org.brainmap.util;

public class ByteConverter {
    public static int BIG_ENDIAN = 0;
    public static int LITTLE_ENDIAN = 1;

    public static short getShort(byte[] b, int i) {
        return ByteConverter.bytes_to_short(b, i, BIG_ENDIAN);
    }

    public static int getInt(byte[] b, int i) {
        return ByteConverter.bytes_to_int(b, i, BIG_ENDIAN);
    }

    public static long getLong(byte[] b, int i) {
        return ByteConverter.bytes_to_long(b, i);
    }

    public static float getFloat(byte[] b, int i) {
        return ByteConverter.bytes_to_float(b, i, BIG_ENDIAN);
    }

    public static double getDouble(byte[] b, int i) {
        return ByteConverter.bytes_to_double(b, i);
    }

    public static char getChar(byte b) {
        return ByteConverter.byte_to_char(b);
    }

    public static String getString(byte[] b, int i, int size) {
        return ByteConverter.bytes_to_string(b, i, size);
    }

    public static short swapShort(byte[] b, int i) {
        return ByteConverter.bytes_to_short(b, i, LITTLE_ENDIAN);
    }

    public static int swapInt(byte[] b, int i) {
        return ByteConverter.bytes_to_int(b, i, LITTLE_ENDIAN);
    }

    public static float swapFloat(byte[] b, int i) {
        return ByteConverter.bytes_to_float(b, i, LITTLE_ENDIAN);
    }

    public static byte[] getBytes(short s) {
        return ByteConverter.short_to_bytes(s);
    }

    public static byte[] getBytes(int i) {
        return ByteConverter.int_to_bytes(i);
    }

    public static byte[] getBytes(long i) {
        return ByteConverter.long_to_bytes(i);
    }

    public static byte[] getBytes(float i) {
        return ByteConverter.float_to_bytes(i);
    }

    public static byte[] getBytes(double i) {
        return ByteConverter.double_to_bytes(i);
    }

    public static byte[] getBytes(float[] f) {
        byte[] b = new byte[4 * f.length];
        for (int i = 0; i < f.length; ++i) {
            byte[] fl = ByteConverter.float_to_bytes(f[i]);
            for (int j = 0; j < 4; ++j) {
                b[i * 4 + j] = fl[j];
            }
        }
        return b;
    }

    public static String toHex(byte[] data, int index) {
        if (data == null || index < 0 || index >= data.length) {
            return null;
        }
        String hex = "";
        int mask = 15;
        for (int i = index; i < data.length && i < index + 4; ++i) {
            byte b = (byte)(data[i] >> 4 & mask);
            hex = String.valueOf(String.valueOf(hex)).concat(String.valueOf(String.valueOf(ByteConverter.getHex(b))));
            b = (byte)(data[i] & mask);
            hex = String.valueOf(String.valueOf(hex)).concat(String.valueOf(String.valueOf(ByteConverter.getHex(b))));
            if ((i - index) % 4 != 0) continue;
            hex = String.valueOf(String.valueOf(hex)).concat(" ");
        }
        return hex;
    }

    public static char getHex(byte b) {
        switch (b) {
            case 0: {
                return '0';
            }
            case 1: {
                return '1';
            }
            case 2: {
                return '2';
            }
            case 3: {
                return '3';
            }
            case 4: {
                return '4';
            }
            case 5: {
                return '5';
            }
            case 6: {
                return '6';
            }
            case 7: {
                return '7';
            }
            case 8: {
                return '8';
            }
            case 9: {
                return '9';
            }
            case 10: {
                return 'a';
            }
            case 11: {
                return 'b';
            }
            case 12: {
                return 'c';
            }
            case 13: {
                return 'd';
            }
            case 14: {
                return 'e';
            }
            case 15: {
                return 'f';
            }
        }
        System.out.println(String.valueOf(String.valueOf(new StringBuffer("getHex(").append(b).append(")..."))));
        return '~';
    }

    private static byte[] short_to_bytes(short a) {
        byte[] b = new byte[]{(byte)(a >> 8 & 0xFF), (byte)(a >> 0 & 0xFF)};
        return b;
    }

    private static short bytes_to_short(byte[] b, int i, int endian) {
        if (b.length < i + 2) {
            System.out.println("Error: Reading past bounds of byte array.");
            System.exit(0);
        }
        short val = endian == BIG_ENDIAN ? (short)((b[i + 1] & 0xFF) << 0 | (b[i + 0] & 0xFF) << 8) : (short)((b[i + 0] & 0xFF) << 0 | (b[i + 1] & 0xFF) << 8);
        return val;
    }

    private static byte[] int_to_bytes(int a) {
        byte[] b = new byte[]{(byte)(a >> 24 & 0xFF), (byte)(a >> 16 & 0xFF), (byte)(a >> 8 & 0xFF), (byte)(a >> 0 & 0xFF)};
        return b;
    }

    private static int bytes_to_int(byte[] b, int i, int endian) {
        if (b.length < i + 4) {
            System.out.println("Error: Reading past bounds of byte array.");
            System.exit(0);
        }
        int val = endian == BIG_ENDIAN ? (b[i + 3] & 0xFF) << 0 | (b[i + 2] & 0xFF) << 8 | (b[i + 1] & 0xFF) << 16 | (b[i + 0] & 0xFF) << 24 : (b[i + 0] & 0xFF) << 0 | (b[i + 1] & 0xFF) << 8 | (b[i + 2] & 0xFF) << 16 | (b[i + 3] & 0xFF) << 24;
        return val;
    }

    private static byte[] float_to_bytes(float f) {
        int a = Float.floatToIntBits(f);
        return ByteConverter.int_to_bytes(a);
    }

    private static float bytes_to_float(byte[] b, int i, int endian) {
        int a = ByteConverter.bytes_to_int(b, i, endian);
        return Float.intBitsToFloat(a);
    }

    private static byte[] long_to_bytes(long a) {
        byte[] b = new byte[]{(byte)(a >> 56 & (long)255), (byte)(a >> 48 & (long)255), (byte)(a >> 40 & (long)255), (byte)(a >> 32 & (long)255), (byte)(a >> 24 & (long)255), (byte)(a >> 16 & (long)255), (byte)(a >> 8 & (long)255), (byte)(a >> 0 & (long)255)};
        return b;
    }

    private static long bytes_to_long(byte[] b, int i) {
        if (b.length < i + 8) {
            System.out.println("Error: Reading past bounds of byte array.");
            System.exit(0);
        }
        long val = (b[i + 7] & 0xFF) << 0 | (b[i + 6] & 0xFF) << 8 | (b[i + 5] & 0xFF) << 16 | (b[i + 4] & 0xFF) << 24 | (b[i + 3] & 0xFF) << 32 | (b[i + 2] & 0xFF) << 40 | (b[i + 1] & 0xFF) << 48 | (b[i + 0] & 0xFF) << 56;
        return val;
    }

    private static byte[] double_to_bytes(double f) {
        long a = Double.doubleToLongBits(f);
        return ByteConverter.long_to_bytes(a);
    }

    private static double bytes_to_double(byte[] b, int i) {
        long a = ByteConverter.bytes_to_long(b, i);
        return Double.longBitsToDouble(a);
    }

    private static String bytes_to_string(byte[] b, int i, int size) {
        char c;
        if (b.length < i + size) {
            System.out.println("Error: Reading past bounds of byte array.");
            System.exit(0);
        }
        String s = "";
        for (int j = 0; j < size && (c = ByteConverter.byte_to_char(b[i + j])) != '\u0000'; ++j) {
            s = String.valueOf(String.valueOf(s)).concat(String.valueOf(String.valueOf(c)));
        }
        return s;
    }

    private static char byte_to_char(byte b) {
        switch (b) {
            case 0: {
                return '\u0000';
            }
            case 1: {
                return '\u0001';
            }
            case 2: {
                return '\u0002';
            }
            case 3: {
                return '\u0003';
            }
            case 4: {
                return '\u0004';
            }
            case 5: {
                return '\u0005';
            }
            case 6: {
                return '\u0006';
            }
            case 7: {
                return '\u0007';
            }
            case 8: {
                return '\b';
            }
            case 9: {
                return '\t';
            }
            case 10: {
                return '\n';
            }
            case 11: {
                return '\u000b';
            }
            case 12: {
                return '\f';
            }
            case 13: {
                return '\r';
            }
            case 14: {
                return '\u000e';
            }
            case 15: {
                return '\u000f';
            }
            case 16: {
                return '\u0010';
            }
            case 17: {
                return '\u0011';
            }
            case 18: {
                return '\u0012';
            }
            case 19: {
                return '\u0013';
            }
            case 20: {
                return '\u0014';
            }
            case 21: {
                return '\u0015';
            }
            case 22: {
                return '\u0016';
            }
            case 23: {
                return '\u0017';
            }
            case 24: {
                return '\u0018';
            }
            case 25: {
                return '\u0019';
            }
            case 26: {
                return '\u001a';
            }
            case 27: {
                return '\u001b';
            }
            case 28: {
                return '\u001c';
            }
            case 29: {
                return '\u001d';
            }
            case 30: {
                return '\u001e';
            }
            case 31: {
                return '\u001f';
            }
            case 32: {
                return ' ';
            }
            case 33: {
                return '!';
            }
            case 34: {
                return '\"';
            }
            case 35: {
                return '#';
            }
            case 36: {
                return '$';
            }
            case 37: {
                return '%';
            }
            case 38: {
                return '&';
            }
            case 39: {
                return '\'';
            }
            case 40: {
                return '(';
            }
            case 41: {
                return ')';
            }
            case 42: {
                return '*';
            }
            case 43: {
                return '+';
            }
            case 44: {
                return ',';
            }
            case 45: {
                return '-';
            }
            case 46: {
                return '.';
            }
            case 47: {
                return '/';
            }
            case 48: {
                return '0';
            }
            case 49: {
                return '1';
            }
            case 50: {
                return '2';
            }
            case 51: {
                return '3';
            }
            case 52: {
                return '4';
            }
            case 53: {
                return '5';
            }
            case 54: {
                return '6';
            }
            case 55: {
                return '7';
            }
            case 56: {
                return '8';
            }
            case 57: {
                return '9';
            }
            case 58: {
                return ':';
            }
            case 59: {
                return ';';
            }
            case 60: {
                return '<';
            }
            case 61: {
                return '=';
            }
            case 62: {
                return '>';
            }
            case 63: {
                return '?';
            }
            case 64: {
                return '@';
            }
            case 65: {
                return 'A';
            }
            case 66: {
                return 'B';
            }
            case 67: {
                return 'C';
            }
            case 68: {
                return 'D';
            }
            case 69: {
                return 'E';
            }
            case 70: {
                return 'F';
            }
            case 71: {
                return 'G';
            }
            case 72: {
                return 'H';
            }
            case 73: {
                return 'I';
            }
            case 74: {
                return 'J';
            }
            case 75: {
                return 'K';
            }
            case 76: {
                return 'L';
            }
            case 77: {
                return 'M';
            }
            case 78: {
                return 'N';
            }
            case 79: {
                return 'O';
            }
            case 80: {
                return 'P';
            }
            case 81: {
                return 'Q';
            }
            case 82: {
                return 'R';
            }
            case 83: {
                return 'S';
            }
            case 84: {
                return 'T';
            }
            case 85: {
                return 'U';
            }
            case 86: {
                return 'V';
            }
            case 87: {
                return 'W';
            }
            case 88: {
                return 'X';
            }
            case 89: {
                return 'Y';
            }
            case 90: {
                return 'Z';
            }
            case 91: {
                return '[';
            }
            case 92: {
                return '\\';
            }
            case 93: {
                return ']';
            }
            case 94: {
                return '^';
            }
            case 95: {
                return '_';
            }
            case 96: {
                return '`';
            }
            case 97: {
                return 'a';
            }
            case 98: {
                return 'b';
            }
            case 99: {
                return 'c';
            }
            case 100: {
                return 'd';
            }
            case 101: {
                return 'e';
            }
            case 102: {
                return 'f';
            }
            case 103: {
                return 'g';
            }
            case 104: {
                return 'h';
            }
            case 105: {
                return 'i';
            }
            case 106: {
                return 'j';
            }
            case 107: {
                return 'k';
            }
            case 108: {
                return 'l';
            }
            case 109: {
                return 'm';
            }
            case 110: {
                return 'n';
            }
            case 111: {
                return 'o';
            }
            case 112: {
                return 'p';
            }
            case 113: {
                return 'q';
            }
            case 114: {
                return 'r';
            }
            case 115: {
                return 's';
            }
            case 116: {
                return 't';
            }
            case 117: {
                return 'u';
            }
            case 118: {
                return 'v';
            }
            case 119: {
                return 'w';
            }
            case 120: {
                return 'x';
            }
            case 121: {
                return 'y';
            }
            case 122: {
                return 'z';
            }
            case 123: {
                return '{';
            }
            case 124: {
                return '|';
            }
            case 125: {
                return '}';
            }
            case 126: {
                return '~';
            }
            case 127: {
                return '\u007f';
            }
        }
        return '\u0000';
    }

    private static String binary_to_ascii(String binary) {
        String filtered = "";
        for (int i = 0; i < binary.length(); ++i) {
            char c = binary.charAt(i);
            if (c == '1') {
                filtered = String.valueOf(String.valueOf(filtered)).concat(String.valueOf(String.valueOf(c)));
            }
            if (c != '0') continue;
            filtered = String.valueOf(String.valueOf(filtered)).concat(String.valueOf(String.valueOf(c)));
        }
        if (!filtered.equals(binary)) {
            System.out.println(filtered);
            System.out.println(binary);
        }
        binary = filtered;
        int nBytes = filtered.length() / 8;
        if (nBytes * 8 < filtered.length()) {
            System.out.println("incomplete byte");
            ++nBytes;
        }
        byte[] bytes = new byte[nBytes];
        for (int i = 0; i < binary.length(); i += 8) {
            String sByte = binary.substring(i, i + 8);
            byte b = 0;
            for (int j = 0; j < 8; ++j) {
                char c = sByte.charAt(j);
                if (c == '1') {
                    b = (byte)(b | 1);
                }
                if (j == 7) continue;
                b = (byte)(b << 1);
            }
            bytes[i / 8] = b;
        }
        char[] chars = new char[nBytes];
        for (int i = 0; i < chars.length; ++i) {
            chars[i] = ByteConverter.byte_to_char(bytes[i]);
        }
        String s = new String(chars);
        return s;
    }

    private static void stupid() {
        String s1 = "010010010010000001110011011010000110111101110000011100000110010101100100001000000110000101110100001000000101010001101000011010010110111001101011010001110110010101100101011010110010000001101111011011100010000001000001011100000111001001101001011011000010000001000110011011110110111101101100011100110010000001000100011000010111100100101100001000000110000101101110011001000010000001100001011011000110110000100000010010010010000001100111011011110111010000100000011101110110000101110011001000000111010001101000011010010111001100100000011011000110111101110101011100110111100100100000011100110110100001101001011100100111010000100001";
        String s2 = ByteConverter.binary_to_ascii(s1);
        System.out.println(s2);
    }

    public static void main(String[] args) {
        ByteConverter bc = new ByteConverter();
        ByteConverter.stupid();
    }
}

