/*
 * Decompiled with CFR 0.152.
 */
package org.brainmap.util;

import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class FloatDocument
extends PlainDocument {
    int maxCharacters;
    boolean integer = false;

    public FloatDocument(int size) {
        this.maxCharacters = size;
    }

    public void insertString(int offset, String string, AttributeSet attributes) throws BadLocationException {
        block14: {
            float f;
            if (this.getLength() + string.length() >= this.maxCharacters) {
                int roomLeft = this.maxCharacters - this.getLength();
                if (roomLeft < 0) {
                    roomLeft = 0;
                }
                string = string.substring(0, roomLeft);
            }
            String temp = this.getText(0, this.getLength());
            String full = temp.substring(0, offset);
            full = String.valueOf(String.valueOf(full)).concat(String.valueOf(String.valueOf(string)));
            full = String.valueOf(String.valueOf(full)).concat(String.valueOf(String.valueOf(temp.substring(offset, temp.length()))));
            if (this.integer) {
                try {
                    int i = Integer.parseInt(full);
                    super.insertString(offset, string, attributes);
                }
                catch (Exception i) {
                    // empty catch block
                }
                return;
            }
            try {
                f = Float.parseFloat(full);
            }
            catch (Exception e) {
                f = Float.NaN;
            }
            if (!Float.isNaN(f)) {
                super.insertString(offset, string, attributes);
                return;
            }
            String okay = "";
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (Character.isDigit(c)) {
                    okay = String.valueOf(String.valueOf(okay)).concat(String.valueOf(String.valueOf(c)));
                    continue;
                }
                if (c == '.' && okay.indexOf(".") == -1) {
                    okay = String.valueOf(String.valueOf(okay)).concat(String.valueOf(String.valueOf(c)));
                    continue;
                }
                if (c == '-') {
                    if (i == 0 && offset == 0 && okay.indexOf("-") == -1) {
                        okay = String.valueOf(String.valueOf(okay)).concat(String.valueOf(String.valueOf(c)));
                        continue;
                    }
                    String total = String.valueOf(String.valueOf(this.getText(0, this.getLength()))).concat(String.valueOf(String.valueOf(okay)));
                    if (total.length() < 1) continue;
                    char last = total.charAt(total.length() - 1);
                    if (last == 'e' || last == 'E') {
                        okay = String.valueOf(String.valueOf(okay)).concat(String.valueOf(String.valueOf(c)));
                        continue;
                    }
                }
                if (c != 'e' && c != 'E') continue;
                okay = String.valueOf(String.valueOf(okay)).concat(String.valueOf(String.valueOf(c)));
            }
            if (okay.length() <= 0) break block14;
            super.insertString(offset, okay, attributes);
        }
    }

    public void remove(int offset, int length) throws BadLocationException {
        super.remove(offset, length);
    }

    public float getFloatValue() {
        String text;
        float f = Float.NaN;
        try {
            text = this.getText(0, this.getLength());
        }
        catch (Exception e) {
            float f2 = 0.0f;
            return f2;
        }
        if (text.equals("")) {
            return 0.0f;
        }
        try {
            f = new Float(text).floatValue();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Problems in FloatDocument.getFloatValue()");
            System.out.println("I didn't monitor the text well enough.  Poop.");
        }
        return f;
    }

    public void setInteger() {
        this.integer = true;
    }
}

