/*
 * Decompiled with CFR 0.152.
 */
package org.brainmap.util;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.StringTokenizer;

public class OpenResource {
    private static InputStream getStream(Class c, String path) throws Exception {
        if (new File(path).exists()) {
            return new FileInputStream(path);
        }
        String sep = System.getProperty("file.separator");
        if (path.indexOf(sep) > 0) {
            StringTokenizer st = new StringTokenizer(path, sep);
            while (st.hasMoreTokens()) {
                path = st.nextToken();
            }
        }
        return c.getResourceAsStream(path);
    }

    public static BufferedReader openReader(Class c, String path) {
        try {
            InputStream in = OpenResource.getStream(c, path);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(in));
            return bufferedReader;
        }
        catch (Throwable t) {
            System.out.println("org.brainmap.util.OpenResource - ".concat(String.valueOf(String.valueOf(t.getMessage()))));
            System.out.println("openReader: can't open ".concat(String.valueOf(String.valueOf(path))));
            BufferedReader bufferedReader = null;
            return bufferedReader;
        }
    }

    public static BufferedInputStream openStream(Class c, String path) {
        try {
            InputStream in = OpenResource.getStream(c, path);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(in);
            return bufferedInputStream;
        }
        catch (Throwable t) {
            System.out.println("org.brainmap.util.OpenResource - ".concat(String.valueOf(String.valueOf(t.getMessage()))));
            System.out.println("openStream: can't open ".concat(String.valueOf(String.valueOf(path))));
            BufferedInputStream bufferedInputStream = null;
            return bufferedInputStream;
        }
    }
}

