function  [datatype,dataname,bitdepth] = wfu_datatype(X)

%------------------------------------------------------------------
%Determines the datatype for writing analyze files %------------------------------------------------------------------

%type=X(1);
%datatypes=[	0		;...
%		0		;...
%		0		;...
%		2		;...
%		4		;...
%		8		;...
%		16		;...
%		16		;...
%		32		;...
%		32];

%datanames={	'uint8'		;...
%		'uint16'	;...
%		'uint32'	;...
%		'int8'		;...	%byte
%		'int16'		;...    %int
%		'int32'		;...    %long
%		'float32'	;...    %
%		'single'	;...	%
%		'float64'	;...	%
%		'double'	};

datatypes=[	2		;...
		4		;...
		8		;...
		16		;...
		64  	;...
		130		;...
		132		;...
		136		;...
		16		;...
		32      ;...
        16];

datanames={	'uint8'		;...
		'int16'	;...
		'int32'	;...
		'float'		;...	%byte
		'double'	;...    %int
		'int8'		;...    %long
		'uint16'	;...    %
		'uint32'	;...	%
		'float32'	;...	%
        'float64',  ;...
		'single'	};


for i=1:length(datanames) 
	if isa(X,char(datanames(i))) 
		break; 
	end;
end;

datatype=datatypes(i);
dataname=wfu_spm_type(datatype);
bitdepth=wfu_spm_type(datatype,'bits');


