function [aheader , volumein] = wfu_read_header(filename)

%---------------------------------------------------------
%Will read analyze/nifti images through SPM Calls in SPM5.
%Contiue to use WFU code for SPM99 and SPM2.
%
%Written as a replacement for wfu_read_analyze_header
%which does not read nifti.  This will require
%wfu_pickatlas to use SPM.
%---------------------------------------------------------

fileType = wfu_check_nifti(filename);
if (fileType == 1) %File is nifti
	[aheader, volumein] = wfu_read_nifti_header(filename);
elseif(fileType==0)
  [aheader, volumein] = wfu_read_analyze_header(filename);
else
	error(sprintf('File is of unknown type: %s',filename));
	aheader=null(1);
	volumeing=null(1);
end

