function [aheader , volumein] = wfu_write_header(volumein, aheader, outfilename,mat,M)
% Usage: [aheader , volumein] = wfu_write_header(volumein, aheader, outfilename,mat,M)
%
% ---------------------------------------------------------
% Will write nifti images through SPM Calls in SPM5.
% Contiue to write ANALYZE though WFU code for SPM99 and SPM2.
%
% Written as a replacement for wfu_write_analyze_header
% which does not write nifti.  This will require
% wfu_pickatlas to use SPM.
% ---------------------------------------------------------

%for variables that are dependent on SPM version:
spmVersion = wfu_get_ver;
switch spmVersion
  case {'SPM2','SPM99'}
    %% Use our SPM99/2 code to do the header and volume reads
    %disp('SPM99 or SPM2 detected');
    wfu_write_analyze_header(volumein, aheader, outfilename,mat,M);
  case {'SPM5';'lite'}
    %disp('SPM5 detected');
    %------------------------------------
    %Set V fields
    %------------------------------------
disp('CHANGE ME!  I MIGHT BE nii.')
    v.fname = strcat(outfilename,'.img');
%    v.mat = aheader.magnet_transform.value;
    v.mat = M;
    v.dim = [aheader.x_dim.value aheader.y_dim.value aheader.z_dim.value];
    v.dt = [aheader.datatype.value 1];
    v.pinfo = [aheader.scale.value; 0; 0];
    %v.n = 
    v.descrip = char(aheader.descrip.value);
    
    v5 = spm_create_vol(v);
    for i = 1:v5.dim(3)
        spm_write_plane(v5, volumein(:,:,i), i); 
    end
   
%     %*********************************************************
%     %write a .mat file with magnet_transform and landmark info
%     %*********************************************************
%     landmark = 1;
%     if exist('mat')
%     	matFilename = [outfilename,'.mat'];
%     	if ~exist('M'), M = mat; end
%     	save(matFilename,'M','mat','landmark');
%     end
  otherwise
    %Unable to determin SPM version
    %continue from switch along way above
    disp('Unable to find SPM version.  Defaulting to internal functions.  Writing in ANALYZE format.');
    wfu_write_analyze_header(volumein, aheader, outfilename,mat,M);
end
