function wfu_require_tbx_common
% wfu_require_tbx_common
%
% Function checks the path for wfu_tbx_common directory.  If not found it
% tries to add it.  Function errors out if tbx_common cannot be sourced.
%
% This file lives in the wfu_tbx_common directory, but should be copied
% back to the directory of the toolbox for which it is needed.
%
% Any changes should be ported back to the wfu_tbx_common directory
% version!!!

fileOnlyInCommonToolBox='wfu_check_nifti.m';

if exist(fileOnlyInCommonToolBox)==2
  return;
else
  tbx=which('wfu_pickatlas.m');
  if isempty(tbx)
    tbx=which('wfu_results.m');
  end
  if isempty(tbx)
    tbx=which('wfu_roi.m');
  end
  if isempty(tbx)
    tbx=which('wfu_require_tbx_common.m');
  end
  
  if isempty(tbx)
    error('Unable to find a wfu toolbox to base wfu_tbx_common off of.  Please manually add to path.\n');
  end
  
  [p f e j] = fileparts(tbx); %removes wfu_pickatklas.m
  [p f e j] = fileparts(p);   %removes wfu_pickatklas directory
  tbxPath=fullfile(p,'wfu_tbx_common');
  
  if exist(tbxPath,'dir')==7
    fprintf('Adding %s to path.\n',tbxPath);
    addpath(fullfile(p,'wfu_tbx_common'));
  end
  
  if exist(fileOnlyInCommonToolBox)~=2
    error('Unable to add %s OR find %s which is in wfu_tbx_common\n',fullfile(p,'wfu_tbx_common'),fileOnlyInCommonToolBox);
  end
end