function wfu_require_tbxs(tbxs)
% wfu_require_tbxs(tbxs)
%
% checks path for a tbx(s) (assuming toolboxes have a function of the same
% name as the path).  If not found, it tries to add it, assuming the
% typical spm structure of toolboxes all under one directory.

if nargin < 1, return; end;
if ischar(tbxs), tbxs=cellstr(tbxs); end;

for i=1:length(tbxs)
  if exist(tbxs{i},'file')==2
    continue;
  else
    tbxPath=fileparts(which(mfilename)); %remove filename (wfu_require_tbxs.m)
    tbxPath=fileparts(tbxPath); %remove first path (wfu_tbx_common)
    potentialPath=fullfile(tbxPath,tbxs{i});
    if exist(potentialPath,'dir')==7
      fprintf('adding %s to path\n',potentialPath);
      addpath(potentialPath);
    else
      disp('!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!');
      disp('!!! Unable to find toolbox:   !!!');
      fprintf('!!! %-25s !!!\n',tbxs{i});
      disp('!!! Please add path manually. !!!');
      disp('!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!');
      error('missing toolbox: %s',tbxs{i});
    end
  end
end