#include "itkImage.h"
#include "itkImageFileReader.h"
#include "itkImageFileWriter.h"
#include "itkVariableLengthVector.h"
#include "itkRGBPixel.h"
#include <VolumeCounter.h>
#include <FiberSegmentExtractor.h>
#include <iostream>
#include <fstream>
#include <vtkPolyDataReader.h>
#include <Counter.h>
#include <Entropy.h>
#include <Stats.h>
#include <FiberOrientation.h>

//Filenames used
std::string dwiImgFileName, faImgFileName, maskImgFileName, idwiMaskImgFileName, vCounterImgFileName, fiberTractsImgFileName;
std::string enImgFileName, foImgFileName, dImgFileName, fsImgFileName, percent_75_img, combined_result, new_combined_result;
std::string emdImgFileName, enFDImgFileName, qcImgFileName;
std::string ncc_fs_fo_img, ncc_fs_en_img, ncc_fo_en_img;
std::string entropy_erf_img, fs_erf_img, emd_erf_img, cubic_root_img;

//Function declaration
int computeVolumeCounter(const char *, const char *);
void computeFAImageParams(const char *);
void readFOImage(const char *);
std::string fillImgFileNames(const char *, const char *);

int main(int argc, char **argv){
    std::string path;
    const char* env = "local";
    if(argc < 3){
        output("Using default dataset 11053_0816 and default environment 'local'");
        path = fillImgFileNames("11053_0816", env);
    }else{
        path = fillImgFileNames(argv[1], argv[2]);
    }
    FiberOrientation fo(fiberTractsImgFileName, dwiImgFileName, faImgFileName, idwiMaskImgFileName);
    //FiberOrientation fo(dwiImgFileName, faImgFileName, idwiMaskImgFileName);
    /*
    fo.computeVolumeCounter(vCounterImgFileName);

    Entropy e(vCounterImgFileName);
    e.writeToGrayscaleImage(enImgFileName);

    fo.computeFiberSegmentsPerVoxelImage(fsImgFileName);
    fo.writeFiberOrientationsPerVoxelTextFile(foImgFileName);
    fo.writeFiberDistancesPerVoxelTextFile(vCounterImgFileName, foImgFileName, dImgFileName); 
    */

    Stats s(faImgFileName, enImgFileName, idwiMaskImgFileName);
    /*
    std::string maskTextFile = path + "mask.txt";
    s.writeImageToTextFile(idwiMaskImgFileName, maskTextFile);
    */

    fo.computeEarthMoversDistanceImage(dImgFileName, enImgFileName, emdImgFileName, path);
    s.computeErfValuedImage(enImgFileName, entropy_erf_img, "en");
    s.computeErfValuedImage(fsImgFileName, fs_erf_img, "fs");
    s.computeErfValuedImage(emdImgFileName, emd_erf_img, "emd");
    s.computeCombinedResult(entropy_erf_img, fs_erf_img, emd_erf_img, cubic_root_img);

    return 0;   
} 

std::string fillImgFileNames(const char* dataName, const char* env){
    std::stringstream s;
    std::string pathPrefix, filePrefix, temp, path;
    if(strcmp(env, "bass_normal") == 0){
        pathPrefix = "/home/ravikirn/dataset/results/normal/";
    }else if(strcmp(env, "bass_krabbe") == 0){
        pathPrefix = "/home/ravikirn/dataset/results/krabbe/";
    }else if(strcmp(env, "bass_krabbe_temp") == 0){
        pathPrefix = "/home/ravikirn/dataset/results/krabbe_temp/";
    }else if(strcmp(env, "bass_normal_temp") == 0){
        pathPrefix = "/home/ravikirn/dataset/results/normal_temp/";
    }else if(strcmp(env, "local") == 0){
        pathPrefix = "/media/Core/Research/result/";
    }else if(strcmp(env, "local_krabbe") == 0){
        pathPrefix = "/media/Data2/Research/result/krabbe/";
    }else if(strcmp(env, "local_normal") == 0){
        pathPrefix = "/media/Data2/Research/result/normal/";
    }else if(strcmp(env, "local_normal_temp") == 0){
        pathPrefix = "/media/Data2/Research/result/normal_temp/";
    }else if(strcmp(env, "local_krabbe_temp") == 0){
        pathPrefix = "/media/Data2/Research/result/krabbe_temp/";
    }else{
        output("Invalid Environment specified, exiting");
        exit(0);
    }
    filePrefix = dataName;
    char datasetDir[] = "";
    if(strcmp(env, "local") == 0){
        int i = 0;
        while(dataName[i] != '_'){
            datasetDir[i] = dataName[i];
            i++;
        }
        datasetDir[i] = '\0';
        s<<pathPrefix<<datasetDir<<"/"<<filePrefix<<"_";
    }else{
        s<<pathPrefix<<filePrefix<<"_";
    }
    path = s.str();

    //DWI
    std::string dwiString;
    if(strcmp(env, "bass_krabbe") == 0 || strcmp(env, "local") == 0 || strcmp(env, "local_krabbe") == 0 || strcmp(env, "bass_krabbe_temp") == 0 || strcmp(env, "local_krabbe_temp") == 0){
        dwiString = "DWI_";
    }else if(strcmp(env, "bass_normal") == 0 || strcmp(env, "local_normal") == 0 || strcmp(env, "bass_normal_temp") == 0 || strcmp(env, "local_normal_temp") == 0){
        dwiString = "";
    }
    dwiImgFileName = path + dwiString + "QCed.nhdr";
    faImgFileName = path + dwiString + "QCed_FA.nrrd";
    if(strcmp(env, "local") == 0){
        maskImgFileName = path + dwiString + "QCed_FA_betPP_mask.nrrd";
    }else{
        maskImgFileName = path + dwiString + "QCed_FA_betPP_mask.nhdr";
    }
    if(strcmp(dataName, "11053_0816") == 0){
        fiberTractsImgFileName = path + dwiString + "QCed_0.3FA_8seeds_tracts.vtk";
    }else if(strcmp(env, "bass_krabbe_temp") == 0 || strcmp(env, "bass_normal_temp") == 0 || strcmp(env, "local_krabbe_temp") == 0 || strcmp(env, "local_normal_temp") == 0){
        fiberTractsImgFileName = path + dwiString + "QCed_80seeds_tracts.nrrd";
    }else{
        fiberTractsImgFileName = path + dwiString + "QCed_0.3FA_8seeds_tracts.nrrd";
    }
    vCounterImgFileName = path + "Volume_Counter.nrrd";
    idwiMaskImgFileName = path + "QCed_IDWImask.nhdr";
    enImgFileName = path + "entropyResult.nrrd";
    foImgFileName = path + "fiberOrientationsPerVoxel.txt";
    dImgFileName = path + "fiberDistancesPerVoxel.txt";
    fsImgFileName = path + "fiberSegmentsPerVoxel.nrrd";
    percent_75_img = path + "FiberDistance_75_Percentile.nrrd";
    combined_result = path + "combined_result.nrrd";
    new_combined_result = path + "new_combined_result.nrrd";
    ncc_fs_fo_img = path + "ncc_fs_fo.nrrd";
    ncc_fs_en_img = path + "ncc_fs_en.nrrd";
    ncc_fo_en_img = path + "ncc_fo_en.nrrd";
    emdImgFileName = path + "earth_movers_dist.nrrd";
    entropy_erf_img = path + "entropy_erf.nrrd";
    fs_erf_img = path + "fs_erf.nrrd";
    emd_erf_img = path + "emd_erf.nrrd";
    cubic_root_img = path + "cubic_root.nrrd";

    //Debug
    /*
    output2("dwi = ", dwiImgFileName);
    output2("fa = ", faImgFileName);
    output2("mask = ", maskImgFileName);
    output2("vCounter = ", vCounterImgFileName);
    output2("entropy = ", enImgFileName);
    output2("fiberOrientation = ", foImgFileName);
    output2("fiberDistances = ", dImgFileName);
    output2("fiberSegmentsPerVoxel = ", fsImgFileName);
    output2("75th Percentile Image = ", percent_75_img);
    output2("Combined Result = ", combined_result);
    */
    return path;
}
