function compute_EMD(inFile, maskFile, outFile)      
    % Read the fiber distances file    
    fd = fopen(inFile, 'r');
    mask = fopen(maskFile, 'r');
    
    fd_line = fgetl(fd);
    if fd_line == -1
        display('Fiber distances file not found, exiting');
        exit;
    end
    mask_line = fgetl(mask);
    if mask_line == -1
        display('Mask file not found or file is empty, exiting');
        exit;
    end
    beginData = 0;
    j = 1;
    xmax = 0; ymax = 0; zmax = 0;
    op_fid = fopen(outFile, 'w');
        
    % Skip header
    while ~beginData
        if ~beginData
            [matchStart1] = regexp(fd_line, 'size=', 'start'); 
            if ~isempty(matchStart1)
                psize = regexp(fd_line, '=', 'split');
                size_arr = regexp(char(psize(2)), ' ', 'split');
                xmax = str2num(char(size_arr(1)));
                ymax = str2num(char(size_arr(2)));
                zmax = str2num(char(size_arr(3)));            
            end
            [matchStart2] = regexp(fd_line, 'begin data', 'start');        
            if ~isempty(matchStart2)
                beginData = 1;
                fd_line = fgetl(fd);
            else
                fd_line = fgetl(fd);
                continue;                
            end
        end
    end
    emd_size = xmax*ymax*zmax;
    emd_arr = zeros(emd_size, 4);    
    j = 1;
    fprintf('\nPercentage complete = ');
    
    while 1
        [matchStart3] = regexp(fd_line, 'voxel=', 'start'); 
        if ~isempty(matchStart3)
            pvoxel = regexp(fd_line, '=', 'split');
            voxel_pos = regexp(char(pvoxel(2)), ' ', 'split');
            xval = str2num(char(voxel_pos(1)));
            yval = str2num(char(voxel_pos(2)));
            zval = str2num(char(voxel_pos(3)));            
       
            % Get Mask
            pmask_voxel = regexp(mask_line, ',', 'split');
            xmask = str2num(char(pmask_voxel(1)));
            ymask = str2num(char(pmask_voxel(2)));
            zmask = str2num(char(pmask_voxel(3)));            
            maskval = str2num(char(pmask_voxel(4)));            
            mask_line = fgetl(mask);

            % Get Size
            fd_line = fgetl(fd);
            psize_voxel = regexp(fd_line, '=', 'split');
            size_val = str2num(char(psize_voxel(2)));

            if xmask == xval && ymask == yval && zmask == zval && maskval == 1 && size_val > 0
                count = size_val;
                i = 1;
                hist_data1 = zeros(1, size_val);
                while count > 0
                    fd_line = fgetl(fd);
                    hist_data1(i) = str2num(fd_line);
                    count = count - 1;
                    i = i + 1;                
                end
                % Compute Normalized histogram bin values
                nbins = 100;
                %hist_data1 = importfile(inFile);
                [n1 h1] = hist(hist_data1, nbins);
                norm_1 = n1 / trapz(h1, n1);
                hist1 = h1(:);    
                norm1 = norm_1(:);

                % Refer http://en.wikipedia.org/wiki/Half-normal_distribution
                m = 0;
                s = 15 * 2 * pi / 360;
                x = hist1;
                hist2 = hist1;
                y = ( sqrt(2 / pi) / s ) * exp ( - ( x.^2 ) / ( 2 * s * s) );
                norm2 = y;
                %plot(x,norm2);

                THRESHOLD = 3;    
                P = norm1;
                Q = norm2;
                N = nbins;
                D = ones(N,N).*THRESHOLD;
                extra_mass_penalty= -1;
                flowType= 3;       
                for m=1:N
                    for n=max([1 m-THRESHOLD+1]):min([N m+THRESHOLD-1])
                        D(m,n)= abs(m-n); 
                    end
                end        
                [emd_val flow]= emd_hat_gd_metric_mex(P,Q,D,extra_mass_penalty,flowType);                    
            else
                emd_val = 0.0;
            end
            if xmask == xval && ymask == yval && zmask == zval
                emd_arr(j,1) = xmask;
                emd_arr(j,2) = ymask;
                emd_arr(j,3) = zmask;
                emd_arr(j,4) = emd_val;
                j = j + 1;
            else
                display('Error !!! mask index and fd index are not equal');
                fprintf('mask = %d %d %d\n', xmask, ymask, zmask);
                fprintf('fd = %d %d %d\n', xval, yval, zval);
                return;
            end
            if mod(j, 100000) == 0
                fprintf('%.0f..', j / emd_size * 100);
            end
        end
        fd_line = fgetl(fd);
        [matchStart4] = regexp(fd_line, 'end data', 'start'); 
        if ~isempty(matchStart4)
            break;
        end        
    end
    fprintf('100\n');
    display('Writing to file..please be patient');
    for i = 1 : emd_size
        fprintf(op_fid, '%d,%d,%d,%f\n', emd_arr(i,1), emd_arr(i,2), emd_arr(i,3), emd_arr(i,4));
    end    
    display('Finished with Matlab code');
end    
