function compute_EMD(inFile, maskFile, outFile)      
    % Read the fiber distances file    
    fd = fopen(inFile);
    mask = fopen(maskFile);
    
    fd_line = fgetl(fd);
    mask_line = fgetl(mask);
    beginData = 0;
    j = 1;
    xmax = 0; ymax = 0; zmax = 0;
    op_fid = fopen(outFile, 'w');
        
    % Skip header
    while ~beginData
        if ~beginData
            [matchStart1] = regexp(fd_line, 'size=', 'start'); 
            if ~isempty(matchStart1)
                psize = regexp(fd_line, '=', 'split');
                size_arr = regexp(char(psize(2)), ' ', 'split');
                xmax = str2num(char(size_arr(1)));
                ymax = str2num(char(size_arr(2)));
                zmax = str2num(char(size_arr(3)));            
            end
            [matchStart2] = regexp(fd_line, 'begin data', 'start');        
            if ~isempty(matchStart2)
                beginData = 1;
                fd_line = fgetl(fd);
            else
                fd_line = fgetl(fd);
                continue;                
            end
        end
    end
    ent_size = xmax*ymax*zmax;
    ent_arr = zeros(ent_size, 4);    
    j = 1;
    fprintf('\nPercentage complete = ');
    
    while 1
        [matchStart3] = regexp(fd_line, 'voxel=', 'start'); 
        if ~isempty(matchStart3)
            pvoxel = regexp(fd_line, '=', 'split');
            voxel_pos = regexp(char(pvoxel(2)), ' ', 'split');
            xval = str2num(char(voxel_pos(1)));
            yval = str2num(char(voxel_pos(2)));
            zval = str2num(char(voxel_pos(3)));            
       
            % Get Mask
            pmask_voxel = regexp(mask_line, ',', 'split');
            xmask = str2num(char(pmask_voxel(1)));
            ymask = str2num(char(pmask_voxel(2)));
            zmask = str2num(char(pmask_voxel(3)));            
            maskval = str2num(char(pmask_voxel(4)));            
            mask_line = fgetl(mask);

            % Get Size
            fd_line = fgetl(fd);
            psize_voxel = regexp(fd_line, '=', 'split');
            size_val = str2num(char(psize_voxel(2)));

            if xmask == xval && ymask == yval && zmask == zval && maskval == 1 && size_val > 0
                count = size_val;
                i = 1;
                hist_data1 = zeros(1, size_val);
                while count > 0
                    fd_line = fgetl(fd);
                    hist_data1(i) = str2num(fd_line);
                    count = count - 1;
                    i = i + 1;                
                end
                % Compute Normalized histogram bin values
                nbins = 100;
                %hist_data1 = importfile(inFile);
                [n1 h1] = hist(hist_data1, nbins);
                p1 = n1 / sum(n1);
                entropy = 0.0;
                for i = 1 : size(p1,2)
                    if p1(i) > 0
                        entropy = entropy + p1(i) * log(p1(i));
                    end       
                end            
                entropy = -1 * entropy;
            else
                entropy = 0.0;
            end
            if xmask == xval && ymask == yval && zmask == zval
                ent_arr(j,1) = xmask;
                ent_arr(j,2) = ymask;
                ent_arr(j,3) = zmask;
                ent_arr(j,4) = entropy;
                j = j + 1;
            else
                display('Error !!! mask index and fd index are not equal');
                fprintf('mask = %d %d %d\n', xmask, ymask, zmask);
                fprintf('fd = %d %d %d\n', xval, yval, zval);
                return;
            end
            if mod(j, 100000) == 0
                fprintf('%.0f..', j / ent_size * 100);
            end
        end
        fd_line = fgetl(fd);
        [matchStart4] = regexp(fd_line, 'end data', 'start'); 
        if ~isempty(matchStart4)
            break;
        end        
    end
    fprintf('100\n');
    display('Writing to file..please be patient');
    for i = 1 : ent_size
        fprintf(op_fid, '%d,%d,%d,%f\n', ent_arr(i,1), ent_arr(i,2), ent_arr(i,3), ent_arr(i,4));
    end    
    display('Finished with Matlab code');
end    