clc;
mode = 'normal_';
%mode = 'krabbe_';
if strcmp(mode, 'normal_')
    path = '/media/Data2/Research/result/normal/';
    files1 = dir('/media/Data2/Research/result/normal/neo-0106-1-1year_dwi_35_sf*_voxel_hist.txt');
    files2 = dir('/media/Data2/Research/result/normal/neo-0106-1-1year_dwi_35_cf*_voxel_hist.txt');
    outpath = '/home/ravikiran/Desktop/emd/normal';
else
    path = '/media/Data2/Research/result/krabbe/';
    files1 = dir('/media/Data2/Research/result/krabbe/11048_060908_sf*_voxel_hist.txt');
    files2 = dir('/media/Data2/Research/result/krabbe/11048_060908_cf*_voxel_hist.txt');
    outpath = '/home/ravikiran/Desktop/emd/krabbe';
end
nbins = 100;
for i = 1 : numel(files1)    
    if strcmp(mode, 'normal_')
        if i ~= 2 && i ~=4
            continue;
        end
    else
        if i ~= 1 && i ~= 2
            continue;
        end
    end
    f1 = strcat(path, files1(i).name);
    display(f1);
    f1_data = importfile(f1);
    f1_range = 0:bin_interval:pi;
    [n1 h1] = hist(f1_data, nbins);
    norm1 = n1 / trapz(h1, n1);
    for j = 1 : numel(files2)         
        if strcmp(mode, 'normal_')
            if j ~= 2 && j ~=4
                continue;
            end
        else
            if j ~=2 && j ~= 3
                continue;
            end
        end        
        f2 = strcat(path, files2(j).name);    
        display(f2);
        f2_data = importfile(f2);        
        f2_range = 0:bin_interval:pi;        
        [n2 h2] = hist(f2_data, nbins);        
        norm2 = n2 / trapz(h2, n2);
        hist1 = h1(:);
        hist2 = h2(:);        
        THRESHOLD= 3;
        P = hist1;
        Q = hist2;
        N = nbins;
        D = ones(N,N).*THRESHOLD;
        extra_mass_penalty= -1;
        flowType= 3;       
        for m=1:N
            for n=max([1 m-THRESHOLD+1]):min([N m+THRESHOLD-1])
                D(m,n)= abs(m-n); 
            end
        end        
        [emd_val flow]= emd_hat_gd_metric_mex(P,Q,D,extra_mass_penalty,flowType);                
        % Results
        wtext = sprintf('EMD = %f', emd_val);
        figure();        
        subplot(121);bar(hist1, norm1);title(strcat(mode,' SF No. ', num2str(i)));        
        subplot(122);bar(hist2, norm2);title(strcat(mode,' CF No. ', num2str(j)));  
        if strcmp(mode, 'normal_') && j == 1
            text(-0.5,7.3,wtext,'FontSize', 40);
        else            
            text(-0.5,2.6,wtext,'FontSize', 40);
        end
        output = strcat(outpath,'/sf',num2str(i),'_cf',num2str(j),'.png');        
        saveas(gcf, output);                            
    end           
end
disp('Done');