datasets = cellstr(['11048'; '11051'; '11053'; '11054';'11063';'11066';'11067']);
%datasets = cellstr(['11053']);
for i = 1 : size(datasets,1)    
    dataset = char(datasets(i));
    display(strcat('Started processing dataset', ' ', dataset));
    filePath = '/media/Core/Research/result/';
    path = strcat(filePath, dataset, '/');

    if strcmp(dataset, '11053')
        filePrefix = '11053_0816';
    elseif strcmp(dataset, '11048')
        filePrefix = '11048_092309';
    elseif strcmp(dataset, '11051')
        filePrefix = '11051_051909';
    elseif strcmp(dataset, '11054')
        filePrefix = '11054_101408';
    elseif strcmp(dataset, '11063')
        filePrefix = '11063_082009';
    elseif strcmp(dataset, '11066')
        filePrefix = '11066_082310';
    elseif strcmp(dataset, '11067')
        filePrefix = '11067_012511';
    end

    enImgFileName = strcat(path,filePrefix,'_en_histo.txt');    
    enOutput = strcat(path,filePrefix,'_en_histo.png');
    foImgFileName = strcat(path,filePrefix,'_fo_histo.txt');
    foOutput = strcat(path,filePrefix,'_fo_histo.png');
    fsImgFileName = strcat(path,filePrefix,'_fs_histo.txt');
    fsOutput = strcat(path,filePrefix,'_fs_histo.png');

    display('Writing Entropy Histogram');
    enData = importfile(enImgFileName);
    %enData = importfile('/media/Core/Research/result/11048/11048_092309_en_histo.txt');
    enRange = min(enData):0.1:max(enData);
    hist(enData ,enRange);
    minEn = min(enData);
    maxEn = max(enData);
    title(strcat(dataset, ' Entropy Histogram'));
    h = get(gca, 'children');
    saveas(h, enOutput);

    display('Writing Fiber Orientation Histogram');
    foData = importfile(foImgFileName);
    foRange = min(foData):0.1:max(foData);
    hist(foData ,foRange);
    title(strcat(dataset, ' Fiber Orientation Histogram'));
    h = get(gca, 'children');
    saveas(h, foOutput);

    display('Writing Fiber Segments per voxel Histogram');
    fsData = importfile(fsImgFileName);
    fsRange = min(fsData):50:max(fsData);
    hist(fsData ,fsRange);
    title(strcat(dataset, ' Fiber Segments per voxel Histogram'));
    h = get(gca, 'children');
    saveas(h, fsOutput);
    display(strcat('Finished processing dataset ',dataset));    
end
display('Done');