path = '/media/Core/Research/result/11053/';
files = dir('/media/Core/Research/result/11053/*_voxel_hist.txt');
for i = 1 : numel(files);   
    f = strcat(path, files(i).name);
    [matchstart,matchend,tokenindices,matchstring,tokenstring, tokenname,splitstring] = regexpi(f, '.txt');
    output = strcat(splitstring{1}, '.png');              
    category = '';
    [match_start] = regexpi(f, 'sf');
    if size(match_start,1) ~= 0
        category = 'Single Fiber ';
    end
    [match_start] = regexpi(f, 'cf');
    if size(match_start,1) ~= 0
        category = 'Crossing Fiber ';
    end
    [match_start] = regexpi(f, 'gm');
    if size(match_start,1) ~= 0
        category = 'Gray Matter ';
    end    
    f_data = importfile(f);
    f_range = min(f_data):0.01:max(f_data);
    figure;
    %hist(f_data, f_range);
    histfit(f_data, 100, 'rician');
    title(strcat(category, ' Fiber Voxel Histogram'), 'fontsize', 20);
    %h = get(gca, 'children');
    %saveas(h, output);    
end
disp('Done');