
////////////////////////////////////////////////////////////////////////////////
//
// Writes a tensor image either as a VTK image or a set of scalar images
//
////////////////////////////////////////////////////////////////////////////////

#ifndef _DTImageWriter_h
#define _DTImageWriter_h

#include "itkObject.h"

#include "DTImage.h"

#include "DynArray.h"

class DTImageWriter: public itk::Object
{

public:

  typedef DTImageWriter Self;
  typedef itk::SmartPointer<Self> Pointer;
  typedef itk::SmartPointer<const Self> ConstPointer;

  itkNewMacro(Self);

  typedef itk::Image<float, 3> FloatImageType;
  typedef FloatImageType::Pointer FloatImagePointer;

  typedef itk::Image<short, 3> ShortImageType;
  typedef ShortImageType::Pointer ShortImagePointer;
  typedef ShortImageType::RegionType ShortImageRegionType;
  typedef ShortImageType::IndexType ShortImageIndexType;
  typedef ShortImageType::SizeType ShortImageSizeType;

  void SetInput(DTImageType* dti);

  void SetGradients(const DynArray<DiffusionTensor::MatrixType>& gradlist);

  void WriteRawImages(const char* basename);
  void WriteStackedImage(const char* fname);
  void WriteVTKImage(const char* fname);

  itkSetMacro(BFactor, float);
  itkGetMacro(BFactor, float);

protected:

  DTImageWriter();
  ~DTImageWriter();

  DTImagePointer m_Input;

  DynArray<DiffusionTensor::MatrixType> m_Gradients;

  float m_BFactor;

};

#endif
