
#ifndef _VonMisesFisherDistribution_h
#define _VonMisesFisherDistribution_h

#include <vnl/vnl_matrix.h>
#include <vnl/vnl_vector.h>

class VonMisesFisherDistribution
{
public:

  typedef float ScalarType;

  typedef vnl_matrix<ScalarType> MatrixType;
  typedef vnl_vector<ScalarType> VectorType;

  VonMisesFisherDistribution();
  VonMisesFisherDistribution(const VectorType& mu, float k);

  ~VonMisesFisherDistribution();

  void Initialize(const VectorType& mu, float k);

  VectorType Generate();

  float EvaluateDensity(const VectorType& x);

protected:

  VectorType m_Mu;
  float m_K;

  unsigned int m_Dim;
  float m_X0;
  float m_M;
  float m_B;
  float m_C;

  MatrixType m_RotM;

};

#endif
