
////////////////////////////////////////////////////////////////////////////////
//
// Resample DTI using affine transform
//
////////////////////////////////////////////////////////////////////////////////

#ifndef _DTImageResampleFilter_h
#define _DTImageResampleFilter_h

#include "itkAffineTransform.h"
#include "itkSmartPointer.h"

#include "vnl/vnl_vector.h"

#include "DTImage.h"

#include "itkImageToImageFilter.h"

class DTImageResampleFilter:
  public itk::ImageToImageFilter<DTImageType, DTImageType>
{

public:

  typedef DTImageResampleFilter Self;
  typedef itk::SmartPointer<Self> Pointer;
  typedef itk::SmartPointer<const Self> ConstPointer;

  itkNewMacro(Self);

  typedef itk::AffineTransform<double, 3> TransformType;
  typedef TransformType::Pointer TransformPointer;
  typedef TransformType::InputPointType PointType;

  typedef vnl_vector<double> VNLVectorType;

  // World-to-world transform for resampling
  void SetTarget2SourceTransform(TransformType* t)
  {
    m_T2STrafo = t; this->Modified();
  }

  void SetOutputSize(const DTImageSizeType& size)
  {
    m_OutputSize = size; this->Modified();
  }

  void SetOutputSpacing(const DTImageSpacingType& spacing)
  {
    m_OutputSpacing = spacing; this->Modified();
  }

  void SetOutputOrigin(const DTImagePointType& origin)
  {
    m_OutputOrigin = origin;
  }

  void SetOutputDirection(const DTImageDirectionType& dir)
  {
    m_OutputDirection = dir;
  }

  void SetOutputParametersFromImage(DTImagePointer img)
  {
    this->SetOutputOrigin( img->GetOrigin() );
    this->SetOutputSpacing( img->GetSpacing() );
    this->SetOutputDirection( img->GetDirection() );
    this->SetOutputSize( img->GetLargestPossibleRegion().GetSize() );
  }

protected:

  DTImageResampleFilter();
  ~DTImageResampleFilter();

  void GenerateData();

  DTImagePointType m_OutputOrigin;
  DTImageSizeType m_OutputSize;
  DTImageSpacingType m_OutputSpacing;
  DTImageDirectionType m_OutputDirection;

  TransformPointer m_T2STrafo;

};

#endif
