
////////////////////////////////////////////////////////////////////////////////
//
// Math for tensors represented as matrices, follows Fletcher and Joshi
//
// Assumes input matrices are symmetric, positive-definite, 3x3 matrices (PD(3))
//
////////////////////////////////////////////////////////////////////////////////

#ifndef _TensorMatrixMath
#define _TensorMatrixMath

#include "DiffusionTensor.h"

namespace TensorMatrixMath
{

typedef DiffusionTensor::MatrixType MatrixType;

MatrixType expMap(const MatrixType& p, const MatrixType& X);
MatrixType logMap(const MatrixType& p, const MatrixType& X);

float innerProduct(
  const MatrixType& p, const MatrixType& X, const MatrixType& Y);
float norm(const MatrixType& p, const MatrixType& X);

MatrixType mean(MatrixType* tarray, float* weights, unsigned int n);

}

#endif
